/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import com.vaadin.flow.spring.annotation.EnableVaadin;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.HledExecutorNG;
import cz.kpsys.db.SearchCachePool;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.services.ObalkyKnihService;
import cz.kpsys.kpwin2.tasks.ObalkyKnihInvalidateCache;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.StaticCacheFactory;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.integ.feign.FeignConfig;
import cz.kpsys.portaro.logging.LoggingAspect;
import cz.kpsys.portaro.logging.TraceIdAddingCronAspect;
import cz.kpsys.portaro.logging.TraceIdRepository;
import cz.kpsys.portaro.logging.UuidMdcTraceIdRepository;
import cz.kpsys.portaro.verbisboxer.manager.VerbisboxerManagerConfig;
import cz.kpsys.service.ForcedUpdateService;
import cz.kpsys.service.KPUtils;
import cz.kpsys.service.MessagesQueueManagerNG;
import cz.kpsys.service.TimeslotUtils;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.ws.config.annotation.EnableWs;

@SpringBootApplication(scanBasePackages={"cz.kpsys.as.config", "cz.kpsys.kpwin2.vsb"}, exclude={DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class, HibernateJpaAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, FreeMarkerAutoConfiguration.class, MailSenderAutoConfiguration.class, JacksonAutoConfiguration.class, BatchAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, SecurityAutoConfiguration.class})
@Import(value={FeignConfig.class, VerbisboxerManagerConfig.class})
@org.springframework.context.annotation.Configuration
@EnableScheduling
@EnableAspectJAutoProxy
@EnableVaadin(value={"cz.kpsys.kpwin2.webface"})
@EnableWs
public class AppserverApplication
implements SchedulingConfigurer {
    @Logged
    @Scheduled(cron="0 50 3 * * *")
    public void cronInvalidateAllCaches() {
        this.cacheService().invalidateAllCaches();
    }

    @Logged
    @Scheduled(cron="0 0,30 * * * *")
    public void cronResendFailedEmails() {
        MessagesQueueManagerNG.requeueFailedEmails();
    }

    @Logged
    @Scheduled(cron="0 10 0 * * *")
    public void cronDeleteAllObsoleteOrders() {
        this.timeslotUtils().deleteAllObsoleteOrders();
    }

    @Logged
    @Scheduled(initialDelay=240000L, fixedDelay=600000L)
    public void cronCheckForcedUpdate() {
        ForcedUpdateService.doCheck();
    }

    @Logged
    @Scheduled(initialDelay=120000L, fixedDelay=0x7FFFFFFFFFFFFFFFL)
    public void cronForceCacheReload() throws SQLException {
        if (!KPWINServiceApplication.internalBuild()) {
            DbCache2.cacheAll();
        }
    }

    @Logged
    @Scheduled(initialDelay=300000L, fixedDelay=300000L)
    public void cronCheckSearchCacheCleanup() {
        HledExecutorNG.doSearchCacheCleanup();
        SearchCachePool.logujPocetAktivnich();
    }

    @Logged
    @Scheduled(cron="2 40 0 * * *")
    public void cronInvalidateOKCache() {
        KPUtils.randomDelay((Duration)Duration.ofMinutes(60L));
        ObalkyKnihInvalidateCache.invalidate();
    }

    @Logged
    @Scheduled(initialDelay=300000L, fixedDelay=1800000L)
    public void cronRequeueFailedEmails() {
        MessagesQueueManagerNG.requeueFailedEmails();
    }

    @Logged
    @Scheduled(cron="22 22 0 ? * SAT,TUE")
    public void cronObalkyPerioRefresh() {
        ObalkyKnihService.schedulePeriodikaToUpdate();
    }

    @Logged
    @Scheduled(cron="22 22 22 * * *")
    public void cronObalkyKnihMainetance() {
        ObalkyKnihService.preplanujErrory();
    }

    @Bean
    public Configuration configuration() {
        return Objects.requireNonNull(KPWINServiceApplication.configuration);
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(20);
        taskScheduler.initialize();
        taskRegistrar.setTaskScheduler((TaskScheduler)taskScheduler);
    }

    @Bean
    public LoggingAspect loggingCronAspect() {
        return new LoggingAspect();
    }

    @Bean
    public TraceIdAddingCronAspect traceIdAddingCronAspect() {
        return new TraceIdAddingCronAspect(this.traceIdRepository());
    }

    @Bean
    public TraceIdRepository traceIdRepository() {
        return new UuidMdcTraceIdRepository();
    }

    @Bean
    public CacheService cacheService() {
        return new CacheService(this.cacheManager());
    }

    @Bean
    public TimeslotUtils timeslotUtils() {
        return new TimeslotUtils();
    }

    @Bean
    public CacheManager cacheManager() {
        return new ConcurrentMapCacheManager();
    }

    @Bean
    public StaticCacheFactory staticCacheFactory() {
        return new StaticCacheFactory.FullCacheReturningFactory();
    }

    @Bean
    public Provider<@NonNull String> userAgentProvider() {
        return StaticProvider.of((Object)("VerbisAppserver/" + KPWINServiceApplication.versionString));
    }

    @Generated
    public AppserverApplication() {
    }
}

