/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.utils.Log4jDataSource;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;

public class DataSourceFactory {
    @NonNull
    private final DatabaseConnectionSettings databaseProperties;

    public Log4jDataSource createDataSource(boolean longRunning, boolean autoCommitting, int maxPoolSize) {
        String suffix;
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(this.databaseProperties.getDriverClassName());
        config.setJdbcUrl(this.databaseProperties.getUrl());
        config.setUsername(this.databaseProperties.getUsername());
        config.setPassword(this.databaseProperties.getPassword());
        config.setAutoCommit(autoCommitting);
        if (Stream.of("lc_ctype", "encoding").noneMatch(parameter -> this.databaseProperties.getUrl().toLowerCase().contains((CharSequence)parameter))) {
            config.setDataSourceProperties(this.databaseProperties.getConnectionProperties());
        }
        config.setConnectionInitSql(null);
        config.setRegisterMbeans(true);
        config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(10L));
        config.setMaxLifetime(TimeUnit.MINUTES.toMillis(20L));
        config.setIdleTimeout(TimeUnit.MINUTES.toMillis(3L));
        config.setMaximumPoolSize(maxPoolSize);
        String string = suffix = maxPoolSize == 1 ? "-single-conn" : "";
        if (longRunning) {
            config.setPoolName("longruninng" + suffix);
            config.setLeakDetectionThreshold(TimeUnit.MINUTES.toMillis(5L));
        } else {
            config.setPoolName("main" + suffix);
            config.setLeakDetectionThreshold(TimeUnit.SECONDS.toMillis(30L));
        }
        return new Log4jDataSource((DataSource)new HikariDataSource(config));
    }

    @ConstructorProperties(value={"databaseProperties"})
    @Generated
    public DataSourceFactory(@NonNull DatabaseConnectionSettings databaseProperties) {
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        this.databaseProperties = databaseProperties;
    }
}

