/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.as.commons.repo.TransactionAuthenticator;
import cz.kpsys.as.commons.repo.UserContextRepository;
import cz.kpsys.as.config.CompositeUpdateRunner;
import cz.kpsys.as.config.DataSourceFactory;
import cz.kpsys.as.config.SettingKeys;
import cz.kpsys.as.db.DatabaseScriptCaller;
import cz.kpsys.common.Licensing;
import cz.kpsys.db.DbConfig;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.portaro.commons.barcode.ValidLengthBarCodeValidator;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.account.AccountEntity;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWayEntity;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroupEntity;
import cz.kpsys.portaro.file.FileAccessTypeEntity;
import cz.kpsys.portaro.location.LocationEntity;
import cz.kpsys.portaro.record.fond.FondEntity;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingEntityId;
import cz.kpsys.portaro.setting.JdbcStaticDepartmentCustomSettingValueLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.setting.StaticDepartmentCustomSettingValueLoader;
import cz.kpsys.portaro.sql.generator.DbSpecifics;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.SearchingMultiTryingSuUserIdProvider;
import cz.kpsys.portaro.user.SpringDbUserIdSearchLoader;
import cz.kpsys.portaro.verbisbox.station.BoxStationEntity;
import cz.kpsys.service.ConnectionCheckerService;
import cz.kpsys.utils.Log4jDataSource;
import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestOperations;

@org.springframework.context.annotation.Configuration
@EnableJpaRepositories
@EnableTransactionManagement
public class DatabaseBeansConfig {
    private static final String HBM2DDL_NONE = "";
    @NonNull
    private final Configuration configuration;
    @NonNull
    private final DbConfig dbConfig;
    @NonNull
    private final Provider<ZoneId> databaseColumnsTimeZoneProvider;
    @NonNull
    private final DatabaseConnectionSettings databaseProperties;
    @NonNull
    private final ConnectionCheckerService connectionCheckerService;
    @NonNull
    private final DataSourceFactory dataSourceFactory;
    @NonNull
    private final DbSpecifics dbSpecifics;
    @NonNull
    private final StaticProvider<Integer> initRootDepartmentIdProvider;
    @NonNull
    private final Provider<Department> initRootDepartmentProvider;
    @NonNull
    private final RestOperations rest;

    @Bean
    public DataSource dataSource() {
        this.connectionCheckerService.waitForDbOnline();
        try (Log4jDataSource appserverUpdateDataSource = this.dataSourceFactory.createDataSource(true, false, 1);
             Log4jDataSource portaroUpdateDataSource = this.dataSourceFactory.createDataSource(true, true, 1);){
            JdbcStaticDepartmentCustomSettingValueLoader initCustomSettingLoader = new JdbcStaticDepartmentCustomSettingValueLoader((JdbcOperations)new JdbcTemplate((DataSource)portaroUpdateDataSource), this.dbSpecifics, (Provider)this.initRootDepartmentIdProvider);
            CompositeUpdateRunner updater = new CompositeUpdateRunner(this.dbConfig, this.configuration, (DataSource)appserverUpdateDataSource, (DataSource)appserverUpdateDataSource, (DataSource)portaroUpdateDataSource, this.databaseProperties, new NamedParameterJdbcTemplate((DataSource)portaroUpdateDataSource), (StaticDepartmentCustomSettingValueLoader)initCustomSettingLoader, this.initRootDepartmentProvider, this.queryFactory(), this.rest, (Provider)initCustomSettingLoader.getProvider((SettingTypeId)SettingKeys.SERIAL_CODE).cached(), (Provider)initCustomSettingLoader.getProvider((SettingTypeId)SettingKeys.KPSYS_API_KEY).cached(), initCustomSettingLoader.getProvider((SettingTypeId)SettingKeys.EXTERNAL_RESOURCES_FOND));
            updater.updateResources();
        }
        return this.dataSourceFactory.createDataSource(false, false, 10);
    }

    @DependsOn(value={"dataSource"})
    @Bean
    public DataSource autoCommittingDataSource() {
        return this.dataSourceFactory.createDataSource(false, true, 10);
    }

    @DependsOn(value={"dataSource"})
    @Bean
    public DataSource longRunningAutoCommittingDataSource() {
        return this.dataSourceFactory.createDataSource(true, true, 10);
    }

    @DependsOn(value={"dataSource"})
    @Bean
    public Licensing licensing() {
        return new Licensing();
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager bean = new JpaTransactionManager();
        bean.setEntityManagerFactory(this.entityManagerFactory().getObject());
        return bean;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.dataSource());
        em.setPackagesToScan(new String[]{AccountEntity.class.getPackage().getName(), AcquisitionWayEntity.class.getPackage().getName(), BoxStationEntity.class.getPackage().getName(), CustomSettingEntity.class.getPackage().getName(), FileAccessTypeEntity.class.getPackage().getName(), FondEntity.class.getPackage().getName(), LocationEntity.class.getPackage().getName(), ThematicGroupEntity.class.getPackage().getName()});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        HashMap<String, Object> jpaProps = new HashMap<String, Object>();
        jpaProps.put("hibernate.hbm2ddl.auto", HBM2DDL_NONE);
        jpaProps.put("hibernate.dialect", DatabaseConnectionSettings.getHibernateDialect((String)this.databaseProperties.getType()));
        jpaProps.put("hibernate.show_sql", "false");
        jpaProps.put("hibernate.format_sql", "true");
        jpaProps.put("hibernate.jdbc.time_zone", this.databaseColumnsTimeZoneProvider.get());
        jpaProps.put("hibernate.type.preferred_instant_jdbc_type", 93);
        jpaProps.put("hibernate.type.preferred_uuid_jdbc_type", "CHAR");
        em.setJpaPropertyMap(jpaProps);
        return em;
    }

    @Bean(value={"longRunningAutoCommittingJdbcTemplate", "fileStreamAutoCommittingJdbcTemplate"})
    public NamedParameterJdbcOperations longRunningAutoCommittingJdbcTemplate() {
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.longRunningAutoCommittingDataSource());
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setQueryTimeout((int)TimeUnit.MINUTES.toSeconds(10L));
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setMaxRows(20000);
        return jdbcTemplate;
    }

    @Bean
    public NamedParameterJdbcOperations autoCommittingJdbcTemplate() {
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.autoCommittingDataSource());
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setQueryTimeout(35);
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setMaxRows(20000);
        return jdbcTemplate;
    }

    @Bean
    public QueryFactory queryFactory() {
        return new QueryFactory(this.dbSpecifics);
    }

    @Bean
    public JpaRepositoryFactoryBean<UserContextRepository, CustomSettingEntity, CustomSettingEntityId> userContextRepositoryBean() {
        return new JpaRepositoryFactoryBean(UserContextRepository.class);
    }

    @Bean
    public UserContextRepository userContextRepository() {
        return (UserContextRepository)this.userContextRepositoryBean().getObject();
    }

    @Bean
    public Provider<Integer> suUserIdProvider() {
        SpringDbUserIdSearchLoader userIdSearchLoader = new SpringDbUserIdSearchLoader(this.autoCommittingJdbcTemplate(), this.queryFactory(), () -> new ValidLengthBarCodeValidator((Provider)StaticProvider.of((Object)13)));
        return new SearchingMultiTryingSuUserIdProvider((PageSearchLoader)userIdSearchLoader, "SU").cached();
    }

    @Bean
    public Runnable saveTransactionAuthenticator() {
        TransactionAuthenticator transactionAuthenticator = new TransactionAuthenticator(this.suUserIdProvider(), this.userContextRepository());
        return () -> ((TransactionAuthenticator)transactionAuthenticator).authenticateAsAppserver();
    }

    @Scheduled(initialDelay=15000L, fixedDelay=0x7FFFFFFFFFFFFFFFL)
    public void recomputeDatabaseIndices() {
        new DatabaseScriptCaller(this.autoCommittingDataSource(), "prepocet selektivity indexu", DatabaseScriptCaller.INDICES_RECOMPUTE_SQL).call();
    }

    @Scheduled(initialDelay=17000L, fixedDelay=0x7FFFFFFFFFFFFFFFL)
    public void deleteObsoletePozRez() {
        new DatabaseScriptCaller(this.autoCommittingDataSource(), "smazani proslych pozadavku na rezervace", DatabaseScriptCaller.CLEANUP_OBSOLETE_POZREZ_SQL).call();
    }

    @ConstructorProperties(value={"configuration", "dbConfig", "databaseColumnsTimeZoneProvider", "databaseProperties", "connectionCheckerService", "dataSourceFactory", "dbSpecifics", "initRootDepartmentIdProvider", "initRootDepartmentProvider", "rest"})
    @Generated
    public DatabaseBeansConfig(@NonNull Configuration configuration, @NonNull DbConfig dbConfig, @NonNull Provider<ZoneId> databaseColumnsTimeZoneProvider, @NonNull DatabaseConnectionSettings databaseProperties, @NonNull ConnectionCheckerService connectionCheckerService, @NonNull DataSourceFactory dataSourceFactory, @NonNull DbSpecifics dbSpecifics, @NonNull StaticProvider<Integer> initRootDepartmentIdProvider, @NonNull Provider<Department> initRootDepartmentProvider, @NonNull RestOperations rest) {
        Objects.requireNonNull(configuration, "configuration is marked non-null but is null");
        Objects.requireNonNull(dbConfig, "dbConfig is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(connectionCheckerService, "connectionCheckerService is marked non-null but is null");
        Objects.requireNonNull(dataSourceFactory, "dataSourceFactory is marked non-null but is null");
        Objects.requireNonNull(dbSpecifics, "dbSpecifics is marked non-null but is null");
        Objects.requireNonNull(initRootDepartmentIdProvider, "initRootDepartmentIdProvider is marked non-null but is null");
        Objects.requireNonNull(initRootDepartmentProvider, "initRootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        this.configuration = configuration;
        this.dbConfig = dbConfig;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
        this.databaseProperties = databaseProperties;
        this.connectionCheckerService = connectionCheckerService;
        this.dataSourceFactory = dataSourceFactory;
        this.dbSpecifics = dbSpecifics;
        this.initRootDepartmentIdProvider = initRootDepartmentIdProvider;
        this.initRootDepartmentProvider = initRootDepartmentProvider;
        this.rest = rest;
    }
}

