/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.as.config.SettingKeys;
import cz.kpsys.as.exemplar.Kat15ToExemplarMapper;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.portaro.commons.barcode.ValidLengthBarCodeValidator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.database.InstantiingLabeledIdentifiableLoaderSpringDb;
import cz.kpsys.portaro.department.ContextHierarchySelection;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarRowMapper;
import cz.kpsys.portaro.exemplar.SearchingDepartmentedRecordExemplarsLoader;
import cz.kpsys.portaro.exemplar.SpringDbExemplarAllByIdsLoader;
import cz.kpsys.portaro.exemplar.SpringDbExemplarIdSearchLoader;
import cz.kpsys.portaro.exemplar.accessnumber.AccessNumberSequenceLoader;
import cz.kpsys.portaro.exemplar.accessnumber.SpringDbAccessNumberSequenceLoader;
import cz.kpsys.portaro.exemplar.account.Account;
import cz.kpsys.portaro.exemplar.account.AccountEntity;
import cz.kpsys.portaro.exemplar.account.EntityToAccountConverter;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWay;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWayEntity;
import cz.kpsys.portaro.exemplar.acquisitionway.EntityToAcquisitionWayConverter;
import cz.kpsys.portaro.exemplar.customvalue.CustomValue;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatus;
import cz.kpsys.portaro.exemplar.exemplarstatus.SpringDbExemplarStatusLoader;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.exemplar.loancategory.SpringDbLoanCategoryLoader;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceFactory;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceLoader;
import cz.kpsys.portaro.exemplar.signature.SpringDbSignatureSequenceLoader;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroupEntity;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroupFromDtoConverter;
import cz.kpsys.portaro.location.EntityToLocationConverter;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationEntity;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.ItemCustomizableContextualSearchFunction;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class ExemplarConfig {
    @NonNull
    private final NamedParameterJdbcOperations autoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;

    @Bean
    public ByIdLoadable<Location, Integer> locationLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(LocationEntity.class, "order").convertedEachBy((Converter)new EntityToLocationConverter()).staticCached(Location.class.getSimpleName()).build();
    }

    @Bean
    public ByIdLoadable<ThematicGroup, String> thematicGroupLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(ThematicGroupEntity.class, "order").convertedEachBy((Converter)new ThematicGroupFromDtoConverter()).staticCached(ThematicGroup.class.getSimpleName()).build();
    }

    @Bean
    public ByIdLoadable<LoanCategory, String> loanCategoryLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbLoanCategoryLoader(this.autoCommittingJdbcTemplate, this.queryFactory)).staticCached(LoanCategory.class.getSimpleName()).build();
    }

    @Bean
    public ByIdLoadable<ExemplarStatus, Integer> exemplarStatusLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbExemplarStatusLoader(this.autoCommittingJdbcTemplate, this.queryFactory)).staticCached(ExemplarStatus.class.getSimpleName()).build();
    }

    @Bean
    public ByIdLoadable<AcquisitionWay, String> acquisitionWayLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(AcquisitionWayEntity.class, "order").convertedEachBy((Converter)new EntityToAcquisitionWayConverter()).staticCached(AcquisitionWay.class.getSimpleName()).build();
    }

    @Bean
    public ByIdLoadable<Account, String> accountLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(AccountEntity.class).convertedEachBy((Converter)new EntityToAccountConverter()).staticCached(Account.class.getSimpleName()).build();
    }

    @Bean
    public Codebook<CustomValue, String> customValueLoader() {
        InstantiingLabeledIdentifiableLoaderSpringDb loader = new InstantiingLabeledIdentifiableLoaderSpringDb(this.autoCommittingJdbcTemplate, this.queryFactory, CustomValue.class, "def_stavz", "id_stavz", "popis", "poradi");
        loader.setTrimName(true);
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)loader).staticCached(CustomValue.class.getSimpleName()).build();
    }

    @Bean
    public Converter<Kat1_5, Exemplar> kat15ToExemplarMapper() {
        return new Kat15ToExemplarMapper(this.locationLoader(), this.departmentLoader, this.thematicGroupLoader(), this.loanCategoryLoader(), this.exemplarStatusLoader(), this.acquisitionWayLoader(), this.accountLoader(), this.fondLoader);
    }

    @Bean
    public RowMapper<Exemplar> exemplarRowMapper() {
        return new ExemplarRowMapper(this.locationLoader(), this.departmentLoader, this.rootDepartmentProvider, this.thematicGroupLoader(), this.loanCategoryLoader(), this.exemplarStatusLoader(), this.acquisitionWayLoader(), this.accountLoader(), this.fondLoader, (ByIdLoadable)this.customValueLoader());
    }

    @Bean
    public IdAndIdsLoadable<Exemplar, Integer> exemplarAllByIdsLoader() {
        SpringDbExemplarAllByIdsLoader exemplarAllByIdsLoader = new SpringDbExemplarAllByIdsLoader(this.autoCommittingJdbcTemplate, this.queryFactory, this.exemplarRowMapper());
        ChunkingAllByIdsLoader chunkingAllByIdsLoader = ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)exemplarAllByIdsLoader);
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)chunkingAllByIdsLoader, Exemplar.class);
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<Record, Department, List<Exemplar>> familyDepartmentedRecordExemplarsLoader() {
        return new SearchingDepartmentedRecordExemplarsLoader((PageSearchLoader)this.exemplarSearchLoader(), (HierarchyContextsByModeLoader)this.departmentAccessor, ContextHierarchySelection.FAMILY);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Exemplar> exemplarSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.exemplarIdSearchLoader(), (AllByIdsLoadable)this.exemplarAllByIdsLoader()));
    }

    @Bean
    public PageSearchLoader<MapBackedParams, Integer> exemplarIdSearchLoader() {
        return new SpringDbExemplarIdSearchLoader(this.autoCommittingJdbcTemplate, this.queryFactory, this.departmentAccessor, this.accessNumberSequenceLoader(), this.signatureSequenceLoader(), () -> new ValidLengthBarCodeValidator((Provider)StaticProvider.of((Object)13)));
    }

    @Bean
    public AccessNumberSequenceLoader accessNumberSequenceLoader() {
        return new SpringDbAccessNumberSequenceLoader(this.autoCommittingJdbcTemplate, this.queryFactory, this.locationLoader());
    }

    @Bean
    public SignatureSequenceLoader signatureSequenceLoader() {
        SignatureSequenceFactory factory = new SignatureSequenceFactory(this.settingLoader.getOnRootProvider(SettingKeys.TITLE_SIGNATURES_ENABLED));
        return new SpringDbSignatureSequenceLoader(this.autoCommittingJdbcTemplate, this.queryFactory, factory);
    }

    @ConstructorProperties(value={"autoCommittingJdbcTemplate", "queryFactory", "departmentLoader", "rootDepartmentProvider", "settingLoader", "codebookLoaderBuilderFactory", "fondLoader", "departmentAccessor"})
    @Generated
    public ExemplarConfig(@NonNull NamedParameterJdbcOperations autoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull Provider<Department> rootDepartmentProvider, @NonNull SettingLoader settingLoader, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ByIdLoadable<Fond, Integer> fondLoader, @NonNull DepartmentAccessor departmentAccessor) {
        Objects.requireNonNull(autoCommittingJdbcTemplate, "autoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        this.autoCommittingJdbcTemplate = autoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.departmentLoader = departmentLoader;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.settingLoader = settingLoader;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.fondLoader = fondLoader;
        this.departmentAccessor = departmentAccessor;
    }
}

