/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.as.config.DataSourceFactory;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.databaseproperties.UrlBasedDatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentEntity;
import cz.kpsys.portaro.sql.generator.DbSpecifics;
import cz.kpsys.portaro.sql.generator.DbSpecificsFirebird;
import cz.kpsys.portaro.sql.generator.DbSpecificsPostgresql;
import cz.kpsys.service.ConnectionCheckerService;
import java.time.ZoneId;
import java.util.Objects;
import java.util.UUID;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InitializationBeansConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitializationBeansConfig.class);

    @Bean
    public StaticProvider<Department> initRootDepartmentProvider() {
        DepartmentEntity departmentEntity = new DepartmentEntity((Integer)this.initRootDepartmentIdProvider().get(), "N/A", 1, null, false, null, true, false, Integer.valueOf(0), null, UUID.randomUUID(), UUID.randomUUID(), null);
        return StaticProvider.of((Object)new Department(departmentEntity));
    }

    @Bean
    public StaticProvider<Integer> initRootDepartmentIdProvider() {
        return StaticProvider.of((Object)0);
    }

    @Bean
    public Provider<ZoneId> defaultTimeZoneProvider() {
        return StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID);
    }

    @Bean
    public Provider<ZoneId> databaseColumnsTimeZoneProvider() {
        return this.defaultTimeZoneProvider();
    }

    @Bean
    public DbConfig dbConfig() {
        return Objects.requireNonNull(ProxoolUtil.dbConfig);
    }

    @Bean
    public DatabaseConnectionSettings databaseProperties() {
        DbConfig dbConfig = this.dbConfig();
        return UrlBasedDatabaseProperties.ofAutodetectedType((String)dbConfig.jdbcURL(), (String)dbConfig.username(), (String)dbConfig.password());
    }

    @Bean
    public DataSourceFactory dataSourceFactory() {
        return new DataSourceFactory(this.databaseProperties());
    }

    @Bean
    public DbSpecifics dbSpecifics() {
        return switch (this.databaseProperties().getType()) {
            case "firebird" -> new DbSpecificsFirebird();
            case "postgresql" -> new DbSpecificsPostgresql();
            default -> throw new UnsupportedOperationException();
        };
    }

    @Bean
    DataSource notCheckedForOnlineDataSource() {
        return Objects.requireNonNull(ProxoolUtil.dataSource());
    }

    @Bean
    public ConnectionCheckerService connectionCheckerService() {
        ConnectionCheckerService bean = ConnectionCheckerService.getInstance();
        bean.setParams(this.notCheckedForOnlineDataSource());
        return bean;
    }

    @Generated
    public InitializationBeansConfig() {
    }
}

