/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import ch.qos.logback.classic.Level;
import cz.kpsys.as.config.SettingKeys;
import cz.kpsys.as.setting.CustomSettingEntityRepository;
import cz.kpsys.as.setting.JpaCustomSettingEntityDeleter;
import cz.kpsys.db.model.intern.SmtpSettings;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheCleaningSaver;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.convert.ConversionTableConverter;
import cz.kpsys.portaro.commons.convert.EToEConverter;
import cz.kpsys.portaro.commons.convert.StringToBooleanConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerListConverter;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.database.JpaSaver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.file.FileSettingKeys;
import cz.kpsys.portaro.setting.AllBySectionsLoader;
import cz.kpsys.portaro.setting.AllCustomSettingLoaderEnvironmentVariables;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingEntityId;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.CustomSettingLoaderByAllProvider;
import cz.kpsys.portaro.setting.CustomSettingLoaderComposite;
import cz.kpsys.portaro.setting.CustomSettingToEntityConverter;
import cz.kpsys.portaro.setting.DefaultSettingLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeDto;
import cz.kpsys.portaro.setting.SettingTypeLoader;
import cz.kpsys.portaro.setting.SettingsRepo;
import cz.kpsys.portaro.setting.SpringDbCustomSettingLoader;
import cz.kpsys.portaro.setting.SpringDbSettingTypeLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.verbisboxer.manager.VerbisboxerManagerApiSettingKeys;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class SettingBeansConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingBeansConfig.class);
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final NamedParameterJdbcOperations autoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final Codebook<Department, Integer> departmentLoader;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;

    @Bean
    public SettingLoader settingLoader() {
        DefaultSettingLoader bean = new DefaultSettingLoader((ByIdLoadable)this.departmentLoader, this.rootDepartmentProvider, this.realRootDepartmentProvider, new SettingsRepo((ByIdLoadable)this.departmentLoader), (AllBySectionsLoader)this.settingTypeLoader(), this.envVariablesAwareCustomSettingLoader());
        this.cacheService.registerCleaner(SettingTypeDto.class.getSimpleName(), (CacheCleaner)bean);
        this.registerSettingKeys((SettingLoader)bean);
        return bean;
    }

    private void registerSettingKeys(SettingLoader bean) {
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SERIAL_CODE, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.KPSYS_API_KEY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LICENCE_KEY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.CENTRAL_INDEX_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_NAME, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_STREET, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_POSTAL_CODE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_CITY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_EMAIL, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SMTP_MAIL_PROVIDER, (Converter)new ConversionTableConverter(SmtpSettings.CONVERSION_MAP));
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SMTP_USE_SENDER_AND_FROM, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SMTP_AUTHENTICATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_FROM_LIBRARY_MAILS_REPLY_TO_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SENDER_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SENDER_NAME, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SERVER_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.SMTP_SERVER_PORT, (Converter)new StringToIntegerConverter(), () -> 25);
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SERVER_USERNAME, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SERVER_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_PROXY_TYPE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_PROXY_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.SMTP_PROXY_PORT, (Converter)new StringToIntegerConverter(), () -> 465);
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_PROXY_USER, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_PROXY_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_REPLYTO_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_ORDER_RECIPIENT_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.APPSERVER_REMOTE_LOG_LEVEL, (Converter)new ConversionTableConverter().put((Object)"off", (Object)Level.OFF).put((Object)"error", (Object)Level.ERROR).put((Object)"warn", (Object)Level.WARN).put((Object)"info", (Object)Level.INFO).put((Object)"debug", (Object)Level.DEBUG));
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SERVER_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EXEMPLAR_STATUSES_EXPORT, (Converter)new StringToIntegerListConverter(), Collections::emptyList);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.TITLE_SIGNATURES_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.EXTERNAL_RESOURCES_FOND, (Converter)new StringToIntegerConverter().nullIfEmpty());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_LOCATION, (Converter)new StringToIntegerConverter().nullIfEmpty());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_STATUS, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_THEMATIC_GROUP, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_ACQUISITION_WAY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_LOAN_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.EXT_LOANS_FOND_ID, (Converter)new StringToIntegerConverter().nullIfEmpty());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EXT_LOANS_CHECK_DEBTS, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EXT_LOANS_CHECK_OVERDUE_NOTICES, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.EXT_LOANS_POPL_CTEN_SCRIPT, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.PALMKNIHY_LOANS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.PALMKNIHY_LOANS_LIBRARY_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.PALMKNIHY_LOANS_LOAN_CATEGORY_ID, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.FLEXIBOOKS_LOANS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.FLEXIBOOKS_LOANS_FEED_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.FLEXIBOOKS_LOANS_EMAIL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.FLEXIBOOKS_LOANS_LOAN_CATEGORY_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.FLEXIBOOKS_LOANS_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.FLEXIBOOKS_LOANS_PRICE_LIMIT, BigDecimal::new);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.LEVNAKNIHOVNA_LOANS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LEVNAKNIHOVNA_LOANS_FEED_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LEVNAKNIHOVNA_LOANS_LOAN_CATEGORY_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LEVNAKNIHOVNA_LOANS_EMAIL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LEVNAKNIHOVNA_LOANS_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.LEVNAKNIHOVNA_LOANS_PRICE_LIMIT, source -> source.isEmpty() ? BigDecimal.ZERO : new BigDecimal((String)source));
        bean.registerKeyThrowingWhenNullSource(SettingKeys.MLP_LOANS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.MLP_LOANS_LOAN_CATEGORY_ID, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(FileSettingKeys.APPSERVER_INDEXING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_URL, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_TOKEN_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_CLIENT_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_CLIENT_SECRET, (Converter)new EToEConverter());
    }

    @Bean
    public SettingTypeLoader settingTypeLoader() {
        return new SpringDbSettingTypeLoader(this.autoCommittingJdbcTemplate, this.queryFactory);
    }

    @Bean
    public AllBySectionsLoader<CustomSetting<String>> envVariablesAwareCustomSettingLoader() {
        return new CustomSettingLoaderComposite(new AllBySectionsLoader[]{new CustomSettingLoaderByAllProvider((AllValuesProvider)AllCustomSettingLoaderEnvironmentVariables.ofSystemGetenv((String)"APPSERVER_INI__")), this.customSettingLoader()});
    }

    @Bean
    public CustomSettingLoader customSettingLoader() {
        return new SpringDbCustomSettingLoader(this.autoCommittingJdbcTemplate, this.queryFactory);
    }

    @Bean
    public JpaRepositoryFactoryBean<CustomSettingEntityRepository, CustomSettingEntity, CustomSettingEntityId> customSettingEntityRepositoryBean() {
        return new JpaRepositoryFactoryBean(CustomSettingEntityRepository.class);
    }

    @Bean
    public CustomSettingEntityRepository customSettingEntityRepository() {
        return (CustomSettingEntityRepository)this.customSettingEntityRepositoryBean().getObject();
    }

    @Bean
    public Deleter<CustomSettingEntity> customSettingEntityByIdDeleter() {
        return new JpaCustomSettingEntityDeleter(this.customSettingEntityRepository());
    }

    @Bean
    public Saver<CustomSetting<String>> customSettingSaver() {
        PreConvertingSaver pure = new PreConvertingSaver((Converter)new CustomSettingToEntityConverter(), (Saver)new JpaSaver(this.customSettingEntityByIdDeleter(), (JpaRepository)this.customSettingEntityRepository()));
        return new CacheCleaningSaver((Saver)pure, (CacheCleaner)this.settingLoader());
    }

    @ConstructorProperties(value={"cacheService", "autoCommittingJdbcTemplate", "queryFactory", "departmentLoader", "rootDepartmentProvider", "realRootDepartmentProvider"})
    @Generated
    public SettingBeansConfig(@NonNull CacheService cacheService, @NonNull NamedParameterJdbcOperations autoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull Codebook<Department, Integer> departmentLoader, @NonNull Provider<Department> rootDepartmentProvider, @NonNull Provider<Department> realRootDepartmentProvider) {
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(autoCommittingJdbcTemplate, "autoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        this.cacheService = cacheService;
        this.autoCommittingJdbcTemplate = autoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.departmentLoader = departmentLoader;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
    }
}

