/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.db.DbConfig;
import cz.kpsys.kpwinsql.z3950.server.ZServerService;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.Module;
import cz.kpsys.service.Utils;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class ZServerBeansConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZServerBeansConfig.class);
    @NonNull
    private final DbConfig dbConfig;
    @NonNull
    private final Provider<Licence> licenceProvider;

    @Bean
    public ZServerService zServerService() {
        return new ZServerService();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initZServer() {
        try {
            Licence licence;
            if (!Utils.internalBuild() && !(licence = (Licence)this.licenceProvider.get()).isEnabled(Module.Z_SERVER)) {
                log.info("modul z39.50 server neaktivni");
                return;
            }
            this.zServerService().initZServer(this.dbConfig);
        }
        catch (Exception e) {
            log.error("nepodarilo se spustit Z server", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"dbConfig", "licenceProvider"})
    @Generated
    public ZServerBeansConfig(@NonNull DbConfig dbConfig, @NonNull Provider<Licence> licenceProvider) {
        Objects.requireNonNull(dbConfig, "dbConfig is marked non-null but is null");
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        this.dbConfig = dbConfig;
        this.licenceProvider = licenceProvider;
    }
}

