/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.exemplar;

import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.util.NumberUtil;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.BasicExemplar;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarType;
import cz.kpsys.portaro.exemplar.account.Account;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWay;
import cz.kpsys.portaro.exemplar.customvalue.CustomValue;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatus;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.file.directory.BasicDirectory;
import cz.kpsys.portaro.file.directory.Directory;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;

public class Kat15ToExemplarMapper
implements Converter<Kat1_5, Exemplar> {
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ByIdLoadable<ThematicGroup, String> thematicGroupLoader;
    @NonNull
    private final ByIdLoadable<LoanCategory, String> loanCategoryLoader;
    @NonNull
    private final ByIdLoadable<ExemplarStatus, Integer> exemplarStatusLoader;
    @NonNull
    private final ByIdLoadable<AcquisitionWay, String> acquisitionWayLoader;
    @NonNull
    private final ByIdLoadable<Account, String> accountLoader;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;

    public Exemplar convert(@NonNull Kat1_5 source) {
        Objects.requireNonNull(source, "source is marked non-null but is null");
        BasicExemplar e = new BasicExemplar(Integer.valueOf((int)RecordIdCache.getByRecordId((String)source.getRECORD_ID()).cisZaz()), Integer.valueOf((int)source.getID_EX()), (Department)this.departmentLoader.getById((Object)source.getFK_PUJC()));
        e.setRecordId(UUID.fromString(Objects.requireNonNull(source.getRECORD_ID(), "Exemplar %s has not record_id".formatted(source.getID_EX()))));
        e.setBarCode(source.getBAR_COD());
        e.setAccessNumber(source.getPRIR_CISLO());
        e.setSignature(source.getSIGNATURA());
        e.setSignatureSorter(source.getTRIDSIGN());
        e.setLocation((Location)this.locationLoader.getById((Object)Objects.requireNonNull((Integer)NumberUtil.nullIfZero((Number)source.getFK_LOKACE()), "Location id for exemplar %s is null!".formatted(source.getID_EX()))));
        e.setFond((Fond)this.fondLoader.getById((Object)source.getFK_DOKFOND()));
        e.setLoanCategory((LoanCategory)this.loanCategoryLoader.getById((Object)source.getFK_VYPKAT()));
        e.setThematicGroup((ThematicGroup)this.thematicGroupLoader.getById((Object)source.getFK_TEMSKUP()));
        e.setAcquisitionWay((AcquisitionWay)this.acquisitionWayLoader.getById((Object)source.getFK_ZPNAB()));
        e.setStatus((ExemplarStatus)this.exemplarStatusLoader.getById((Object)source.getFK_STATUS()));
        e.setCreationDate(source.getDATUM() == null ? null : Utils.anyDate2UtilDate((Date)source.getDATUM()).toInstant());
        e.setInvoiceNumber(source.getCIS_FAK());
        e.setDiscardionId(source.getFK_UBYTEK());
        e.setInvoiceItem(Integer.valueOf(source.getFK_POLFAK() == null ? 0 : source.getFK_POLFAK().intValue()));
        e.setNote(source.getPOZNAMKA());
        e.setAttachments(source.getPRILOHY());
        e.setOrder(Integer.valueOf(source.getPORADI().shortValue()));
        e.setSupplier(source.getDODAVATEL());
        e.setOwner(source.getUZIVATEL());
        e.setCustomValue(source.getPOMOCNE() == null ? null : new CustomValue(source.getPOMOCNE(), source.getPOMOCNE()));
        e.setPrice(source.getCENA() == null ? null : Double.valueOf(source.getCENA().doubleValue()));
        e.setAcquisitionYear(Integer.valueOf(source.getROK_PRIR().shortValue()));
        e.setType((ExemplarType)ExemplarType.CODEBOOK.getById((Object)source.getTYP_CISLA()));
        e.setDepartment((Department)this.departmentLoader.getById((Object)source.getFK_PUJC()));
        e.setQuantity(Integer.valueOf(NumberUtil.defaultIfNegativeOrZero((int)source.getPOCET_KS().shortValue(), (int)1)));
        e.setBundledVolumeNumber(source.getVOLUME());
        e.setBundledVolumeYear(source.getROK_VOL());
        e.setBundledVolumeIssueRange(source.getROZM_CISEL());
        e.setLastModificationDate(source.getDATCAS() == null ? null : source.getDATCAS().toInstant());
        e.setAccount(source.getFK_UCTU() == null ? null : (Account)this.accountLoader.getById((Object)source.getFK_UCTU()));
        Integer directoryId = (Integer)NumberUtil.nullIfZero((Number)source.getFK_FULLTEXT_SKUPINY());
        if (directoryId != null) {
            e.setFileDirectory((Directory)new BasicDirectory(directoryId, "Unknown directory name").withTextDifferentFromName(Texts.ofMessageCoded((String)"commons.PlnyText")));
        }
        e.setDesignationProperty(e.getFirstExistingDesignationProperty());
        return e;
    }

    @ConstructorProperties(value={"locationLoader", "departmentLoader", "thematicGroupLoader", "loanCategoryLoader", "exemplarStatusLoader", "acquisitionWayLoader", "accountLoader", "fondLoader"})
    @Generated
    public Kat15ToExemplarMapper(@NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ByIdLoadable<ThematicGroup, String> thematicGroupLoader, @NonNull ByIdLoadable<LoanCategory, String> loanCategoryLoader, @NonNull ByIdLoadable<ExemplarStatus, Integer> exemplarStatusLoader, @NonNull ByIdLoadable<AcquisitionWay, String> acquisitionWayLoader, @NonNull ByIdLoadable<Account, String> accountLoader, @NonNull ByIdLoadable<Fond, Integer> fondLoader) {
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(thematicGroupLoader, "thematicGroupLoader is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarStatusLoader, "exemplarStatusLoader is marked non-null but is null");
        Objects.requireNonNull(acquisitionWayLoader, "acquisitionWayLoader is marked non-null but is null");
        Objects.requireNonNull(accountLoader, "accountLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        this.locationLoader = locationLoader;
        this.departmentLoader = departmentLoader;
        this.thematicGroupLoader = thematicGroupLoader;
        this.loanCategoryLoader = loanCategoryLoader;
        this.exemplarStatusLoader = exemplarStatusLoader;
        this.acquisitionWayLoader = acquisitionWayLoader;
        this.accountLoader = accountLoader;
        this.fondLoader = fondLoader;
    }
}

