/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.common;

import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.service.Utils;
import java.sql.Connection;
import java.sql.SQLException;

public class MaxConnectionLifeTimeWatcher {
    Connection conn = null;
    long creationTime = 0L;
    long maxLifeTime = 60000L;

    public void onCreateNewConnection(Connection conn) {
    }

    public void afterCommit() {
    }

    public void commitClose() throws SQLException {
        this.conn.commit();
        this.afterCommit();
        this.conn.close();
        this.creationTime = 0L;
        this.conn = null;
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            this.createNewConnection();
            return this.conn;
        }
        if (this.creationTime + this.maxLifeTime < Utils.now().getTime()) {
            this.commitClose();
            this.createNewConnection();
            return this.conn;
        }
        return this.conn;
    }

    private void createNewConnection() throws SQLException {
        this.conn = ProxoolUtil.obtainConnection();
        this.onCreateNewConnection(this.conn);
        this.creationTime = Utils.now().getTime();
    }
}

