/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.common;

import java.time.LocalDate;
import java.util.SortedSet;

public class YearInterval {
    int firstYear;
    int lastYear;

    public YearInterval(int year) {
        this.firstYear = year;
        this.lastYear = year;
    }

    public YearInterval(int firstYear, int lastYear) {
        this.firstYear = firstYear;
        this.lastYear = lastYear;
    }

    public int getFirstYear() {
        return this.firstYear;
    }

    public void setFirstYear(int firstYear) {
        this.firstYear = firstYear;
    }

    public int getLastYear() {
        return this.lastYear;
    }

    public void setLastYear(int lastYear) {
        this.lastYear = lastYear;
    }

    public String toString() {
        if (this.firstYear == this.lastYear) {
            return Integer.toString(this.firstYear);
        }
        if (this.firstYear % 100 == this.lastYear % 100) {
            return this.firstYear + "-" + this.lastYear % 100;
        }
        return this.firstYear + "-" + this.lastYear;
    }

    public void normalize() {
        int rok = LocalDate.now().getYear();
        this.opravaZjevnychExtremu(rok);
        if (this.asponJedenRokMensiNez1000()) {
            if (this.lastYear < 1000) {
                this.lastYear += 2000;
                if (this.lastYear > rok) {
                    this.lastYear -= 100;
                }
            }
            if (this.firstYear < 1000) {
                this.firstYear += 2000;
                if (this.firstYear > rok) {
                    this.firstYear -= 100;
                }
            }
        }
        if (this.firstYear > this.lastYear) {
            int tempYear = this.lastYear;
            this.lastYear = this.firstYear;
            this.firstYear = tempYear;
        }
    }

    protected void opravaZjevnychExtremu(int rok) {
        if (this.firstYear > 3000) {
            this.firstYear = rok;
        } else if (this.firstYear < 0) {
            this.firstYear = rok;
        }
        if (this.lastYear > 3000) {
            this.lastYear = rok;
        } else if (this.lastYear < 0) {
            this.lastYear = rok;
        }
    }

    private boolean asponJedenRokMensiNez1000() {
        return this.firstYear < 1000 || this.lastYear < 1000;
    }

    public void pridejSeznamLet(SortedSet<Integer> roky) {
        for (int i = this.firstYear; i <= this.lastYear; ++i) {
            roky.add(i);
        }
    }
}

