/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipExtractor {
    public static long fileDateInArchive(File archiveFile, String fileName) throws IOException {
        if (!archiveFile.exists()) {
            throw new IOException(archiveFile.getAbsolutePath() + " neexistuje");
        }
        ZipFile zipFile = new ZipFile(archiveFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!fileName.equalsIgnoreCase(entry.getName())) continue;
            return entry.getTime();
        }
        zipFile.close();
        return 0L;
    }

    public static File unpackArchive(File theFile, File targetDir) throws IOException {
        if (!theFile.exists()) {
            throw new IOException(theFile.getAbsolutePath() + " neexistuje");
        }
        if (!ZipExtractor.buildDirectory((File)targetDir)) {
            throw new IOException("nepodarilo se vytvorit adresar: " + targetDir);
        }
        ZipFile zipFile = new ZipFile(theFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            long lastModified;
            ZipEntry entry = entries.nextElement();
            File file = new File(targetDir, File.separator + entry.getName());
            if (!ZipExtractor.buildDirectory((File)file.getParentFile())) {
                throw new IOException("Could not create directory: " + file.getParentFile());
            }
            if (!entry.isDirectory()) {
                ZipExtractor.kontrolaZdaSouborPujdePrepsat((File)file);
                ZipExtractor.copyInputStream((InputStream)zipFile.getInputStream(entry), (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
            } else if (!ZipExtractor.buildDirectory((File)file)) {
                throw new IOException("nepodarilo se vytvorit adresar: " + file);
            }
            if ((lastModified = entry.getTime()) <= -1L) continue;
            file.setLastModified(entry.getTime());
        }
        zipFile.close();
        return theFile;
    }

    private static void kontrolaZdaSouborPujdePrepsat(File file) throws IOException {
        if (file.exists()) {
            File tempFile = new File(System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString());
            FileUtils.copyFile((File)file, (File)tempFile, (boolean)true);
            boolean result = file.delete();
            if (!result || file.exists()) {
                throw new IOException("problem s pravy, soubor " + file.getAbsolutePath());
            }
            FileUtils.copyFile((File)tempFile, (File)file, (boolean)true);
        }
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    public static boolean buildDirectory(File file) {
        return file.exists() || file.mkdirs();
    }
}

