/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.custom;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefLokace;
import cz.kpsys.db.model.v2.Kat1_5;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KontrolaRozsahuSignatur {
    private static final String LOK_NA = "N/A";
    private static final Logger logger = LoggerFactory.getLogger(KontrolaRozsahuSignatur.class);
    private Map<Short, Map<Integer, Integer>> res;
    private QueryRunner qr;
    final String LOK_NPKK = "NPKK";
    final String LOK_NPKK_DEPOZ = "DEPOZ";
    final String LOK_UC = "U";
    final String LOK_UC_DEPOZ = "UD";
    final String LOK_SUK = "U";
    final String LOK_SUKDE = "SUKDE";
    StringBuilder zmenyLog = new StringBuilder();
    static final Pattern p = Pattern.compile("(.*?) (\\d*).*");

    public void zpracujList() throws SQLException, AppServerStatus, IOException {
        DbCore2 core2 = new DbCore2(ProxoolUtil.obtainConnectionBackground());
        this.qr = core2.obtainQueryRunnerOpened();
        core2.loginAsAS();
        List fondy = (List)this.qr.query("SELECT * FROM DEF_DOKFOND WHERE JE_PERIO=0", (ResultSetHandler)new KPSYSBeanListHandler(DefFond.class));
        for (DefFond fond : fondy) {
            this.zpracujFond(fond.getID_FOND());
        }
        core2.commit();
        FileUtils.writeStringToFile((File)new File("/tmp/vysledek.txt"), (String)this.zmenyLog.toString(), (Charset)StandardCharsets.UTF_8);
    }

    public void zpracujFond(short id_DOKFOND) throws SQLException {
        List prirustky = (List)this.qr.query("SELECT * FROM KAT1_5 WHERE FK_STATUS NOT IN (9, 99) AND FK_DOKFOND=?", (ResultSetHandler)new KPSYSBeanListHandler(Kat1_5.class), new Object[]{id_DOKFOND});
        this.res = new HashMap();
        for (Kat1_5 kat1_5 : prirustky) {
            String signatura = kat1_5.getSIGNATURA();
            String lokace = ((DefLokace)DbCache2.lokaceMap.get(kat1_5.getFK_LOKACE())).getKOD_LOKACE();
            if (StringUtils.isBlank((CharSequence)lokace) || StringUtils.isBlank((CharSequence)signatura)) continue;
            try {
                String novaLokace;
                boolean jeHlavniHlavniFond;
                if ("NPKK".equals(lokace) || "DEPOZ".equals(lokace)) {
                    jeHlavniHlavniFond = true;
                } else {
                    if (!"U".equals(lokace) && !"UD".equals(lokace)) continue;
                    jeHlavniHlavniFond = false;
                }
                if ((novaLokace = this.zjistiLokaci(signatura, jeHlavniHlavniFond)) == LOK_NA || novaLokace.equals(lokace)) continue;
                String hlaska = "zmena " + signatura + " z " + lokace + " -> " + novaLokace;
                System.err.println(hlaska);
                this.zmenyLog.append(hlaska + "\n");
                this.qr.update("UPDATE KAT1_5 SET FK_LOKACE=? WHERE ID_EX=? AND FK_LOKACE=?", new Object[]{novaLokace, kat1_5.getID_EX(), lokace});
            }
            catch (Exception e) {}
        }
        logger.info("hotovo");
    }

    public String zjistiLokaci(String sig, boolean jeHlavniBudova) {
        try {
            Matcher m = p.matcher(sig);
            boolean b = m.matches();
            if (b) {
                String pref = m.group(1);
                String bodyString = m.group(2);
                int body = Integer.parseInt(bodyString);
                if (jeHlavniBudova) {
                    if (pref.equals("I") && body >= 1 && body <= 24099) {
                        return "DEPOZ";
                    }
                    if (pref.equals("II") && body >= 1 && body <= 85999) {
                        return "DEPOZ";
                    }
                    if (pref.equals("III") && body >= 1 && body <= 34199) {
                        return "DEPOZ";
                    }
                    if (!pref.equals("IV")) {
                        if (pref.equals("V") && body >= 1 && body <= 14999) {
                            return "DEPOZ";
                        }
                        if (pref.equals("VI") && body >= 1 && body <= 6099) {
                            return "DEPOZ";
                        }
                        if (pref.equals("T") && body >= 1 && body <= 4499) {
                            return "DEPOZ";
                        }
                        if (pref.equals("TT")) {
                            // empty if block
                        }
                    }
                    if (pref.equals("I") && body >= 24100) {
                        return "NPKK";
                    }
                    if (pref.equals("II") && body >= 86000) {
                        return "NPKK";
                    }
                    if (pref.equals("III") && body >= 34200) {
                        return "NPKK";
                    }
                    if (pref.equals("IV")) {
                        return "NPKK";
                    }
                    if (pref.equals("V") && body >= 15000) {
                        return "NPKK";
                    }
                    if (pref.equals("VI") && body >= 6100) {
                        return "NPKK";
                    }
                    if (pref.equals("T") && body >= 4500) {
                        return "NPKK";
                    }
                    if (pref.equals("TT")) {
                        return "NPKK";
                    }
                } else {
                    if (!pref.equals("I")) {
                        if (pref.equals("II") && body >= 40000 && body <= 92999) {
                            return "UD";
                        }
                        if (pref.equals("III") && body >= 1 && body <= 24699) {
                            return "UD";
                        }
                        if (pref.equals("IV")) {
                            return "UD";
                        }
                        if (pref.equals("V") && body >= 1 && body <= 18999) {
                            return "UD";
                        }
                        if (pref.equals("VI") && body >= 1 && body <= 9199) {
                            return "UD";
                        }
                        if (pref.equals("T") && body >= 1 && body <= 3499) {
                            return "UD";
                        }
                        if (pref.equals("TT")) {
                            // empty if block
                        }
                    }
                    if (pref.equals("I")) {
                        return "U";
                    }
                    if (pref.equals("II") && (body >= 1 && body <= 39999 || body > 93000)) {
                        return "U";
                    }
                    if (pref.equals("III") && body >= 24700) {
                        return "U";
                    }
                    if (!pref.equals("IV")) {
                        if (pref.equals("V") && body >= 19000) {
                            return "U";
                        }
                        if (pref.equals("VI") && body >= 9200) {
                            return "U";
                        }
                        if (pref.equals("T") && body >= 3500) {
                            return "U";
                        }
                        if (pref.equals("TT")) {
                            return "U";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            return LOK_NA;
        }
        return LOK_NA;
    }
}

