/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.model.AuthorityLinkInfo;
import cz.kpsys.db.model.AutorityOrezInfo;
import cz.kpsys.db.model.PoleOrezInfo;
import cz.kpsys.db.model.v2.AuthorityLink;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.SubField;
import cz.kpsys.service.SUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordReconstructor {
    public static final int NOT_FOUND = 404;
    public static final int NOT_IN_FOND = 405;
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecordReconstructor.class);
    protected final Pattern authorityPatternWithSuffix = Pattern.compile(".*[\u0002|\u0003|\u0005](\\d*)(.*)?");
    final HashMap<AuthorityLink, Record> authorityMap = new HashMap();
    public int ERROR_CODE = 0;
    private boolean validaceEnabled = true;

    public static Record recordFromXML(Document doc) throws DocumentException, AppServerStatus {
        String activeString;
        Record r = new Record();
        Node vykonNode = doc.selectSingleNode("//collection/vykon");
        if (vykonNode != null) {
            try {
                int vykon = Integer.parseInt(vykonNode.getText());
                r.setVykon(vykon);
            }
            catch (NumberFormatException nfe) {
                logger.error("chyba pri parsovani cisla vykonu", (Throwable)nfe);
            }
        }
        Node recordNode = doc.selectSingleNode("//collection/record");
        try {
            String fondString = recordNode.valueOf("@fond");
            if (StringUtils.isNotBlank((CharSequence)fondString)) {
                r.setFond(Short.parseShort(fondString));
            }
        }
        catch (Exception e) {
            throw new AppServerStatus("chyba behem parsovani cisla fondu", 613);
        }
        try {
            String status4String = recordNode.valueOf("@status");
            if (StringUtils.isNotBlank((CharSequence)status4String)) {
                r.setStatus4((int)Short.parseShort(status4String));
            }
        }
        catch (NumberFormatException nfe) {
            r.setStatus4(3);
        }
        String recordStatusString = recordNode.valueOf("@record_status");
        try {
            if (StringUtils.isNotBlank((CharSequence)recordStatusString)) {
                r.setRecordStatus((int)Short.parseShort(recordStatusString));
            }
        }
        catch (NumberFormatException nfe) {
            logger.warn("neplatna hodnota v atributu recordStatus " + recordStatusString, (Throwable)nfe);
        }
        String departmentString = recordNode.valueOf("@department");
        try {
            if (StringUtils.isNotBlank((CharSequence)departmentString)) {
                r.setDepartment(Short.parseShort(departmentString));
            }
        }
        catch (NumberFormatException nfe) {
            logger.warn("neplatna hodnota v atributu department " + departmentString, (Throwable)nfe);
        }
        String idString = recordNode.valueOf("@id");
        if (idString.length() > 0) {
            r.setId(Long.parseLong(idString));
        }
        r.setActive(!GenericExecutor.tagHasFalseValue((String)(activeString = recordNode.valueOf("@active"))));
        r.recordId = recordNode.valueOf("@record_id");
        Node leaderNode = doc.selectSingleNode("//collection/record/leader");
        if (leaderNode != null) {
            r.setLeader(leaderNode.getText().trim());
        }
        List fixFields = doc.selectNodes("//collection/record/controlfield");
        for (Object o : fixFields) {
            Node n = (Node)o;
            Field f = new Field();
            f.setNumber(Short.parseShort(n.valueOf("@tag")));
            f.setContent(n.getText().trim());
            r.addField(f);
        }
        List varFields = doc.selectNodes("//collection/record/datafield");
        for (Object o : varFields) {
            Node n = (Node)o;
            Field f = new Field();
            f.setNumber(Short.parseShort(n.valueOf("@tag")));
            String ind1 = n.valueOf("@ind1");
            String ind2 = n.valueOf("@ind2");
            String idZazZdroj = n.valueOf("@id_zaz_zdroj");
            if (ind1 != null && ind1.length() > 0) {
                f.setInd1(ind1.charAt(0));
            }
            if (ind2 != null && ind2.length() > 0) {
                f.setInd2(ind2.charAt(0));
            }
            if (StringUtils.isNotBlank((CharSequence)idZazZdroj)) {
                try {
                    f.setIdZazZdroj(idZazZdroj);
                }
                catch (Exception e) {
                    logger.error("neplatny obsah tagu id_zaz_zdroj " + idZazZdroj, (Throwable)e);
                }
            }
            List subFields = n.selectNodes("subfield");
            for (Object osf : subFields) {
                Node nsf = (Node)osf;
                SubField sf = new SubField();
                String authIDString = nsf.valueOf("@id");
                if (authIDString != null && authIDString.length() > 0) {
                    sf.setAuthLink(Long.parseLong(authIDString));
                }
                sf.setPrefix(nsf.valueOf("@code"));
                sf.setContent(nsf.getText().trim());
                f.addSubfield(sf);
            }
            f.setContent(n.getText().trim());
            r.addField(f);
        }
        if (StringUtils.isBlank((CharSequence)r.recordId)) {
            r.recordId = r.getId() > 0L ? DbCore2Utils.zjistiRecordIdDleId((int)((int)r.getId()), (boolean)r.isAuthority()) : SUtils.uuid();
        }
        return r;
    }

    public boolean isValidaceEnabled() {
        return this.validaceEnabled;
    }

    public void setValidaceEnabled(boolean validaceEnabled) {
        this.validaceEnabled = validaceEnabled;
    }

    protected Map<AuthorityLinkInfo, AutorityOrezInfo> vytvorOrezavaciMapu(List<AuthorityLinkInfo> infoList) {
        HashMap<AuthorityLinkInfo, AutorityOrezInfo> mapa = new HashMap<AuthorityLinkInfo, AutorityOrezInfo>();
        AuthorityLinkInfo linkInfo = new AuthorityLinkInfo();
        for (AuthorityLinkInfo info : infoList) {
            if (!info.getLink().equals(linkInfo.getLink())) {
                linkInfo = new AuthorityLinkInfo();
                linkInfo.authRecID = info.authRecID;
                linkInfo.authRecIDString = info.authRecIDString;
                linkInfo.fond = info.fond;
                linkInfo.fondString = info.fondString;
                linkInfo.typAutority = info.typAutority;
                linkInfo.vstupniPole = info.vstupniPole;
                linkInfo.vstupniPodpole = info.vstupniPodpole;
                mapa.put(linkInfo, new AutorityOrezInfo());
            }
            if (((AutorityOrezInfo)mapa.get((Object)linkInfo)).poleOrezInfoMap.containsKey(info.vstupniPole)) {
                if (linkInfo.vstupniPodpole != null && linkInfo.vstupniPodpole.equals(((AutorityOrezInfo)mapa.get((Object)linkInfo)).poleOrezInfoMap.get(info.vstupniPole))) continue;
                ((PoleOrezInfo)((AutorityOrezInfo)mapa.get((Object)linkInfo)).poleOrezInfoMap.get((Object)Integer.valueOf((int)info.vstupniPole))).podpole = null;
                continue;
            }
            PoleOrezInfo poleOrezInfo = new PoleOrezInfo();
            poleOrezInfo.pole = info.vstupniPole;
            if (info.typAutority != 3) {
                poleOrezInfo.podpole = info.vstupniPodpole;
            }
            ((AutorityOrezInfo)mapa.get((Object)linkInfo)).poleOrezInfoMap.put(info.vstupniPole, poleOrezInfo);
        }
        return mapa;
    }

    protected AuthorityLinkInfo getAuthLinkInfo(String subfieldContent) {
        Matcher m = this.authorityPatternWithSuffix.matcher(subfieldContent);
        if (m.matches()) {
            AuthorityLinkInfo info = new AuthorityLinkInfo();
            String linkPart = m.group(1);
            if (linkPart.length() < 2) {
                return null;
            }
            info.fondString = linkPart.substring(0, 2);
            info.authRecIDString = linkPart.substring(2);
            info.fond = Short.parseShort(info.fondString);
            info.authRecID = Long.parseLong(info.authRecIDString);
            if (m.groupCount() > 1) {
                info.suffix = m.group(2);
            }
            return info;
        }
        return null;
    }

    protected void nahradLinkZaSeznamPodpoli(Field field, SubField sf, AuthorityLinkInfo authorityInfo, List<SubField> podpoleZAutority) {
        HashSet<String> prefixyPodpoliZAutority = new HashSet<String>();
        for (SubField sfVAutorite : podpoleZAutority) {
            prefixyPodpoliZAutority.add(sfVAutorite.getPrefix());
        }
        HashSet<SubField> kOdstraneni = new HashSet<SubField>();
        String originalLink = sf.getAuthorityLink();
        int prvniOdkazNaAutoritu = -1;
        List podpole = field.getSubfields();
        for (int i = 0; i < podpole.size(); ++i) {
            SubField zkoumanePodpole = (SubField)podpole.get(i);
            String link = zkoumanePodpole.getAuthorityLink();
            if (link != null && link.equals(originalLink)) {
                kOdstraneni.add(zkoumanePodpole);
                if (prvniOdkazNaAutoritu == -1) {
                    prvniOdkazNaAutoritu = i;
                }
            }
            if (prvniOdkazNaAutoritu <= -1 || !prefixyPodpoliZAutority.contains(zkoumanePodpole.getPrefix())) continue;
            kOdstraneni.add(zkoumanePodpole);
        }
        field.getSubfields().removeAll(kOdstraneni);
        if (StringUtils.isNotBlank((CharSequence)authorityInfo.suffix) && podpoleZAutority.size() > 0) {
            SubField lastSubfield = podpoleZAutority.get(podpoleZAutority.size() - 1);
            String content = lastSubfield.getContent();
            if (content.endsWith(authorityInfo.suffix)) {
                authorityInfo.suffix = "";
            }
            lastSubfield.setContent(lastSubfield.getContent() + authorityInfo.suffix);
            lastSubfield.setAuthLink(sf.getAuthLink());
            sf.setInterpunkceZa(authorityInfo.suffix);
        }
        if (prvniOdkazNaAutoritu > -1) {
            field.getSubfields().addAll(prvniOdkazNaAutoritu, podpoleZAutority);
        }
    }
}

