/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.custom.upce.model.UpceKonvKategCten;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2Helper;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.IntegerHandler;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.SingleConnectionDataSource;
import cz.kpsys.db.TableDescriptorProvider;
import cz.kpsys.db.cpk.GeneratorPolePrirustky;
import cz.kpsys.db.model.ParIndikatoru;
import cz.kpsys.db.model.PovoleneHodnotyIndikatoru;
import cz.kpsys.db.model.v2.CentralDatabaze;
import cz.kpsys.db.model.v2.CentralMapaFondu;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenVyp;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefIndik;
import cz.kpsys.db.model.v2.DefKultVzdel;
import cz.kpsys.db.model.v2.DefLokace;
import cz.kpsys.db.model.v2.DefMetodika;
import cz.kpsys.db.model.v2.DefPopl;
import cz.kpsys.db.model.v2.DefPujc;
import cz.kpsys.db.model.v2.DefPujcLok;
import cz.kpsys.db.model.v2.DefRez;
import cz.kpsys.db.model.v2.DefSkriptTrida;
import cz.kpsys.db.model.v2.DefTypDPH;
import cz.kpsys.db.model.v2.DefUziv;
import cz.kpsys.db.model.v2.DefVal;
import cz.kpsys.db.model.v2.DefVypAkce;
import cz.kpsys.db.model.v2.DefZServer;
import cz.kpsys.db.model.v2.FDef;
import cz.kpsys.db.model.v2.FDefAut;
import cz.kpsys.db.model.v2.FiktivniPoleIndexace;
import cz.kpsys.db.model.v2.IniFile;
import cz.kpsys.db.model.v2.IniKeys;
import cz.kpsys.db.model.v2.Lokalizace;
import cz.kpsys.db.model.v2.LuceneTokenizerEnum;
import cz.kpsys.db.model.v2.Styly;
import cz.kpsys.db.model.v2.Uzivatele;
import cz.kpsys.db.model.v2.ZpusobKlicovani;
import cz.kpsys.db.model.v2.ZpusobValidace;
import cz.kpsys.db.model.v2.vsb.VsbDefFormaStudia;
import cz.kpsys.db.model.v2.vsb.VsbDefTypStudia;
import cz.kpsys.db.model.v2.vsb.VsbDefVztahuniv;
import cz.kpsys.db.model.v2.vsb.VsbMapovaniCtenKat;
import cz.kpsys.kpwin2.rest.ConfigurationUtils;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.rest.executors.CISyncExecutor;
import cz.kpsys.kpwin2.services.model.CentralServer;
import cz.kpsys.kpwinsql.z3950.model.ZServerID;
import cz.kpsys.service.Utils;
import cz.kpsys.service.model.ZServerFormat;
import cz.kpsys.service.model.ZServerInfo;
import cz.kpsys.service.model.ZServerType;
import cz.kpsys.service.rezy.RezyFactory;
import events.ForceRefreshAllEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Tuple2;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbCache2 {
    public static final int NEIMPORTOVAT = 0;
    public static final int SLUCOVAT_PRENASET = 2;
    public static final int POL_VYMFOND_CACHE_LIMIT = 5000;
    private static final Logger logger = LoggerFactory.getLogger(DbCache2.class);
    public static Map<Short, DefFond> defDokFondMap = new HashMap();
    public static Map<Short, DefFond> defAutFondMap = new HashMap();
    public static Map<Short, DefFond> defFondMap = new HashMap();
    public static Set<Short> fondyAutoritZdrojovyDokument = new HashSet();
    public static Map<Short, CentralDatabaze> centralDatabazeMap = new HashMap();
    public static Map<Short, Map<Short, CentralMapaFondu>> centralMapaFonduMapMap = new HashMap();
    public static Set<String> defKliSlov = new HashSet();
    public static Set<String> defVylSlov = new HashSet();
    public static Map<Short, DefSkriptTrida> defSkriptTridaMap = new HashMap();
    public static Map<Short, HashSet<Integer>> fondyToSyncToCIMap = new HashMap();
    public static HashMap<Short, DefPopl> defPoplMap = new HashMap();
    public static HashMap<Short, List<DefTypDPH>> defTypDPHMap = new HashMap();
    public static List<DefPujcLok> defPujcLok = new LinkedList();
    public static ArrayList<FiktivniPoleIndexace> virtualniPoleIndexace = new ArrayList(0);
    public static List<VsbMapovaniCtenKat> vsbMapovaniCtenKatList = new ArrayList();
    public static List<UpceKonvKategCten> upceKatCtenList = new ArrayList();
    private static Map<Short, Styly> stylyMap = new HashMap();
    public static Map<Short, List<Styly>> stylyCompleteMap = new HashMap();
    public static Map<Short, CentralServer> centralServerCreds = new HashMap();
    public static Map<Short, ParIndikatoru> defaultniIndikatoryDokumenty = new HashMap();
    public static Map<Short, ParIndikatoru> defaultniIndikatoryAutority = new HashMap();
    public static Map<Short, PovoleneHodnotyIndikatoru> defaultniIndikatoryDokumentyPossible = new HashMap();
    public static Map<Short, PovoleneHodnotyIndikatoru> defaultniIndikatoryAutorityPossible = new HashMap();
    public static Map<Integer, DefLokace> lokaceMap = new HashMap();
    public static Map<Short, DefVypAkce> defVypAkceMap = new HashMap();
    public static boolean pritomenVypujcniRez = false;
    public static List<DefRez> rezy = new ArrayList();
    public static Map<Integer, DefRez> rezyMap = new HashMap();
    public static Map<String, DefRez> rezyNameMap = new HashMap();
    public static Set<String> rezyVycet = new HashSet();
    public static Map<Short, DefKultVzdel> defKultVzdelMap = new HashMap();
    public static Map<Short, DefMetodika> defMetodikaMap = new HashMap();
    public static List<DefCtenVyp> ctenVypList = new ArrayList();
    public static Map<Integer, DefUziv> uzivMap = new HashMap();
    public static Map<String, VsbDefFormaStudia> vsbDefFormaStudiaMap = new HashMap();
    public static Map<String, VsbDefTypStudia> vsbDefTypStudiaMap = new HashMap();
    public static Map<Short, VsbDefVztahuniv> vsbDefVztahunivMap = new HashMap();
    static final long UZIV_CACHE_LIMIT = 2000L;
    public static LoadingCache<Integer, Ctenari> ctenariCache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    public static LoadingCache<Integer, Uzivatele> uzivateleCache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    public static TableDescriptorProvider tableDescriptorProvider = new TableDescriptorProvider(ProxoolUtil.dataSource(), ProxoolUtil.engine());
    public static int opacUserID = -1;
    public static DefPujc pujcovnaUK = new DefPujc();
    public static volatile int sync = 0;
    public static int superUserID;
    public static int appServerUserID;
    public static PropertiesConfiguration vsbExternConfig;
    public static PropertiesConfiguration narArchExternConfig;
    public static PropertiesConfiguration tulDPConfig;
    private static Map<String, List<DefVal>> slovnikyMap;
    private static Map<Short, String> mapaPoradiPodpoli910;
    static boolean notInitCache;
    public static String seznamDokFond;
    public static String seznamAutFond;
    public static volatile boolean cacheHeated;

    public static final boolean jeDokFond(short fondId) {
        return defDokFondMap.containsKey(fondId);
    }

    public static final boolean jeAutFond(short fondId) {
        return defAutFondMap.containsKey(fondId);
    }

    public static final void cacheAll() throws SQLException {
        DbCache.cacheAll();
        tableDescriptorProvider.clear();
        DbCache2NG.cacheDummies();
        cacheHeated = true;
        Utils.postEvent((Object)new ForceRefreshAllEvent());
    }

    public static synchronized String poradiPodpoli910ProFond(short idFond) throws SQLException {
        String poradi = (String)mapaPoradiPodpoli910.get(idFond);
        if (poradi == null) {
            poradi = DbCache2NG.zjistiPoradiPodpoli910ProFond((short)idFond);
            mapaPoradiPodpoli910.put(idFond, poradi);
        }
        return poradi;
    }

    public static DefTypDPH zjistiTypDPH(short idTypDPH) {
        List seznamTypu = (List)defTypDPHMap.get(idTypDPH);
        Objects.requireNonNull(seznamTypu, "pozadovan nedefinovany typ DPH DEF_TYPDPH=" + idTypDPH);
        if (seznamTypu.isEmpty()) {
            throw new IllegalStateException("seznam typu DPH je prazdny, DEF_TYPDPH=" + idTypDPH);
        }
        Date now = Utils.now();
        return seznamTypu.stream().filter(typTemp -> !typTemp.getPLATI_OD().after(now)).findFirst().orElse(null);
    }

    @Deprecated
    public static DefRez rezByName(String name) {
        return rezy.stream().filter(rez -> StringUtils.equals((CharSequence)rez.getNAZEV(), (CharSequence)name)).findFirst().orElse(null);
    }

    public static void cacheOPACUserID(DataSource dataSource) {
        try {
            logger.info("zjistuji ID uzivatele OPAC");
            QueryRunnerOpened qr = new QueryRunnerOpened(dataSource);
            Object IDObject = qr.query("SELECT ID_UZIV FROM UZIVATELE WHERE USERNAME='OPAC'", (ResultSetHandler)new ScalarHandler());
            if (IDObject != null) {
                opacUserID = ((Number)IDObject).intValue();
                logger.info("OPAC user ID=" + IDObject);
            } else {
                logger.error("uzivatel OPAC nenalezen, JE POTREBA JEJ ZALOZIT!!!");
            }
        }
        catch (SQLException se) {
            logger.error("problem pri zjistovani OPAC_USERID");
        }
    }

    public static String najdiSlovoVeSlovniku(String klic, List<DefVal> validacniSlovnik) {
        return validacniSlovnik.stream().filter(defVal -> defVal.getOBSAH().equals(klic)).findFirst().map(DefVal::getPOPIS).orElse(null);
    }

    public static void cacheVsbMapovaniCtenKatList() {
        try {
            File definice = new File(KPWINServiceApplication.externDir + File.separator + "vsb_cten_kat.csv");
            if (definice.exists()) {
                ArrayList<VsbMapovaniCtenKat> vsbMapovaniCtenKatListTemp = new ArrayList<VsbMapovaniCtenKat>();
                List radky = IOUtils.readLines((InputStream)new FileInputStream(definice));
                for (String line : radky) {
                    if ((line = line.trim()).startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
                    StringTokenizer st = new StringTokenizer(line, ",");
                    try {
                        vsbMapovaniCtenKatListTemp.add(new VsbMapovaniCtenKat(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken()));
                    }
                    catch (Exception e) {
                        logger.warn("VSB cten_kat -> selhalo parsovani radku " + line);
                    }
                }
                vsbMapovaniCtenKatList = Collections.unmodifiableList(vsbMapovaniCtenKatListTemp);
                logger.info("nacteno mapovani ctenarskych kategorii pro VSB");
                logger.info("nova definice: " + vsbMapovaniCtenKatList);
            } else {
                logger.warn("soubor " + definice.getAbsolutePath() + " se nepodarilo nalezt");
            }
        }
        catch (Exception e) {
            logger.debug("selhani", (Throwable)e);
        }
    }

    public static String vsbNajdiCtenKat(String relationTypeId, String orgUnitAbbrev, String studyResidency, boolean ignorujPrazdne) throws AppServerStatus {
        String ctenKatString;
        int score = -1;
        VsbMapovaniCtenKat nejlepeVyhovujici = null;
        for (VsbMapovaniCtenKat mapovani : vsbMapovaniCtenKatList) {
            int pracovniSkore = 3;
            if (mapovani.relationTypeId.equals("*")) {
                --pracovniSkore;
            } else if (!mapovani.relationTypeId.equals(relationTypeId)) continue;
            if (mapovani.orgUnitAbbrev.equals("*")) {
                --pracovniSkore;
            } else if (!mapovani.orgUnitAbbrev.equals(orgUnitAbbrev)) continue;
            if (mapovani.studyResidency.equals("*")) {
                --pracovniSkore;
            } else if (!mapovani.studyResidency.equals(studyResidency)) continue;
            if (pracovniSkore <= score) continue;
            nejlepeVyhovujici = mapovani;
            score = pracovniSkore;
        }
        if (nejlepeVyhovujici == null) {
            if (!ignorujPrazdne) {
                logger.error("nepodarilo se nalezt zadnou vhodnout kategorii CTEN_KAT, to by NEMELO NASTAT, hledana kombinace je " + relationTypeId + ", " + orgUnitAbbrev + ", " + studyResidency);
                throw new AppServerStatus("neplatna kombinace relationTypeId/orgUnitAbbrev/studyResidency: " + relationTypeId + "/" + orgUnitAbbrev + "/" + studyResidency, 4);
            }
            ctenKatString = "";
        } else {
            ctenKatString = nejlepeVyhovujici.fkCtenKatString;
            if (!ignorujPrazdne && ctenKatString != null && ctenKatString.startsWith("#ERROR#")) {
                AppServerStatus ase = new AppServerStatus("neplatna kategorie", 5);
                ase.addReturnValue("ZPRAVA", ctenKatString.substring("#ERROR#".length()));
                throw ase;
            }
        }
        return ctenKatString;
    }

    public static void cacheVychoziIndikatory(Connection conn) {
        logger.info("cachuji vychozi hodnoty pro indikatory");
        HashMap defaultniIndikatoryDokumentyTemp = new HashMap();
        HashMap defaultniIndikatoryAutorityTemp = new HashMap();
        HashMap defaultniIndikatoryDokumentyPossibleTemp = new HashMap();
        HashMap defaultniIndikatoryAutorityPossibleTemp = new HashMap();
        try {
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List seznamIndikatoruDokumenty = (List)qr.query("SELECT * FROM DEF_DOKINDIK ORDER BY CIS_POL", (ResultSetHandler)new KPSYSBeanListHandler(DefIndik.class));
            List seznamIndikatoruAutority = (List)qr.query("SELECT * FROM DEF_AUTINDIK ORDER BY CIS_POL", (ResultSetHandler)new KPSYSBeanListHandler(DefIndik.class));
            DbCache2.naplnIndikatory(defaultniIndikatoryDokumentyTemp, (List)seznamIndikatoruDokumenty, defaultniIndikatoryDokumentyPossibleTemp);
            DbCache2.naplnIndikatory(defaultniIndikatoryAutorityTemp, (List)seznamIndikatoruAutority, defaultniIndikatoryAutorityPossibleTemp);
        }
        catch (Exception e) {
            logger.error("selhani", (Throwable)e);
        }
        defaultniIndikatoryDokumenty = Collections.unmodifiableMap(defaultniIndikatoryDokumentyTemp);
        defaultniIndikatoryAutority = Collections.unmodifiableMap(defaultniIndikatoryAutorityTemp);
        defaultniIndikatoryDokumentyPossible = Collections.unmodifiableMap(defaultniIndikatoryDokumentyPossibleTemp);
        defaultniIndikatoryAutorityPossible = Collections.unmodifiableMap(defaultniIndikatoryAutorityPossibleTemp);
    }

    private static void naplnIndikatory(HashMap<Short, ParIndikatoru> defaultniIndikatoryDokumentyTemp, List<DefIndik> seznamIndikatoru, Map<Short, PovoleneHodnotyIndikatoru> defaultniIndikatoryPossibleTemp) {
        for (DefIndik indikator : seznamIndikatoru) {
            short cisloPole = indikator.getCIS_POL();
            if (StringUtils.isNotBlank((CharSequence)indikator.getI1())) {
                if (defaultniIndikatoryPossibleTemp.get(cisloPole) == null) {
                    defaultniIndikatoryPossibleTemp.put(cisloPole, new PovoleneHodnotyIndikatoru());
                }
                defaultniIndikatoryPossibleTemp.get((Object)Short.valueOf((short)cisloPole)).ind1 = defaultniIndikatoryPossibleTemp.get((Object)Short.valueOf((short)cisloPole)).ind1 + indikator.getI1();
            }
            if (StringUtils.isNotBlank((CharSequence)indikator.getI2())) {
                if (defaultniIndikatoryPossibleTemp.get(cisloPole) == null) {
                    defaultniIndikatoryPossibleTemp.put(cisloPole, new PovoleneHodnotyIndikatoru());
                }
                defaultniIndikatoryPossibleTemp.get((Object)Short.valueOf((short)cisloPole)).ind2 = defaultniIndikatoryPossibleTemp.get((Object)Short.valueOf((short)cisloPole)).ind2 + indikator.getI2();
            }
            if (!indikator.isJE_DEFAULT()) continue;
            ParIndikatoru parIndikatoru = defaultniIndikatoryDokumentyTemp.get(indikator.getCIS_POL());
            if (parIndikatoru == null) {
                parIndikatoru = new ParIndikatoru();
                defaultniIndikatoryDokumentyTemp.put(indikator.getCIS_POL(), parIndikatoru);
            }
            if (StringUtils.isNotBlank((CharSequence)indikator.getI1())) {
                parIndikatoru.ind1 = indikator.getI1();
            } else if (parIndikatoru.ind1 == null) {
                parIndikatoru.ind1 = "";
            }
            if (StringUtils.isNotBlank((CharSequence)indikator.getI2())) {
                parIndikatoru.ind2 = indikator.getI2();
                continue;
            }
            if (parIndikatoru.ind2 != null) continue;
            parIndikatoru.ind2 = "";
        }
    }

    public static void cacheDefVypAkce(Connection conn) {
        logger.info("cachuji typy akci u vypujcek");
        HashMap<Short, DefVypAkce> defVypAkceMapTemp = new HashMap<Short, DefVypAkce>();
        try {
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List seznamDefVypAkce = (List)qr.query("SELECT * FROM DEF_VYPAKCE ORDER BY ID_VYPAKCE", (ResultSetHandler)new KPSYSBeanListHandler(DefVypAkce.class));
            for (DefVypAkce vypAkce : seznamDefVypAkce) {
                defVypAkceMapTemp.put(vypAkce.getID_VYPAKCE(), vypAkce);
            }
        }
        catch (Exception e) {
            logger.error("selhani", (Throwable)e);
        }
        defVypAkceMap = Collections.unmodifiableMap(defVypAkceMapTemp);
    }

    public static void cacheDefSkriptTrida(Connection conn) {
        logger.info("cachuji typy skriptovych trid");
        HashMap<Short, DefSkriptTrida> defSkriptTridaMapTemp = new HashMap<Short, DefSkriptTrida>();
        try {
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List seznamDekSkriptTrida = (List)qr.query("SELECT * FROM DEF_SKRIPT_TRIDA ORDER BY ID_SKRIPT_TRIDA", (ResultSetHandler)new KPSYSBeanListHandler(DefSkriptTrida.class));
            for (DefSkriptTrida skriptTrida : seznamDekSkriptTrida) {
                defSkriptTridaMapTemp.put(skriptTrida.getID_SKRIPT_TRIDA(), skriptTrida);
            }
        }
        catch (Exception e) {
            logger.error("selhani", (Throwable)e);
        }
        defSkriptTridaMap = Collections.unmodifiableMap(defSkriptTridaMapTemp);
    }

    public static void cacheDefPujcLok(Connection conn) {
        logger.info("cachuji vazbu pujcovny <-> lokace");
        LinkedList defPujcLokTemp = new LinkedList();
        try {
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            KPSYSBeanListHandler listHandler = new KPSYSBeanListHandler(DefPujcLok.class);
            defPujcLokTemp.addAll((Collection)qr.query("SELECT * FROM DEF_PUJC_LOK", (ResultSetHandler)listHandler));
        }
        catch (Exception e) {
            logger.error("selhani", (Throwable)e);
        }
        defPujcLok = Collections.unmodifiableList(defPujcLokTemp);
    }

    public static void cacheRezy(Connection conn) {
        logger.info("cachuji definice rezu");
        ArrayList rezyTemp = new ArrayList();
        HashMap<Integer, DefRez> rezyMapTemp = new HashMap<Integer, DefRez>();
        HashMap<String, DefRez> rezyNameMapTemp = new HashMap<String, DefRez>();
        HashSet<String> rezyVycetTemp = new HashSet<String>();
        try {
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            KPSYSBeanListHandler listHandler = new KPSYSBeanListHandler(DefRez.class);
            rezyTemp.addAll((Collection)qr.query("SELECT * FROM DEF_REZ ORDER BY ID_REZ", (ResultSetHandler)listHandler));
            for (DefRez rez : rezyTemp) {
                rezyVycetTemp.add(rez.getNAZEV());
            }
        }
        catch (Exception e) {
            logger.error("selhani", (Throwable)e);
        }
        boolean pritomenVypujcniRezTemp = false;
        HashSet<String> vypujcniRezyNazvy = new HashSet<String>();
        vypujcniRezyNazvy.add("REZS_DOSTUPNOST");
        vypujcniRezyNazvy.add("REZS_PUJC_VOLNA_ABS");
        vypujcniRezyNazvy.add("REZS_PUJC_VOLNA_PREZ");
        for (DefRez defRez : rezyTemp) {
            rezyMapTemp.put(defRez.getID_REZ(), defRez);
            rezyNameMapTemp.put(defRez.getNAZEV(), defRez);
            if (!vypujcniRezyNazvy.contains(defRez.getNAZEV())) continue;
            pritomenVypujcniRezTemp = true;
            break;
        }
        rezy = Collections.unmodifiableList(rezyTemp);
        rezyMap = Collections.unmodifiableMap(rezyMapTemp);
        rezyNameMap = Collections.unmodifiableMap(rezyNameMapTemp);
        rezyVycet = Collections.unmodifiableSet(rezyVycetTemp);
        pritomenVypujcniRez = pritomenVypujcniRezTemp;
        RezyFactory.cacheRefresh();
    }

    public static void cacheFondMap(Connection conn) {
        try {
            logger.info("cachuji do pameti DEF_FOND");
            HashMap<Short, DefFond> defDokFondMapTemp = new HashMap<Short, DefFond>();
            HashMap<Short, DefFond> defAutFondMapTemp = new HashMap<Short, DefFond>();
            HashMap<Short, DefFond> defFondMapTemp = new HashMap<Short, DefFond>();
            HashSet<Short> fondyAutoritZdrojovyDokumentTemp = new HashSet<Short>();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List dokFondMapKeys = (List)qr.query("SELECT * FROM DEF_FOND", (ResultSetHandler)new KPSYSBeanListHandler(DefFond.class));
            for (DefFond defFond : dokFondMapKeys) {
                if (defFond.isJE_AUTORITNI()) {
                    defAutFondMapTemp.put(defFond.getID_FOND(), defFond);
                    if (defFond.isJE_ZDROJ()) {
                        fondyAutoritZdrojovyDokumentTemp.add(defFond.getID_FOND());
                    }
                } else {
                    defDokFondMapTemp.put(defFond.getID_FOND(), defFond);
                }
                defFondMapTemp.put(defFond.getID_FOND(), defFond);
            }
            defDokFondMap = Collections.unmodifiableMap(defDokFondMapTemp);
            defAutFondMap = Collections.unmodifiableMap(defAutFondMapTemp);
            defFondMap = Collections.unmodifiableMap(defFondMapTemp);
            fondyAutoritZdrojovyDokument = fondyAutoritZdrojovyDokumentTemp;
            Tuple2 seznamy = DbCache2Helper.seznamyDokAutFondu(defDokFondMap.values(), defAutFondMap.values());
            seznamDokFond = (String)seznamy._1;
            seznamAutFond = (String)seznamy._2;
            mapaPoradiPodpoli910.clear();
            DbCache2Helper.zpracujFiltry();
            logger.debug("debug info: definice defAutFondMap " + StringUtils.join(defDokFondMap.keySet(), (String)","));
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani DEF_FOND", (Throwable)se);
        }
    }

    public static void cacheDefKultVzdelMap(Connection conn) {
        try {
            logger.info("cachuji do pameti DEF_KULTVZDEL");
            HashMap<Short, DefKultVzdel> defKultVzdelMapTemp = new HashMap<Short, DefKultVzdel>();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List defStatusList = (List)qr.query("SELECT * FROM DEF_KULTVZDEL", (ResultSetHandler)new KPSYSBeanListHandler(DefKultVzdel.class));
            for (DefKultVzdel defKultVzdel : defStatusList) {
                defKultVzdelMapTemp.put(defKultVzdel.getID_TYP_KULTVZDEL(), defKultVzdel);
            }
            defKultVzdelMap = Collections.unmodifiableMap(defKultVzdelMapTemp);
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani DEF_KULTVZDEL", (Throwable)se);
        }
    }

    public static void cacheDefMetodikaMap(Connection conn) {
        try {
            logger.info("cachuji do pameti DEF_METODIKA");
            HashMap<Short, DefMetodika> defMetodikaMapTemp = new HashMap<Short, DefMetodika>();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List defMetodikaList = (List)qr.query("SELECT * FROM DEF_METODIKA", (ResultSetHandler)new KPSYSBeanListHandler(DefMetodika.class));
            for (DefMetodika defKultVzdel : defMetodikaList) {
                defMetodikaMapTemp.put(defKultVzdel.getID_TYP_METODIKA(), defKultVzdel);
            }
            defMetodikaMap = defMetodikaMapTemp;
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani DEF_METODIKA", (Throwable)se);
        }
    }

    public static synchronized void cacheFondyToSyncToCI() {
        HashMap fondyToSyncToCIMapTemp = new HashMap();
        for (CentralServer centralServer : centralServerCreds.values()) {
            short dbId = centralServer.getCISLO_DATABAZE();
            String asURL = centralServer.getSERVER_ADRESA();
            HashSet<Integer> ciSet = new HashSet<Integer>();
            fondyToSyncToCIMapTemp.put(centralServer.getID_CENTRAL_SERVER(), ciSet);
            try {
                String[] fondyString;
                String odpoved = CISyncExecutor.queryCI((String)asURL, (String)String.valueOf(dbId)).trim();
                for (String fondString : fondyString = odpoved.split(",")) {
                    ciSet.add(Integer.valueOf(fondString));
                }
            }
            catch (Exception e) {
                logger.error("selhalo zjisteni potrebnych fondu k synchronizaci " + centralServer, (Throwable)e);
            }
        }
        fondyToSyncToCIMap = fondyToSyncToCIMapTemp;
    }

    public static void cacheUzivMapAndSU(DataSource dataSource) {
        logger.info("cachuji do pameti uzivatele a jejich prava");
        HashMap<Integer, DefUziv> uzivMapTemp = new HashMap<Integer, DefUziv>();
        QueryRunnerOpened qr = new QueryRunnerOpened(dataSource);
        List defUzivList = (List)qr.query("SELECT * FROM DEF_UZIV", (ResultSetHandler)new KPSYSBeanListHandler(DefUziv.class));
        for (DefUziv defUziv : defUzivList) {
            uzivMapTemp.put(defUziv.getFK_UZIV(), defUziv);
        }
        uzivMap = uzivMapTemp;
        superUserID = DbCache2.findSuperUserID((Map)uzivMap);
        String APPSERVER_SOFTWARE_NAZEV = "KP-SYS Appserver";
        appServerUserID = (Integer)qr.query("SELECT FK_UZIV FROM SOFTWARE WHERE NAZEV=?", (ResultSetHandler)BeanHandlers.INTEGER_HANDLER(), new Object[]{"KP-SYS Appserver"});
        logger.info("nalezeno ID systemoveho uctu appserver: " + appServerUserID);
    }

    private static int findSuperUserID(Map<Integer, DefUziv> uzivMap) {
        logger.info("zjistuji ID superuzivatele");
        for (DefUziv defUziv : uzivMap.values()) {
            if (defUziv.getUROVEN() != 0) continue;
            logger.info("nalezeno ID superuzivatele, ID=" + defUziv.getFK_UZIV());
            return defUziv.getFK_UZIV();
        }
        DefUziv firstUser = uzivMap.values().iterator().next();
        if (firstUser != null) {
            logger.error("nenalezen superuzivatel, pouzivam uzivatele " + firstUser);
            return firstUser.getFK_UZIV();
        }
        throw new IllegalStateException("v databazi nebyl nalezen zadny uzivatel");
    }

    public static void cacheCentralDatabase(Connection conn) {
        if (!KPWINServiceApplication.configuration.masterMode) {
            return;
        }
        try {
            logger.info("cachuji do pameti seznam vzdalenych bazi");
            HashMap<Short, CentralDatabaze> centralDatabazeMapTemp = new HashMap<Short, CentralDatabaze>();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List centralDatabaseMapKeys = (List)qr.query("SELECT * FROM CENTRAL_DATABAZE", (ResultSetHandler)new KPSYSBeanListHandler(CentralDatabaze.class));
            scala.collection.immutable.Map centralDatabaseGroupMapTemp = DbCache2NG.groupedCentralDatabaseMap((List)centralDatabaseMapKeys);
            for (CentralDatabaze centralDatabaze : centralDatabaseMapKeys) {
                centralDatabazeMapTemp.put(centralDatabaze.getID_DATABAZE(), centralDatabaze);
            }
            centralDatabazeMap = centralDatabazeMapTemp;
            DbCache2NG.centralDatabaseGroupMap_$eq((scala.collection.immutable.Map)centralDatabaseGroupMapTemp);
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani seznamu vzdalenych bazi", (Throwable)se);
        }
    }

    public static void cacheCentralMapaFondu(Connection conn) {
        try {
            logger.info("cachuji do pameti mapu fondu");
            HashMap<Short, Map> centralMapaFonduMapMapTemp = new HashMap<Short, Map>();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List centralMapaFondus = (List)qr.query("SELECT * FROM CENTRAL_MAPA_FONDU", (ResultSetHandler)new KPSYSBeanListHandler(CentralMapaFondu.class));
            for (CentralMapaFondu centralMapaFondu : centralMapaFondus) {
                short fkDatabaze = centralMapaFondu.getFK_DATABAZE();
                centralMapaFonduMapMapTemp.computeIfAbsent(fkDatabaze, k -> new HashMap()).put(centralMapaFondu.getFK_FOND_LOCAL(), centralMapaFondu);
            }
            centralMapaFonduMapMap = centralMapaFonduMapMapTemp;
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani mapy fondu", (Throwable)se);
        }
    }

    public static ZServerInfo getZServerInfo(short id) {
        DefZServer defZServer = (DefZServer)((Map)DbCache2NG.zServerMap().get()).get(id);
        if (defZServer == null) {
            return null;
        }
        try {
            ZServerFormat zServerFormat;
            String popis = defZServer.getPOPIS();
            String database = defZServer.getDATABAZE();
            String charset = defZServer.getCHARSET();
            String format = defZServer.getFORMAT();
            String uzivatel = defZServer.getUZIVATEL();
            String heslo = defZServer.getHESLO();
            int timeoutSekundy = defZServer.getTIMEOUT();
            short prenos = defZServer.getPRENOS();
            String[] hostPort = defZServer.getADRESA().split(":");
            String host = hostPort[0];
            int port = hostPort.length == 1 ? 220 : Integer.parseInt(hostPort[1]);
            ZServerID zServerID = ZServerID.apply((Enumeration.Value)ZServerType.DB(), (String)String.valueOf(id));
            String zServerCharset = StandardCharsets.UTF_8.toString().equalsIgnoreCase(charset) || "UTF8".equalsIgnoreCase(charset) ? StandardCharsets.UTF_8.toString() : ("WIN-1250".equalsIgnoreCase(charset) || "WIN1250".equalsIgnoreCase(charset) ? "WINDOWS-1250" : "LATIN-1");
            if ("ISO2709".equalsIgnoreCase(format)) {
                zServerFormat = ZServerFormat.ISO2709;
            } else if ("XML".equalsIgnoreCase(format)) {
                logger.error("XML format neni ZClientem podporovan");
                zServerFormat = ZServerFormat.XML;
            } else if ("KPPORTAL".equalsIgnoreCase(format)) {
                logger.error("KPPORTAL format neni ZClientem podporovan");
                zServerFormat = ZServerFormat.KPPORTAL;
            } else {
                logger.error("neznamy typ formatu Z39.50 serveru, pouzivam ISO2709: " + format);
                zServerFormat = ZServerFormat.ISO2709;
            }
            return ZServerInfo.apply((ZServerID)zServerID, (String)host, (int)port, (String)database, (defZServer.getJE_AUTORITNI() > 0 ? 1 : 0) != 0, (String)zServerCharset, (String)uzivatel, (String)heslo, (int)prenos, (int)timeoutSekundy, (String)popis, (ZServerFormat)zServerFormat);
        }
        catch (Exception e) {
            logger.error("doslo k chybe pri parsovani dat z tabulky DEF_ZSERVER " + id, (Throwable)e);
            return null;
        }
    }

    static void cacheNastaveniExportu() {
        GeneratorPolePrirustky.pripravMapuPodpoli();
    }

    static void parseCI() {
        centralServerCreds = DbCache2Helper.parseCI();
        DbCache2.cacheFondyToSyncToCI();
    }

    public static void cacheSlovnikyKlicaVylSlov(Connection conn) {
        try {
            logger.info("cachuji do pameti slovniky vyloucenych a klicovanych slov");
            HashSet defKliSlovTemp = new HashSet();
            HashSet defVylSlovTemp = new HashSet();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            defVylSlovTemp.addAll((Collection)qr.query("SELECT SLOVO FROM DEF_VYLSLOV", (ResultSetHandler)BeanHandlers.STRING_LIST_HANDLER()));
            defKliSlovTemp.addAll((Collection)qr.query("SELECT SLOVO FROM DEF_KLISLOV", (ResultSetHandler)BeanHandlers.STRING_LIST_HANDLER()));
            defKliSlov = defKliSlovTemp;
            defVylSlov = defVylSlovTemp;
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani slovniku vyloucenych a klicovanych slov", (Throwable)se);
        }
    }

    public static void cacheDefPopl(Connection conn) {
        try {
            logger.info("cachuji do pameti ciselnik poplatku");
            HashMap<Short, DefPopl> defPoplMapTemp = new HashMap<Short, DefPopl>();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List seznam = (List)qr.query("SELECT * FROM DEF_POPL", (ResultSetHandler)new KPSYSBeanListHandler(DefPopl.class));
            for (DefPopl defPopl : seznam) {
                defPoplMapTemp.put(defPopl.getID_POPL(), defPopl);
            }
            defPoplMap = defPoplMapTemp;
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani ciselniku poplatku", (Throwable)se);
        }
    }

    public static void cacheDefTypDPH(Connection conn) {
        try {
            logger.info("cachuji do pameti definice sazeb DPH");
            HashMap defTypDPHMapTemp = new HashMap();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List seznam = (List)qr.query("SELECT * FROM DEF_TYPDPH ORDER BY TYPDPH ASC, PLATI_OD DESC", (ResultSetHandler)new KPSYSBeanListHandler(DefTypDPH.class));
            for (DefTypDPH defTypDPH : seznam) {
                Short typDPH = defTypDPH.getTYPDPH();
                if (!defTypDPHMapTemp.containsKey(typDPH)) {
                    defTypDPHMapTemp.put(typDPH, new ArrayList());
                }
                ((List)defTypDPHMapTemp.get(typDPH)).add(defTypDPH);
            }
            defTypDPHMap = defTypDPHMapTemp;
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani definic sazeb DPH", (Throwable)se);
        }
    }

    public static void cacheStyly(Connection conn) {
        try {
            logger.info("cachuji do pameti styly pro JE_VSTUP=1");
            HashMap<Short, Styly> stylyMapTemp = new HashMap<Short, Styly>();
            HashMap stylyCompleteMapTemp = new HashMap();
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List styly = (List)qr.query("SELECT * FROM styly ORDER BY poradi_pole ASC, poradi_podp ASC", (ResultSetHandler)new KPSYSBeanListHandler(Styly.class));
            for (Styly styl : styly) {
                stylyCompleteMapTemp.computeIfAbsent(styl.ID_STYL, k -> new ArrayList()).add(styl);
                if (!styl.JE_VSTUP) continue;
                stylyMapTemp.put(styl.ID_STYL, styl);
            }
            for (Short idStyl : stylyCompleteMapTemp.keySet()) {
                List list = (List)stylyCompleteMapTemp.get(idStyl);
                stylyCompleteMapTemp.put(idStyl, Collections.unmodifiableList(list));
            }
            stylyMap = stylyMapTemp;
            stylyCompleteMap = Collections.unmodifiableMap(stylyCompleteMapTemp);
            mapaPoradiPodpoli910.clear();
            DbCache2.cacheNastaveniExportu();
        }
        catch (SQLException se) {
            logger.error("chyba pri cachovani stylu", (Throwable)se);
        }
    }

    public static void cacheLokace(Connection conn) {
        try {
            Map<Integer, DefLokace> lokaceMapTemp;
            logger.info("cachuji do pameti lokace");
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List lokaceList = (List)qr.query("SELECT * FROM DEF_LOKACE", (ResultSetHandler)new KPSYSBeanListHandler(DefLokace.class));
            lokaceMap = lokaceMapTemp = lokaceList.stream().collect(Collectors.toMap(DefLokace::getID_LOKACE, lokace -> lokace, (a, b) -> b));
        }
        catch (SQLException se) {
            logger.error("chyba pri cachovani lokaci");
        }
    }

    public static Map<String, Lokalizace> loadLokalizace(Connection conn) {
        HashMap<String, Lokalizace> lokalizaceMapTemp = new HashMap<String, Lokalizace>();
        try {
            logger.info("cachuji do pameti loka(liza)ce");
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List lokalizaceList = (List)qr.query("SELECT * FROM LOKALIZACE", (ResultSetHandler)new KPSYSBeanListHandler(Lokalizace.class));
            for (Lokalizace lokalizace : lokalizaceList) {
                lokalizaceMapTemp.put(lokalizace.getID_LOKALIZACE(), lokalizace);
            }
        }
        catch (SQLException se) {
            logger.error("chyba pri cachovani kolaloka-lizaci");
        }
        return Collections.unmodifiableMap(lokalizaceMapTemp);
    }

    public static void cacheVsb(Connection conn) {
        try {
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            int tabulkaExistuje = (Integer)qr.query("SELECT COUNT(*) FROM RDB$RELATIONS WHERE RDB$RELATION_NAME = 'VSB_DEF_FORMA_STUDIA'", (ResultSetHandler)new IntegerHandler(Integer.valueOf(0)));
            if (tabulkaExistuje > 0) {
                logger.info("cachuji do pameti tabulky VSB");
                HashMap<String, VsbDefFormaStudia> vsbDefFormaStudiaMapTemp = new HashMap<String, VsbDefFormaStudia>();
                HashMap<String, VsbDefTypStudia> vsbDefTypStudiaMapTemp = new HashMap<String, VsbDefTypStudia>();
                HashMap<Short, VsbDefVztahuniv> vsbDefVztahunivMapTemp = new HashMap<Short, VsbDefVztahuniv>();
                List vsbDefFormaStudiaList = (List)qr.query("SELECT * FROM VSB_DEF_FORMA_STUDIA", (ResultSetHandler)new KPSYSBeanListHandler(VsbDefFormaStudia.class));
                for (Object item : vsbDefFormaStudiaList) {
                    vsbDefFormaStudiaMapTemp.put(item.getID_FORMA_STUDIA(), (VsbDefFormaStudia)item);
                }
                List vsbDefTypStudiaList = (List)qr.query("SELECT * FROM VSB_DEF_TYP_STUDIA", (ResultSetHandler)new KPSYSBeanListHandler(VsbDefTypStudia.class));
                for (VsbDefTypStudia item : vsbDefTypStudiaList) {
                    vsbDefTypStudiaMapTemp.put(item.getID_TYP_STUDIA(), item);
                }
                List vsbDefVztahunivList = (List)qr.query("SELECT * FROM VSB_DEF_VZTAHUNIV", (ResultSetHandler)new KPSYSBeanListHandler(VsbDefVztahuniv.class));
                for (VsbDefVztahuniv item : vsbDefVztahunivList) {
                    vsbDefVztahunivMapTemp.put(item.getPORADI(), item);
                }
                vsbDefFormaStudiaMap = vsbDefFormaStudiaMapTemp;
                vsbDefTypStudiaMap = vsbDefTypStudiaMapTemp;
                vsbDefVztahunivMap = vsbDefVztahunivMapTemp;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void cacheCtenVyp(Connection conn) {
        try {
            logger.info("cachuji do pameti kombinace kategorii ctenaru a vypujcek");
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            List seznam = (List)qr.query("SELECT * FROM DEF_CTENVYP", (ResultSetHandler)new KPSYSBeanListHandler(DefCtenVyp.class));
            ctenVypList = new ArrayList(seznam);
        }
        catch (SQLException se) {
            logger.error("problem pri cachovani kombinaci kategorii ctenaru a vypujcek", (Throwable)se);
        }
    }

    public static ZpusobKlicovani najdiZpusobKlicovani(boolean isAuthority, int cisloPole, String prefixPodpole) {
        FDef fdef;
        FDefAut fdefAut;
        ZpusobKlicovani zpusobKlicovani = isAuthority ? ((fdefAut = DbCache2.najdiFDefAut((int)cisloPole, (String)prefixPodpole)) == null ? ZpusobKlicovani.STANDARD : fdefAut.zjistiZpusobKlicovani()) : ((fdef = DbCache2.najdiFDef((int)cisloPole, (String)prefixPodpole)) == null ? ZpusobKlicovani.STANDARD : fdef.zjistiZpusobKlicovani());
        return zpusobKlicovani;
    }

    public static FDef najdiFDef(int cisloPole, String prefixPodpole) {
        return (FDef)((Map)DbCache2NG.fdefSourceMap().get()).get(cisloPole + "#" + StringUtils.defaultString((String)prefixPodpole));
    }

    public static FDefAut najdiFDefAut(int cisloPole, String prefixPodpole) {
        return (FDefAut)((Map)DbCache2NG.fdefSourceAutMap().get()).get(cisloPole + "#" + StringUtils.defaultString((String)prefixPodpole));
    }

    public static Styly najdiVstupniStylProFond(Short fond) throws SQLException {
        DefFond defFond = (DefFond)defFondMap.get(fond);
        if (defFond == null) {
            throw new SQLException("neexistujici fond " + fond);
        }
        Styly styl = (Styly)stylyMap.get(defFond.getFK_STYL());
        if (styl == null) {
            throw new SQLException("nenalezen STYL pro fond " + fond);
        }
        return styl;
    }

    public static short najdiVstupniPoleFondu(Short fond) throws SQLException {
        Styly styl = DbCache2.najdiVstupniStylProFond((Short)fond);
        return styl.CIS_POL;
    }

    private static List<DefVal> nactiSlovnik(String kodVal) throws SQLException {
        LinkedList<DefVal> slovnik = new LinkedList<DefVal>();
        QueryRunner qr = ProxoolUtil.obtainQueryRunnerRO();
        String postfix = kodVal.startsWith("VAL") ? kodVal.substring(3) : (kodVal.startsWith("EDV") ? kodVal.substring(3) : kodVal);
        slovnik.addAll((Collection)qr.query("SELECT * FROM DEF_VAL WHERE KOD_VAL=? ORDER BY PORADI", (ResultSetHandler)new KPSYSBeanListHandler(DefVal.class), new Object[]{postfix}));
        return slovnik;
    }

    public static synchronized List<DefVal> validacniSlovnik(String kodVal) throws SQLException {
        if (!slovnikyMap.containsKey(kodVal)) {
            List slovnik = DbCache2.nactiSlovnik((String)kodVal);
            slovnikyMap.put(kodVal, slovnik);
        }
        return (List)slovnikyMap.get(kodVal);
    }

    public static String queryVypujcFlag(String vypucFlag, short fkPujc) throws SQLException {
        String flag = DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)vypucFlag, (Short)fkPujc, null);
        if (flag == null) {
            logger.error("pozadovan neexistujici klic z INI: " + vypucFlag);
            flag = "";
        }
        return flag;
    }

    public static boolean queryIINIFlagIsTrue(String sekce, String flag, Short fkPujc, Short cisFond) {
        String value = DbCache2.queryINIFlag((String)sekce, (String)flag, (Short)fkPujc, (Short)cisFond);
        return GenericExecutor.tagHasTrueValue((String)value);
    }

    public static boolean queryIINIFlagIsFalse(String sekce, String flag, Short fkPujc, Short cisFond) {
        String value = DbCache2.queryINIFlag((String)sekce, (String)flag, (Short)fkPujc, (Short)cisFond);
        return "NE".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value) || value == null;
    }

    public static String queryINIFlag(IniConstants.Sekce sekce, String flag, Short fkPujc, Short cisFond) {
        return DbCache2.queryINIFlag((String)sekce.sekce(), (String)flag, (Short)fkPujc, (Short)cisFond);
    }

    public static String queryINIFlag(String sekcePar, String flagPar, Short fkPujc, Short cisFond) {
        String cisFondString;
        String pujcString;
        String flag;
        String sekce = sekcePar.toUpperCase();
        String hodnota = DbCache2.najdiHodnotuKlice((String)sekce, (String)(flag = flagPar.toUpperCase()), (String)(pujcString = fkPujc == null ? "0" : fkPujc.toString()), (String)(cisFondString = cisFond == null ? "" : cisFond.toString()));
        if (hodnota != null) {
            return hodnota;
        }
        if (fkPujc != null) {
            Short fkPujcNadr = DbCache.nejblizsiNadrazenaPujcovna((Short)fkPujc);
            return DbCache2.queryINIFlag((String)sekce, (String)flag, (Short)fkPujcNadr, (Short)cisFond);
        }
        IniKeys iniKey = (IniKeys)((Map)DbCache2NG.iniKeysMap().get()).get(sekce + ":" + flag);
        if (iniKey != null) {
            return iniKey.getDEFVAL();
        }
        if (!"SERIAL".equals(flag)) {
            logger.info("Nenalezen klic [" + sekce + "]" + flag);
        }
        return null;
    }

    private static String najdiHodnotuKlice(String sekce, String flag, String pujcString, String cisFondString) {
        String hodnota = DbCache2.najdiKlic((String)sekce, (String)flag, (String)pujcString, (String)cisFondString);
        if (hodnota != null) {
            return hodnota;
        }
        hodnota = DbCache2.najdiKlic((String)sekce, (String)flag, (String)pujcString, null);
        if (hodnota != null) {
            return hodnota;
        }
        hodnota = DbCache2.najdiKlic((String)sekce, (String)flag, null, (String)cisFondString);
        if (hodnota != null) {
            return hodnota;
        }
        hodnota = DbCache2.najdiKlic((String)sekce, (String)flag, null, null);
        if (hodnota != null) {
            return hodnota;
        }
        return null;
    }

    private static String getIniKey(String sekce, String flag, String pujcString, String cisFondString) {
        String pujcID = pujcString == null ? "0" : pujcString;
        String cisFondID = cisFondString == null ? "" : cisFondString;
        String key = sekce + ":" + flag + ":" + pujcID + ":" + cisFondID;
        return key;
    }

    private static String najdiKlic(String sekce, String flag, String pujcString, String cisFondString) {
        String key = DbCache2.getIniKey((String)sekce, (String)flag, (String)pujcString, (String)cisFondString);
        IniFile iniFile = (IniFile)((Map)DbCache2NG.iniFileMap().get()).get(key);
        if (iniFile != null) {
            return iniFile.getHODNOTA();
        }
        if ("0".equals(pujcString)) {
            String keyAlt = DbCache2.getIniKey((String)sekce, (String)flag, (String)"", (String)cisFondString);
            IniFile iniFileAlt = (IniFile)((Map)DbCache2NG.iniFileMap().get()).get(keyAlt);
            if (iniFileAlt != null) {
                logger.error("pritomen klic s FK_PUJC IS NULL => " + keyAlt + " - misto toho by mel mit nastavenou ROOT pujcovnu");
                return iniFileAlt.getHODNOTA();
            }
        }
        return null;
    }

    public static boolean isNotInitCache() {
        return notInitCache;
    }

    public static void setNotInitCache(boolean notInitCache) {
        DbCache2.notInitCache = notInitCache;
    }

    public static void vycistiValidacniSlovniky() {
        slovnikyMap.clear();
    }

    @Deprecated
    public static Set<Integer> queryChranenaPole(int fond) {
        HashSet<Integer> pole = new HashSet<Integer>();
        String value = DbCache2.queryINIFlag((String)IniConstants.SEKCE_KATALOGIZACE(), (String)IniConstants.KATALOGIZACE_CHRANENAPOLE(), null, (Short)((short)fond));
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] tokens;
            for (String token : tokens = value.split("[;,]")) {
                try {
                    int cisloPole = Integer.parseInt(token);
                    pole.add(cisloPole);
                }
                catch (NumberFormatException nfe) {
                    logger.warn("neplatne cislo pole v klici ChranenaPole" + fond);
                }
            }
        }
        return pole;
    }

    public static boolean jePERIO(short fK_DOKFOND) {
        if (DbCache2.jeAutFond((short)fK_DOKFOND)) {
            return false;
        }
        DefFond defDokFond = (DefFond)defDokFondMap.get(fK_DOKFOND);
        if (defDokFond == null) {
            return false;
        }
        return defDokFond.isJE_PERIO();
    }

    public static void cacheVirtualniPoleIndexace() {
        logger.info("cachuji virtualni pole indexace");
        ArrayList<FiktivniPoleIndexace> virtualniPoleIndexaceTemp = new ArrayList<FiktivniPoleIndexace>();
        String oznaceniSekce = "HLED_PODPOLE";
        Set klice = ((Map)DbCache2NG.iniFileMap().get()).keySet();
        for (String klic : klice) {
            try {
                String sourceSubfield;
                int sourceField;
                int idx;
                if (!klic.startsWith("HLED_PODPOLE")) continue;
                IniFile ini = (IniFile)((Map)DbCache2NG.iniFileMap().get()).get(klic);
                FiktivniPoleIndexace fiktivniPoleIndexace = new FiktivniPoleIndexace();
                String hodnota = ini.getHODNOTA();
                String id = ini.getFK_KLIC();
                String typ = "D";
                if (hodnota.contains("|")) {
                    int slashIndex = hodnota.indexOf(124);
                    typ = hodnota.substring(slashIndex + 1);
                    hodnota = hodnota.substring(0, slashIndex);
                }
                if ((idx = id.indexOf("_")) > -1) {
                    sourceField = Integer.parseInt(id.substring(0, idx));
                    sourceSubfield = id.substring(idx + 1);
                } else {
                    sourceField = Integer.parseInt(id);
                    sourceSubfield = null;
                }
                fiktivniPoleIndexace.setSourceFieldNumber(sourceField);
                fiktivniPoleIndexace.setSourceSubFieldPrefix(sourceSubfield);
                fiktivniPoleIndexace.setDestinationFieldNumber(Short.parseShort(hodnota));
                fiktivniPoleIndexace.setZpusobKlicovani(ZpusobKlicovani.STANDARD);
                fiktivniPoleIndexace.setZpusobValidace(ZpusobValidace.BEZNY);
                if ("K".equalsIgnoreCase(typ)) {
                    fiktivniPoleIndexace.setLuceneTokenizer(LuceneTokenizerEnum.KEYWORD);
                }
                virtualniPoleIndexaceTemp.add(fiktivniPoleIndexace);
            }
            catch (Exception e) {
                logger.error("P: parsovani INI HLED_PODPOLE " + klic, (Throwable)e);
            }
        }
        virtualniPoleIndexace = virtualniPoleIndexaceTemp;
    }

    @Deprecated
    public static List<Styly> najdiStylyProPole(short idStyl, short cisloPole) {
        List styly = (List)stylyCompleteMap.get(idStyl);
        ArrayList<Styly> stylyProPole = new ArrayList<Styly>();
        for (Styly styl : styly) {
            if (styl.getCIS_POL() != cisloPole) continue;
            stylyProPole.add(styl);
        }
        return stylyProPole;
    }

    public static String najdiPodpoleVAutorite(int fond, short number, String prefix, int fondAuthority) throws SQLException {
        String mapKey = number + "#" + prefix;
        if (DbCache2.jeAutFond((short)((short)fond))) {
            FDefAut fDefAut = (FDefAut)((Map)DbCache2NG.fdefSourceAutMap().get()).get(mapKey);
            if (fDefAut != null) {
                return fDefAut.PODPEXT;
            }
        } else {
            FDef fDef = (FDef)((Map)DbCache2NG.fdefSourceMap().get()).get(mapKey);
            if (fDef != null) {
                return fDef.PODPEXT;
            }
        }
        return null;
    }

    public static void cacheVsbExternProperties() {
        File definice = new File(KPWINServiceApplication.externDir + File.separator + "vsb_extern.properties");
        if (definice.exists()) {
            logger.info("nacitam konfiguracni soubor pro extern/VSB: " + definice);
            vsbExternConfig = ConfigurationUtils.createReloadableFileConfiguration((File)definice, (boolean)false);
        } else {
            vsbExternConfig = new PropertiesConfiguration();
        }
    }

    public static void cacheNarArchProperties() {
        File definice = new File(KPWINServiceApplication.externDir + File.separator + "nararch.properties");
        if (definice.exists()) {
            logger.info("nacitam konfiguracni soubor pro narodni archiv: " + definice);
            narArchExternConfig = ConfigurationUtils.createReloadableFileConfiguration((File)definice, (boolean)false);
        } else {
            narArchExternConfig = new PropertiesConfiguration();
        }
    }

    public static void cacheTulDpProperties() {
        File definice = new File(KPWINServiceApplication.externDir + File.separator + "tul_dp.properties");
        if (definice.exists()) {
            logger.info("nacitam konfiguracni soubor pro TUL / diplomove prace");
            tulDPConfig = ConfigurationUtils.createReloadableFileConfiguration((File)definice, (boolean)false);
        } else {
            tulDPConfig = new PropertiesConfiguration();
        }
    }

    public static List<Integer> najdiLokaceKPujcovne(short pujcovnaId) {
        ArrayList<Integer> lokaceList = new ArrayList<Integer>();
        for (DefPujcLok pujcLok : defPujcLok) {
            if (pujcovnaId != pujcLok.getFK_PUJC()) continue;
            lokaceList.add(pujcLok.getFK_LOKACE());
        }
        return lokaceList;
    }

    public static List<Integer> keysToListOfInts(String valuesSeparated) {
        ArrayList<Integer> seznam = new ArrayList<Integer>();
        if (StringUtils.isNotBlank((CharSequence)valuesSeparated)) {
            StringTokenizer st = new StringTokenizer(valuesSeparated, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int i = Integer.parseInt(token);
                    seznam.add(i);
                }
                catch (NumberFormatException nfe) {
                    logger.warn("P:parsovani cisla " + token, (Throwable)nfe);
                }
            }
        }
        return seznam;
    }

    public static DefPujc prvniPujcovnaNaBudove(short idPujc) {
        for (DefPujc pujcovna : (Set)DbCache2NG.pujcovnyList().get()) {
            if (pujcovna.getID_PUJC() != idPujc) continue;
            return pujcovna;
        }
        return null;
    }

    public static DefPujc prvniPujcovnaNaHlavniBudove() {
        return pujcovnaUK;
    }

    public static String siglaBudovyNeboHlavniBudovy(Short idPujcovna) {
        DefPujc pujcovna = (DefPujc)((scala.collection.immutable.Map)DbCache2NG.pujcovnyMap().get()).apply((Object)idPujcovna);
        String sigla = null;
        if (pujcovna != null && StringUtils.isNotBlank((CharSequence)(sigla = pujcovna.getSIGLA()))) {
            return sigla;
        }
        pujcovna = pujcovnaUK;
        if (pujcovna != null && StringUtils.isNotBlank((CharSequence)(sigla = pujcovna.getSIGLA()))) {
            return sigla;
        }
        return null;
    }

    public static List<String> najdiLokalizace(String klic, String kodVal) {
        Lokalizace lokalizace = (Lokalizace)((Map)DbCache2NG.lokalizaceMap().get()).get("DEF_VAL.POPIS." + kodVal.substring(3) + "." + klic);
        if (lokalizace == null) {
            return new ArrayList<String>(10);
        }
        return lokalizace.vsechnyPlatneCiziLokalizace();
    }

    public static short stylProFond(short fkFond) {
        return ((DefFond)defFondMap.get(fkFond)).getFK_STYL();
    }

    static {
        slovnikyMap = new HashMap();
        mapaPoradiPodpoli910 = Collections.synchronizedMap(new HashMap());
        notInitCache = false;
        seznamDokFond = "0";
        seznamAutFond = "0";
        cacheHeated = false;
    }
}

