/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.as.config.SettingKeys;
import cz.kpsys.common.Licensing;
import cz.kpsys.common.LockOnKeySystem;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.BigDecimalHandler;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ExternVypucExecutorScala;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.NumberHandler;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.extern.loan.ExternalLoanLoanCategoryResolver;
import cz.kpsys.db.extern.loan.ExternalLoanValueResolver;
import cz.kpsys.db.model.ExternVypucInput;
import cz.kpsys.db.model.ExternVypucOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenKat;
import cz.kpsys.db.model.v2.DefCtenVyp;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.ExterniZdroje;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Vypuc2;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.services.extzdroje.EBooksUtils;
import cz.kpsys.kpwin2.services.extzdroje.FlexiBooksPujcUtils;
import cz.kpsys.kpwin2.tridy.extvyppopl_3.ExternVypucPlatba;
import cz.kpsys.kpwin2.tridy.extvyppopl_3.GeneratorPoplExternVypucFlexiBooks;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.OkHttpClientFactory;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.math.BigDecimal;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExternVypucExecutor
extends GenericExecutor {
    private static final int ERR11_PREKROCEN_KNIHOVNI_LIMIT = 11;
    private static final int ERR10_DUPLICITNI_VYPUJCKA = 10;
    private static final int ERR9_CTENAR_BLOKOVAN = 9;
    private static final int ERR8_PREKROCEN_POCET_VYPUJCEK = 8;
    private static final int ERR7_CTEN_VYPKAT_ZAKAZUJE_PUJCOVAT = 7;
    private static final int ERR6_NEZADANA_NEPLATNA_VYPKAT = 6;
    private static final int ERR5_PROBLEM_ZAPIS_VYPUJCKY = 5;
    private static final int ERR4_NEPLATNY_CAS = 4;
    private static final int ERR3_NEVALIDNI_EMAIL = 3;
    private static final int ERR2_NEPODPOROVANY_EXTERNI_ZDROJ = 2;
    private static final int ERR1_NEPLATNY_VSTUP = 1;
    private static final Logger logger = LoggerFactory.getLogger(ExternVypucExecutor.class);
    final ExternVypucInput input;
    private ExternVypucOutput output;
    private Kat1_4 kat1_4;
    private DefVypKat vypKat;
    private Ctenari ctenar;
    private final ByIdLoadable<Department, Integer> departmentLoader = (ByIdLoadable)KPWINServiceApplication.applicationContext.getBean("departmentLoader", ByIdLoadable.class);
    private final ExternalLoanLoanCategoryResolver externalLoanLoanCategoryResolver = (ExternalLoanLoanCategoryResolver)KPWINServiceApplication.applicationContext.getBean(ExternalLoanLoanCategoryResolver.class);
    private final ExternalLoanValueResolver<@NonNull java.math.BigDecimal> externalLoanPriceLimitResolver = (ExternalLoanValueResolver)KPWINServiceApplication.applicationContext.getBean("externalLoanPriceLimitResolver", ExternalLoanValueResolver.class);
    private final SettingLoader settingLoader = (SettingLoader)KPWINServiceApplication.applicationContext.getBean(SettingLoader.class);
    private final ContextualProvider<Department, @NonNull Boolean> extLoansDebtsCheckingProvider = this.settingLoader.getDepartmentedProvider(SettingKeys.EXT_LOANS_CHECK_DEBTS);
    private final ContextualProvider<Department, @NonNull Boolean> extLoansOverdueNoticesCheckingProvider = this.settingLoader.getDepartmentedProvider(SettingKeys.EXT_LOANS_CHECK_OVERDUE_NOTICES);
    private final ContextualProvider<Department, String> extLoansPoplCtenScriptProvider = this.settingLoader.getDepartmentedProvider(SettingKeys.EXT_LOANS_POPL_CTEN_SCRIPT);
    private static final LockOnKeySystem<Integer> uzivLockingSystem = new LockOnKeySystem("extern_vypuc_uziv_lock", 100, 30);

    public ExternVypucExecutor(DbCore2 core2, ExternVypucInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static ExternVypucInput parseExternVypucInput(Document doc, DbCore2 core2) throws ParseException, SQLException {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/extern_vypuc/";
        ExternVypucInput externVypucInput = new ExternVypucInput();
        externVypucInput.idExterniZdroje = Integer.parseInt(ExternVypucExecutor.parseTag((Document)doc, (String)"//collection/extern_vypuc/ID_EXTERNI_ZDROJE", (String)"0"));
        externVypucInput.fkUzivCten = ExternVypucExecutor.parseCtenTag((Document)doc, (String)"//collection/extern_vypuc/ID_CTEN", (boolean)false);
        externVypucInput.pujcovna = Short.parseShort(ExternVypucExecutor.parseTag((Document)doc, (String)"//collection/extern_vypuc/PUJCOVNA", (String)((Short)DbCache.rootPujcovna().get()).toString()));
        externVypucInput.vypKat = ExternVypucExecutor.parseTag((Document)doc, (String)"//collection/extern_vypuc/VYP_KAT", null);
        return externVypucInput;
    }

    void kontrolaValidityVstupu() throws AppServerStatus {
        if (this.input.fkUzivCten == 0) {
            throw new AppServerStatus("ID_CTEN nezadan / nulovy", 1);
        }
        if (this.input.idExterniZdroje == 0) {
            throw new AppServerStatus("ID_EXTERNI_ZDROJE nezadan / nulovy", 1);
        }
    }

    public ExternVypucOutput externVypuc() throws AppServerStatus, SQLException {
        this.qr = this.core2.obtainQueryRunnerOpened();
        this.kontrolaValidityVstupu();
        Department currentDepartment = (Department)this.departmentLoader.getById((Object)this.input.pujcovna);
        ExterniZdroje zdroj = this.nactiUdaje(currentDepartment);
        uzivLockingSystem.lockProtect((Object)this.input.getFkUzivCten(), (Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.output;
    }

    public ExterniZdroje nactiUdaje(Department currentDepartment) throws SQLException, AppServerStatus {
        boolean ctenarMaUpominky;
        boolean ctenarDluzi;
        ExterniZdroje zdroj = this.nactiExterniZdroj();
        if (zdroj == null) {
            throw new AppServerStatus("zadany ID_EXTERNI_ZDROJE neexistuje " + this.input.idExterniZdroje, 1);
        }
        if (StringUtils.isBlank((CharSequence)this.input.getVypKat())) {
            Optional resolvedVypKat = this.externalLoanLoanCategoryResolver.resolve(EBooksUtils.EBooksProvider.valueOf((String)zdroj.getZDROJ()), currentDepartment);
            resolvedVypKat.ifPresent(defVypKat -> this.input.setVypKat(defVypKat.getID_VYPKAT()));
        }
        if (StringUtils.isBlank((CharSequence)this.input.getVypKat()) || (this.vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(this.input.vypKat)) == null) {
            throw new AppServerStatus("nezadana / neplatna VYPKAT", 6);
        }
        this.kat1_4 = this.core2.nactiKat1_4(zdroj.getFK_ZAZ());
        if (this.vypKat == null) {
            throw new AppServerStatus("zadana VYP_KAT je neplatna", 1);
        }
        this.ctenar = (Ctenari)this.qr.query("SELECT * FROM CTENARI WHERE FK_UZIV=?", (ResultSetHandler)BeanHandlers.ctenariHandler(), new Object[]{this.input.fkUzivCten});
        if (this.ctenar == null) {
            throw new AppServerStatus("zadany ctenar neexistuje", 1);
        }
        if (this.ctenar.isSMAZANYBLOKOVANY()) {
            throw new AppServerStatus("ctenar blokovan / smazany", 9);
        }
        if (this.ctenar.maProslouRegistraci()) {
            throw new AppServerStatus("ctenar ma proslou registraci", 9);
        }
        if (!this.ctenar.isJE_REGISTROVANY()) {
            throw new AppServerStatus("ctenar nema dokoncenou rezervaci", 9);
        }
        if (((Boolean)this.extLoansDebtsCheckingProvider.getOn((Object)currentDepartment)).booleanValue() && (ctenarDluzi = GenericExecutorScala.ctenarDluzi((int)this.ctenar.getFK_UZIV(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened()))) {
            throw new AppServerStatus("ctenar dluzi", 9);
        }
        if (((Boolean)this.extLoansOverdueNoticesCheckingProvider.getOn((Object)currentDepartment)).booleanValue() && (ctenarMaUpominky = GenericExecutorScala.ctenarMaUpominky((int)this.ctenar.getFK_UZIV(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened()))) {
            throw new AppServerStatus("ctenar ma upominky", 9);
        }
        this.ctenKat = (DefCtenKat)((Map)DbCache2NG.ctenKatMap().get()).get(this.ctenar.getFK_CTENKAT());
        return zdroj;
    }

    private void kontrolaValidityEmailuCtenare() throws AppServerStatus {
        String email = ExternVypucExecutorScala.kontrolaValidityEmailuCtenare((int)this.ctenar.getFK_UZIV());
        if (StringUtils.isBlank((CharSequence)email) || !email.contains("@")) {
            throw new AppServerStatus("ctenar nema nastavenou validni emailovou adresu ", 3);
        }
    }

    private ExternVypucOutput vypujckaEReading(ExterniZdroje zdroj, Department currentDepartment) throws AppServerStatus, SQLException {
        ExternVypucOutput output = new ExternVypucOutput();
        this.kontrolaValidityEmailuCtenare();
        this.kontrolaCasu();
        this.kontrolaDuplicity(zdroj);
        this.zapisVypujcku(zdroj, true, null);
        long timeStamp = System.currentTimeMillis() / 1000L;
        String url = EBooksUtils.generujURL((String)ExternVypucExecutorScala.hlavniEmailCtenare((int)this.ctenar.getFK_UZIV()), (int)1, (long)Long.parseLong(zdroj.getZAZNAM_ID()), (long)timeStamp, (short)((Integer)currentDepartment.getId()).shortValue());
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(url);
            httpGet.addHeader("X-Library-Client", (Object)"KPSYS Verbis AS");
            boolean testovaciRezim = this.testovaciRezimPujcovani();
            if (testovaciRezim) {
                logger.warn("zapnut testovaci rezim, vypujcka u eReading nerealizovana");
                long idVypuc = this.zapisVypujcku(zdroj, false, null);
                output.setIdVypuc(idVypuc);
            } else {
                String response = (String)httpclient.execute((ClassicHttpRequest)httpGet, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
                logger.info("zaznamenana odpoved od poskytovatele " + zdroj.getZDROJ() + "\n" + response);
                if (this.vypujckaProbehlaERD(response)) {
                    long idVypuc = this.zapisVypujcku(zdroj, false, null);
                    output.setIdVypuc(idVypuc);
                }
            }
        }
        catch (IOException e) {
            logger.error("selhani", (Throwable)e);
        }
        return output;
    }

    private boolean testovaciRezimPujcovani() {
        return KPWINServiceApplication.internalBuild() || !Configuration.extZdrojePujc;
    }

    private ExternVypucOutput vypujckaFlexibooks(ExterniZdroje zdroj, Department currentDepartment) throws AppServerStatus, SQLException {
        ExternVypucOutput output;
        block10: {
            java.math.BigDecimal cenaVypujckyProCtenare;
            ExternVypucPlatba platba;
            String poplCtenKlic;
            output = new ExternVypucOutput();
            this.kontrolaValidityEmailuCtenare();
            this.kontrolaCasu();
            this.kontrolaDuplicity(zdroj);
            GeneratorPoplExternVypucFlexiBooks generator = null;
            if (Licensing.isMZLU() && StringUtils.isNotBlank((CharSequence)(poplCtenKlic = (String)this.extLoansPoplCtenScriptProvider.getOn((Object)currentDepartment))) && poplCtenKlic.matches("GeneratorPoplExternVypucFlexiBooks(.*)")) {
                try {
                    int procent = Integer.parseInt(poplCtenKlic.substring(poplCtenKlic.indexOf("(") + 1, poplCtenKlic.indexOf(")")));
                    generator = new GeneratorPoplExternVypucFlexiBooks(procent);
                }
                catch (Exception e) {
                    logger.warn("parsovani castky funkce GeneratorPoplExternVypucFlexiBooks" + poplCtenKlic, (Throwable)e);
                }
            }
            if (generator != null) {
                platba = generator.generuj(zdroj, this.ctenar);
                logger.info("napocitana cena vypujcky " + platba);
                cenaVypujckyProCtenare = platba.platiCtenar().bigDecimal();
            } else {
                cenaVypujckyProCtenare = java.math.BigDecimal.ZERO;
                platba = ExternVypucPlatba.apply((BigDecimal)BigDecimal.javaBigDecimal2bigDecimal((java.math.BigDecimal)zdroj.getCENA_PUJC()), (BigDecimal)BigDecimal.javaBigDecimal2bigDecimal((java.math.BigDecimal)java.math.BigDecimal.ZERO));
            }
            this.zapisVypujcku(zdroj, true, cenaVypujckyProCtenare);
            EBooksUtils.EBooksProvider provider = zdroj.detekujProvidera();
            FlexiBooksPujcUtils flexiBooksPujcUtils = new FlexiBooksPujcUtils(provider);
            boolean aktivni = flexiBooksPujcUtils.jeFlexibooksLIKEAktivni(currentDepartment);
            if (!aktivni) {
                throw new AppServerStatus("problem v konfiguraci flexibooks, nelze pujcovat", 5);
            }
            this.kontrolaPrekroceniLimitniCastky(platba, provider, currentDepartment);
            boolean testovaciRezim = this.testovaciRezimPujcovani();
            String pujcUrl = flexiBooksPujcUtils.vytvorPujcUrl(currentDepartment, ExternVypucExecutorScala.hlavniEmailCtenare((int)this.ctenar.getFK_UZIV()), 1, zdroj.getZAZNAM_ID(), testovaciRezim);
            logger.info("pujc flexibooksLIKE url: " + pujcUrl);
            try {
                if (testovaciRezim) {
                    logger.warn("zapnut testovaci rezim, vypujcka u flexibooks nerealizovana");
                    long idVypuc = this.zapisVypujcku(zdroj, false, cenaVypujckyProCtenare);
                    ExternVypucExecutorScala.zpracujZapisPoplatek((EBooksUtils.EBooksProvider)provider, (long)idVypuc, (int)this.input.fkUzivCten, (ExterniZdroje)zdroj, (short)this.input.pujcovna, (java.math.BigDecimal)cenaVypujckyProCtenare, (DbCore2)this.core2);
                    output.setIdVypuc(idVypuc);
                    break block10;
                }
                OkHttpClient httpclient = OkHttpClientFactory.trustAllSslClient((OkHttpClient)new OkHttpClient());
                Request httpGetRequest = new Request.Builder().url(pujcUrl).addHeader("Connection", "close").addHeader("X-Library-Client", "KPSYS Verbis AS HTTP client").build();
                Response httpResponse = httpclient.newCall(httpGetRequest).execute();
                int responseCode = httpResponse.code();
                String response = httpResponse.body().string();
                httpResponse.close();
                logger.info("zaznamenana odpoved od poskytovatele " + zdroj.getZDROJ() + "\n" + response);
                if (responseCode == 200 && this.vypujckaProbehlaFLB(response)) {
                    long idVypuc = this.zapisVypujcku(zdroj, false, cenaVypujckyProCtenare);
                    ExternVypucExecutorScala.zpracujZapisPoplatek((EBooksUtils.EBooksProvider)provider, (long)idVypuc, (int)this.input.fkUzivCten, (ExterniZdroje)zdroj, (short)this.input.pujcovna, (java.math.BigDecimal)cenaVypujckyProCtenare, (DbCore2)this.core2);
                    output.setIdVypuc(idVypuc);
                    break block10;
                }
                throw new AppServerStatus("P: komunikace - kod: " + responseCode + " odpoved: " + response, 12);
            }
            catch (IOException e) {
                logger.error("selhani externiho pujcovani", (Throwable)e);
            }
        }
        return output;
    }

    private void kontrolaPrekroceniLimitniCastky(ExternVypucPlatba platba, EBooksUtils.EBooksProvider provider, Department currentDepartment) throws AppServerStatus, SQLException {
        @NonNull java.math.BigDecimal limitniCastka = (java.math.BigDecimal)this.externalLoanPriceLimitResolver.resolve(provider, currentDepartment).orElseThrow(IllegalArgumentException::new);
        if (limitniCastka.compareTo(java.math.BigDecimal.ZERO) == 0) {
            return;
        }
        java.math.BigDecimal cenaVypujckyKnihovna = platba.platiKnihovna().bigDecimal();
        java.math.BigDecimal cenaVypujckyCtenar = platba.platiCtenar().bigDecimal();
        java.math.BigDecimal castkaSoucet = this.soucetEVypujcekTentoMesic(provider);
        java.math.BigDecimal castkaPoPujceni = castkaSoucet.add(cenaVypujckyKnihovna);
        if (castkaPoPujceni.compareTo(limitniCastka) > 0) {
            throw new AppServerStatus("nelze pujcit, byla by prekrocena vyhrazena castka pro e-Vypujcky, doposud vycerpano " + castkaSoucet + " cena vypujcky pro knihovnu (ctenare): " + cenaVypujckyKnihovna + " (" + cenaVypujckyCtenar + ")", 11);
        }
    }

    private java.math.BigDecimal soucetEVypujcekTentoMesic(EBooksUtils.EBooksProvider provider) throws SQLException {
        LocalDate ldPrvniDen = YearMonth.now().atDay(1);
        LocalDate ldPrvniDenDalsiMesic = ldPrvniDen.plusMonths(1L);
        Date prvniDen = DateConversions.localDate2utilDate((LocalDate)ldPrvniDen);
        Date prvniDenDalsiMesic = DateConversions.localDate2utilDate((LocalDate)ldPrvniDenDalsiMesic);
        String providerId = provider.name();
        java.math.BigDecimal celkemCastkaZaVypujcky = (java.math.BigDecimal)this.qr.query("SELECT SUM(CENA) FROM VYPUC WHERE CIS_REZE=0 AND FK_TYPPUJC=3 AND DAT_VYP>=? AND DAT_VYP<? AND OZNAC LIKE '" + providerId + ":%'", (ResultSetHandler)new BigDecimalHandler(), new Object[]{Utils.util2sqlDate((Date)prvniDen), Utils.util2sqlDate((Date)prvniDenDalsiMesic)});
        java.math.BigDecimal castkaNauctovanaCtenarum = (java.math.BigDecimal)this.qr.query("SELECT SUM(CASTKA) FROM PLATBY WHERE FK_VYPUC IN (SELECT FK_VYPUC FROM VYPUC WHERE CIS_REZE=0 AND FK_TYPPUJC=3 AND DAT_VYP>=? AND DAT_VYP<? AND OZNAC LIKE '" + providerId + ":%') AND CASTKA<0", (ResultSetHandler)new BigDecimalHandler(), new Object[]{Utils.util2sqlDate((Date)prvniDen), Utils.util2sqlDate((Date)prvniDenDalsiMesic)});
        return celkemCastkaZaVypujcky.add(castkaNauctovanaCtenarum);
    }

    private void kontrolaDuplicity(ExterniZdroje zdroj) throws SQLException, AppServerStatus {
        int count = ((Number)this.qr.query("SELECT COUNT(*) FROM VYPUC WHERE FK_UZIV_CTEN=? AND FK_ZAZ=? AND CIS_REZE=0 AND FK_TYPPUJC=3", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{this.input.fkUzivCten, zdroj.getFK_ZAZ()})).intValue();
        if (count > 0) {
            throw new AppServerStatus("ctenar ma jiz titul e-vypujcen", 10);
        }
    }

    private long zapisVypujcku(ExterniZdroje zdroj, boolean zkusebne, java.math.BigDecimal cena) throws AppServerStatus, SQLException {
        int aktualnePujceno;
        DefCtenVyp ctenVypKat = GenericExecutor.nactiKombinaciCtenKatVypKat((DefCtenKat)this.ctenKat, (DefVypKat)this.vypKat);
        if (ctenVypKat == null) {
            throw new AppServerStatus("nepodarilo se najit kombinaci ctenvypkat - CTENKAT: " + this.ctenKat.getID_CTENKAT() + " VYPKAT: " + this.vypKat.getID_VYPKAT(), 6);
        }
        if (!ctenVypKat.isJE_PUJC()) {
            throw new AppServerStatus("kombinace ctenvypkat ma zakazano pujcovat", 7);
        }
        if (ctenVypKat.getMAX_VYP() > 0 && (aktualnePujceno = ((Number)this.qr.query("SELECT COUNT(*) FROM VYPUC WHERE FK_UZIV_CTEN=? AND FK_VYPKAT=? AND FK_TYPPUJC=?", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{this.input.fkUzivCten, this.vypKat.getID_VYPKAT(), 3})).intValue()) >= ctenVypKat.getMAX_VYP()) {
            throw new AppServerStatus("prekrocen max. povoleny pocet vypujcek", 8);
        }
        if (!zkusebne) {
            Vypuc2 vypuc2 = new Vypuc2();
            vypuc2.setCIS_REZE(Short.valueOf((short)0));
            vypuc2.setDAT_VYP(Utils.now());
            vypuc2.setDAT_PROL(Utils.now());
            vypuc2.setDOB_VYP(ctenVypKat.getDOBA_VYP());
            vypuc2.setFK_UZIV_CTEN(Integer.valueOf(this.input.fkUzivCten));
            vypuc2.setFK_TYPPUJC((short)3);
            vypuc2.setFK_VYPKAT(this.vypKat.getID_VYPKAT());
            vypuc2.setRECORD_ID(RecordIdCache.fkZaz2recIdDoc((long)zdroj.getFK_ZAZ()));
            vypuc2.setOZNAC(zdroj.getZDROJ() + ":" + zdroj.getID_EXTERNI_ZDROJE());
            vypuc2.setFK_PUJC(Short.valueOf(this.input.pujcovna));
            if (zdroj.getCENA_PUJC() != null) {
                vypuc2.setCENA(zdroj.getCENA_PUJC());
            }
            try {
                long idVypuc = GenericExecutor.insertIntoVypuc2((QueryRunner)this.qr, (Vypuc2)vypuc2, (short)this.input.pujcovna);
                return idVypuc;
            }
            catch (SQLException se) {
                logger.error("problem pri zapisu externi vypujcky", (Throwable)se);
                throw new AppServerStatus("problem pri zapisu externi vypujcky", 5);
            }
        }
        return 0L;
    }

    private boolean vypujckaProbehlaERD(String response) {
        return response != null && response.contains("Loan assigned");
    }

    private boolean vypujckaProbehlaFLB(String response) {
        return response != null && response.contains("<state>OK</state>");
    }

    private void kontrolaCasu() throws AppServerStatus {
        logger.info("kontrola systemoveho casu dle ntp.nic.cz");
        logger.warn("kontrola docasne vypnuta");
    }

    private ExterniZdroje nactiExterniZdroj() throws SQLException {
        ExterniZdroje zdroje = (ExterniZdroje)this.qr.query("SELECT * FROM EXTERNI_ZDROJE WHERE ID_EXTERNI_ZDROJE=?", (ResultSetHandler)BeanHandlers.externiZdrojeHandler(), new Object[]{this.input.idExterniZdroje});
        return zdroje;
    }
}

