/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.db.Kat1_1Pair;
import cz.kpsys.db.Ukazatel;
import cz.kpsys.db.model.v2.Kat1_1;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;

class FirebirdDbSmart {
    private ArrayList<Kat1_1> toInsert;
    private ArrayList<Kat1_1> toDelete;
    private ArrayList<Kat1_1Pair> toUpdate;
    private QueryRunner qr;

    FirebirdDbSmart() {
    }

    public void vypisSeznamKat1_1(List<Kat1_1> seznam) {
        for (Kat1_1 elem : seznam) {
            System.out.println(elem.toString());
        }
    }

    public void zapisZmenyDoKat1_1(long zaznId, List<Kat1_1> kat1_1Orig, List<Kat1_1> kat1_1, QueryRunner qr) throws SQLException {
        this.qr = qr;
        this.toInsert = new ArrayList();
        this.toDelete = new ArrayList();
        this.toUpdate = new ArrayList();
        Ukazatel ukazatelPuvodni = new Ukazatel();
        Ukazatel ukazatelNovy = new Ukazatel();
        int indexPuvodni = 0;
        int indexNovy = 0;
        int puvodniSize = kat1_1Orig.size();
        int novySize = kat1_1.size();
        Kat1_1 puvodni = null;
        Kat1_1 novy = null;
        if (puvodniSize == 0) {
            this.toInsert.addAll(kat1_1);
        } else {
            while (indexPuvodni < puvodniSize || indexNovy < novySize) {
                if (indexPuvodni < puvodniSize) {
                    puvodni = kat1_1Orig.get(indexPuvodni);
                    ukazatelPuvodni.setPole(puvodni);
                }
                if (indexNovy < novySize) {
                    novy = kat1_1.get(indexNovy);
                    ukazatelNovy.setPole(novy);
                }
                if (indexNovy == novySize) {
                    this.toDelete.add(puvodni);
                    ++indexPuvodni;
                    continue;
                }
                if (indexPuvodni == puvodniSize) {
                    this.toInsert.add(novy);
                    ++indexNovy;
                    continue;
                }
                if (ukazatelPuvodni.compare(ukazatelNovy) < 0) {
                    this.toDelete.add(puvodni);
                    ++indexPuvodni;
                    continue;
                }
                if (ukazatelPuvodni.compare(ukazatelNovy) > 0) {
                    this.toInsert.add(novy);
                    ++indexNovy;
                    continue;
                }
                if (!puvodni.equalsIgnoreDatCas((Object)novy)) {
                    this.toUpdate.add(new Kat1_1Pair(puvodni, novy));
                }
                ++indexNovy;
                ++indexPuvodni;
            }
        }
        this.provedDelete();
        this.provedUpdate();
        this.provedInsert();
    }

    private void provedInsert() throws SQLException {
        for (Kat1_1 kat1_1 : this.toInsert) {
            this.qr.update("INSERT INTO KAT1_1 (FK_ZAZ, CIS_POL, PORADI_POLE, INDIK, OBSAH) VALUES (?,?,?,?,?)", new Object[]{kat1_1.FK_ZAZ, kat1_1.CIS_POL, kat1_1.PORADI_POLE, kat1_1.INDIK, kat1_1.OBSAH});
        }
    }

    private void provedDelete() throws SQLException {
        if (this.toDelete.size() == 0) {
            return;
        }
        long fkZaz = ((Kat1_1)this.toDelete.get(0)).getFK_ZAZ();
        StringBuilder sb = new StringBuilder(512);
        sb.append("DELETE FROM KAT1_1 WHERE FK_ZAZ=? AND (");
        boolean first = true;
        for (Kat1_1 kat1_1 : this.toDelete) {
            if (!first) {
                sb.append(" OR ");
            } else {
                first = false;
            }
            sb.append("(CIS_POL=" + kat1_1.CIS_POL + " AND PORADI_POLE=" + kat1_1.PORADI_POLE + ")");
        }
        sb.append(")");
        String sql = sb.toString();
        this.qr.update(sql, (Object)fkZaz);
    }

    private void provedUpdate() throws SQLException {
        for (Kat1_1Pair pair : this.toUpdate) {
            this.qr.update("UPDATE KAT1_1 SET FK_ZAZ=?, CIS_POL=?, PORADI_POLE=?, INDIK=?, OBSAH=? WHERE FK_ZAZ=? AND CIS_POL=? AND PORADI_POLE=?", new Object[]{pair.novy.FK_ZAZ, pair.novy.CIS_POL, pair.novy.PORADI_POLE, pair.novy.INDIK, pair.novy.OBSAH, pair.puvodni.FK_ZAZ, pair.puvodni.CIS_POL, pair.puvodni.PORADI_POLE});
        }
    }
}

