/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenUpomExecutor;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.NumberHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.RecordReconstructor2NazvyAndKey;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.GenUpomInput;
import cz.kpsys.db.model.GenUpomOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenKat;
import cz.kpsys.db.model.v2.DefCtenVyp;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Platby;
import cz.kpsys.db.model.v2.Upominky;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.db.model.v2.ZpravyCten;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.service.Utils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenUpomExecutor
extends GenericExecutor {
    public static final String TYPUPOMPOPL_UZIVATELSKA = "UZIVATELSKA";
    public static final String TYPUPOMPOPL_DLEUPOM = "DLEUPOM";
    public static final String TYPUPOMPOPL_DLEEXEMP = "DLEEXEMP";
    public static final String TYPUPOMPOPL_NEJPOPL = "NEJPOPL";
    public static final short POPLATEK_UPOMINKA = 3;
    private static final Logger logger = LoggerFactory.getLogger(GenUpomExecutor.class);
    private final SimpleDateFormat servisDateFormat = new SimpleDateFormat("yyyyMMdd");
    private final GenUpomInput input;
    private final List<Vypuc> seznamVypuc = new LinkedList();
    private final List<UpominkyVypuc> seznamGenerovanychUpominek = new ArrayList();
    private final List<Platby> pokuty = new LinkedList();
    private final Map<Upominky, Platby> mapaUpomPlatby = new HashMap();
    private String zpusUpom;
    private GenUpomOutput output;
    private boolean upominkyNerozlisovatPujcovnu;

    public GenUpomExecutor(DbCore2 core2, GenUpomInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static String zjistiTypUpomPopl(short idPujc) {
        String zpusUpom = DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.KATALOGIZACE_TYPUPOMPOPL(), (Short)idPujc, null);
        if (zpusUpom == null) {
            zpusUpom = "NEJPOPL";
        }
        return zpusUpom;
    }

    public static GenUpomInput parseGenUpomInput(Document doc, short pujcovnaSystem, int fkUziv) throws AppServerStatus {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/gen_upom/";
        GenUpomInput genUpomInput = new GenUpomInput();
        genUpomInput.idCten = GenUpomExecutor.parseCtenTag((Document)doc, (String)"//collection/gen_upom/ID_CTEN", (boolean)false);
        genUpomInput.fkUziv = fkUziv;
        if ((long)genUpomInput.idCten == 0L) {
            throw new AppServerStatus("chybny vstup, ID_CTEN==0", 404);
        }
        String datumString = null;
        try {
            datumString = GenUpomExecutor.parseTag((Document)doc, (String)"//collection/gen_upom/DATUM_GEN", (String)"");
            genUpomInput.datumGen = Utils.sdfSQLDate().parse(datumString);
        }
        catch (ParseException e) {
            logger.error("ParseException", (Throwable)e);
            e.printStackTrace();
            throw new AppServerStatus("datum zadan v nespravnem tvaru: " + datumString, 106);
        }
        genUpomInput.idPujc = Short.parseShort(GenUpomExecutor.parseTag((Document)doc, (String)"//collection/gen_upom/ID_PUJC", (String)"0"));
        genUpomInput.idBudova = Short.parseShort(GenUpomExecutor.parseTag((Document)doc, (String)"//collection/gen_upom/ID_BUDOVA", (String)"0"));
        genUpomInput.over = GenUpomExecutor.parseBooleanTag((Document)doc, (String)"//collection/gen_upom/OVER", (boolean)false);
        return genUpomInput;
    }

    public static void vycistiPoleServis(QueryRunner qr, short cisloUpominky, short pujcovna, int fkUzivVlastnik, long idVypuc) throws SQLException {
        if (cisloUpominky == 0) {
            return;
        }
        String zpusUpom = GenUpomExecutor.zjistiTypUpomPopl((short)pujcovna);
        if (!"NEJPOPL".equals(zpusUpom) && !"DLEUPOM".equals(zpusUpom) && "DLEEXEMP".equals(zpusUpom)) {
            qr.update("UPDATE PLATBY SET SERVIS=NULL WHERE FK_UZIV_VLASTNIK=? AND FK_POPL=? AND SERVIS=?", new Object[]{fkUzivVlastnik, (short)3, Long.toString(idVypuc)});
        }
    }

    private void zpracujVypujcky(Ctenari ctenar) throws SQLException {
        Platby platba;
        for (Vypuc vypuc : this.seznamVypuc) {
            DefCtenVyp ctenVyp;
            DefVypKat vypkat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(vypuc.getFK_VYPKAT());
            if (!vypkat.jeUpom() || (ctenVyp = GenUpomExecutor.nactiKombinaciCtenKatVypKat((DefCtenKat)this.ctenKat, (DefVypKat)this.nactiVypKat(vypuc.getFK_VYPKAT()))) == null) continue;
            short noveCisloUpominky = this.zjistiCisloUpominky(vypuc, ctenVyp);
            boolean exists = false;
            if (noveCisloUpominky <= vypuc.getCIS_UPOM()) {
                logger.error("POZOR!!! pokus o generovani upominky s nizsim cislem, chybny stav VYPUC.FK_VYPUC=" + vypuc.getFK_VYPUC());
                exists = true;
            }
            if (exists) continue;
            UpominkyVypuc upom = new UpominkyVypuc(this);
            upom.setCIS_UPOM(noveCisloUpominky);
            upom.setFK_VYPUC(vypuc.getFK_VYPUC());
            upom.setDAT_GEN(this.input.datumGen);
            upom.setPOKUTA_UPOM(ctenVyp.getPOPL(noveCisloUpominky));
            upom.setPOKUTA_UPOM_PUV(ctenVyp.getPOPL(vypuc.getCIS_UPOM()));
            upom.vypuc = vypuc;
            this.seznamGenerovanychUpominek.add(upom);
            ++this.output.pocUpom;
            if (!"UZIVATELSKA".equalsIgnoreCase(this.zpusUpom)) {
                platba = this.generujPlatbu(noveCisloUpominky, vypuc, ctenVyp);
                this.pokuty.add(platba);
                this.mapaUpomPlatby.put(upom, platba);
            }
            if (this.input.over) continue;
            this.qr.update("DELETE FROM UPOMINKY WHERE FK_VYPUC=?", (Object)vypuc.getFK_VYPUC());
            this.qr.update("UPDATE VYPUC2 SET CIS_UPOM=? WHERE ID_VYPUC=?", new Object[]{upom.getCIS_UPOM(), vypuc.getFK_VYPUC()});
            this.qr.update("INSERT INTO UPOMINKY (FK_VYPUC, CIS_UPOM, DAT_GEN, DAT_TISK) VALUES (?,?,?,?)", new Object[]{upom.getFK_VYPUC(), upom.getCIS_UPOM(), new Date(upom.getDAT_GEN().getTime()), upom.getDAT_TISK()});
            Kat1_4 kat1_4 = DbCore2Utils.nactiKat1_4((String)vypuc.getRECORD_ID(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            ZpravyCten zpravyCten = new ZpravyCten();
            zpravyCten.FK_UZIV_CTEN = ctenar.getFK_UZIV();
            zpravyCten.FK_UZIV = this.input.fkUziv;
            zpravyCten.TYP_ODESLANI = "A";
            zpravyCten.TEXT = StringUtils.left((String)RecordReconstructor2NazvyAndKey.limitToCP1250((String)(noveCisloUpominky + ". upominka na vypujcku titulu " + kat1_4.NAZEV)), (int)512);
        }
        if ("DLEEXEMP".equalsIgnoreCase(this.zpusUpom)) {
            for (Object upominka : this.seznamGenerovanychUpominek) {
                Platby platba2 = (Platby)this.mapaUpomPlatby.get(upominka);
                platba2.setCASTKA(this.spoctiRozdilUpominek((UpominkyVypuc)upominka));
                if (platba2.getCASTKA().compareTo(BigDecimal.ZERO) < 0) continue;
                this.zapisPlatbu(platba2);
            }
        } else if ("DLEUPOM".equalsIgnoreCase(this.zpusUpom)) {
            if (this.upominkyNerozlisovatPujcovnu) {
                Platby[] nejvyssiPlatby = new Platby[5];
                for (Upominky upominka : this.seznamGenerovanychUpominek) {
                    Platby platba3 = (Platby)this.mapaUpomPlatby.get(upominka);
                    idxUpom = upominka.getCIS_UPOM() - 1;
                    Platby nejvyssiPlatba = nejvyssiPlatby[idxUpom];
                    if (nejvyssiPlatba != null && nejvyssiPlatba.getCASTKA().compareTo(platba3.getCASTKA()) != -1) continue;
                    nejvyssiPlatby[idxUpom] = platba3;
                }
                for (int i = 0; i < 5; ++i) {
                    if (nejvyssiPlatby[i] == null) continue;
                    this.zapisPlatbu(nejvyssiPlatby[i]);
                }
            } else {
                nejvyssiPlatbyPujcovny = new HashMap<Short, Object>();
                for (Upominky upominka : this.seznamGenerovanychUpominek) {
                    fkPujc = upominka.vypuc.getFK_PUJC();
                    idxUpom = upominka.getCIS_UPOM() - 1;
                    Platby[] platbyPujcovna = nejvyssiPlatbyPujcovny.computeIfAbsent(fkPujc, k -> new Platby[5]);
                    Platby nejvyssiPlatba = platbyPujcovna[idxUpom];
                    platba = (Platby)this.mapaUpomPlatby.get(upominka);
                    if (nejvyssiPlatba != null && nejvyssiPlatba.getCASTKA().compareTo(platba.getCASTKA()) != -1) continue;
                    platbyPujcovna[idxUpom] = platba;
                }
                for (Platby[] platby : nejvyssiPlatbyPujcovny.values()) {
                    for (int i = 0; i < 5; ++i) {
                        if (platby[i] == null) continue;
                        this.zapisPlatbu(platby[i]);
                    }
                }
            }
        } else if ("NEJPOPL".equalsIgnoreCase(this.zpusUpom)) {
            if (this.upominkyNerozlisovatPujcovnu) {
                Platby platbaMax = null;
                for (Platby platba2 : this.mapaUpomPlatby.values()) {
                    if (platbaMax == null) {
                        platbaMax = platba2;
                        continue;
                    }
                    if (platbaMax.getCASTKA().compareTo(platba2.getCASTKA()) >= 0) continue;
                    platbaMax = platba2;
                }
                if (platbaMax != null && platbaMax.getCASTKA().intValue() != 0) {
                    double suma = ((Number)this.qr.query("select sum(CASTKA) from PLATBY where FK_UZIV_VLASTNIK = ? and FK_POPL = 3", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{this.input.idCten})).doubleValue();
                    if (!(suma >= 0.0)) {
                        BigDecimal novaCastka = platbaMax.getCASTKA().add(new BigDecimal(suma, new MathContext(2)));
                        platbaMax.setCASTKA(novaCastka);
                        logger.info("ctenar FK_UZIV=" + this.input.idCten + " ma aktualne dluh " + suma + " nova upominka je za " + platbaMax.getCASTKA().toPlainString() + " => bude pripocten dluh " + novaCastka.toPlainString());
                    }
                    this.zapisPlatbu(platbaMax);
                }
            } else {
                nejvyssiPlatbyPujcovny = new HashMap();
                for (Upominky upominka : this.seznamGenerovanychUpominek) {
                    fkPujc = upominka.vypuc.getFK_PUJC();
                    idxUpom = upominka.getCIS_UPOM() - 1;
                    Platby nejvyssiPlatba = (Platby)nejvyssiPlatbyPujcovny.get(fkPujc);
                    Platby platba4 = (Platby)this.mapaUpomPlatby.get(upominka);
                    if (nejvyssiPlatba != null && nejvyssiPlatba.getCASTKA().compareTo(platba4.getCASTKA()) != -1) continue;
                    nejvyssiPlatbyPujcovny.put(fkPujc, platba4);
                }
                for (Platby platbaMax : nejvyssiPlatbyPujcovny.values()) {
                    if (platbaMax.getCASTKA().intValue() == 0) continue;
                    double suma = this.zjistiDosudZaplacenouCastkuNejPopl(platbaMax);
                    if (!(suma >= 0.0)) {
                        BigDecimal novaCastka = platbaMax.getCASTKA().add(new BigDecimal(suma, new MathContext(2)));
                        platbaMax.setCASTKA(novaCastka);
                    }
                    this.zapisPlatbu(platbaMax);
                }
            }
        } else if ("UZIVATELSKA".equalsIgnoreCase(this.zpusUpom)) {
            if (this.seznamGenerovanychUpominek.size() > 0 && !this.input.over) {
                if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD) {
                    this.qr.update("EXECUTE PROCEDURE SPROC_ZPRACUJ_UPOMINKY(?, ?)", new Object[]{Utils.util2sqlDate((java.util.Date)this.input.datumGen), this.input.idCten});
                } else {
                    Connection connection = this.core2.conn;
                    KPWINServiceApplication.getConfiguration();
                    CallableStatement cs = connection.prepareCall("{ CALL " + Configuration.dbSchema + ".SPROC_ZPRACUJ_UPOMINKY(?, ?) }");
                    cs.setDate(1, Utils.util2sqlDate((java.util.Date)this.input.datumGen));
                    cs.setInt(2, this.input.idCten);
                    cs.execute();
                }
            }
        } else {
            logger.error("nastaven neznamy zpusob vypoctu pokut: " + this.zpusUpom);
        }
    }

    private BigDecimal spoctiRozdilUpominek(UpominkyVypuc upominka) {
        BigDecimal rozdil = upominka.getPOKUTA_UPOM().subtract(upominka.getPOKUTA_UPOM_PUV());
        return rozdil;
    }

    public double zjistiDosudZaplacenouCastkuNejPopl(Platby platbaMax) throws SQLException {
        BigDecimal soucet = BigDecimal.ZERO;
        List platby = (List)this.qr.query("SELECT * FROM PLATBY WHERE FK_UZIV_VLASTNIK = ? AND FK_POPL = 3", (ResultSetHandler)new KPSYSBeanListHandler(Platby.class), new Object[]{this.input.idCten});
        for (Platby platba : platby) {
            String servis = platba.getSERVIS();
            if (servis != null && servis.matches("^(\\d{1,3})$")) {
                short pujcovnaPlatby = Short.parseShort(platba.getSERVIS());
                if (pujcovnaPlatby != platbaMax.getFK_PUJC()) continue;
                soucet = soucet.add(platba.getCASTKA());
                continue;
            }
            if (platba.getFK_PUJC() != platbaMax.getFK_PUJC()) continue;
            soucet = soucet.add(platba.getCASTKA());
        }
        return soucet.doubleValue();
    }

    public BigDecimal zjistiDosudZaplacenouCastkuDleExemp(long idVypuc) throws SQLException {
        BigDecimal soucet = BigDecimal.ZERO;
        List platby = (List)this.qr.query("SELECT * FROM PLATBY WHERE FK_UZIV_VLASTNIK = ? AND FK_POPL = 3 AND FK_VYPUC=?", (ResultSetHandler)new KPSYSBeanListHandler(Platby.class), new Object[]{this.input.idCten, idVypuc});
        for (Platby platba : platby) {
            soucet = soucet.add(platba.getCASTKA());
        }
        return soucet;
    }

    private void zapisPlatbu(Platby platba) throws SQLException {
        if (BigDecimal.ZERO.compareTo(platba.getCASTKA()) < 0) {
            this.output.castka = this.output.castka.add(platba.getCASTKA());
            if (!this.input.over) {
                this.qr.update("INSERT INTO PLATBY (FK_UZIV_VLASTNIK, FK_POPL, CASTKA, DATUM, FK_PUJC, FK_UZIV, SERVIS, ID_PLATBY, VRACENO, FK_VYPUC) VALUES (?,?,?," + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + ",?,?,?,?,?,?)", new Object[]{platba.getFK_UZIV_VLASTNIK(), platba.getFK_POPL(), BigDecimal.ZERO.subtract(platba.getCASTKA()), platba.getFK_PUJC(), platba.getFK_UZIV(), platba.getSERVIS(), platba.getID_PLATBY(), platba.getVRACENO(), platba.getFK_VYPUC()});
            }
        } else {
            logger.error("pokus o zapsani vkladu jako pokuty " + platba + " vstup:" + this.input);
        }
    }

    private Platby generujPlatbu(short cisloUpominky, Vypuc vypuc, DefCtenVyp ctenVyp) {
        BigDecimal castka = ctenVyp.getPOPL(cisloUpominky);
        Platby platba = new Platby();
        platba.setFK_UZIV_VLASTNIK((long)vypuc.getFK_UZIV_CTEN());
        platba.setFK_POPL((short)3);
        platba.setCASTKA(castka);
        platba.setFK_PUJC(vypuc.getFK_PUJC());
        platba.setFK_UZIV((int)((short)this.input.fkUziv));
        if ("DLEEXEMP".equalsIgnoreCase(this.zpusUpom)) {
            platba.setFK_VYPUC(Long.valueOf(vypuc.getFK_VYPUC()));
        } else if ("DLEUPOM".equalsIgnoreCase(this.zpusUpom)) {
            platba.setSERVIS(Short.toString(cisloUpominky));
        } else {
            platba.setSERVIS(this.servisDateFormat.format(Utils.today()));
        }
        return platba;
    }

    private short zjistiCisloUpominky(Vypuc vypuc, DefCtenVyp ctenVyp) throws SQLException {
        boolean repeat;
        java.util.Date datumVraceni;
        short cisloUpominky = 0;
        if (ctenVyp == null) {
            return 0;
        }
        java.util.Date limitniDatumProdleni = GenUpomExecutor.addDays((java.util.Date)vypuc.getDAT_PROL(), (int)vypuc.getDOB_VYP().shortValue());
        try {
            String message = "VYPUC.ID=" + vypuc.getFK_VYPUC() + "| datum gen:" + this.input.datumGen.toString() + "| datumProdleni:" + limitniDatumProdleni.toString() + "| vypuc.DAT_PROL: " + vypuc.getDAT_PROL() + "| vypuc.DOB_VYP: " + vypuc.getDOB_VYP();
            logger.warn(message);
        }
        catch (Exception e) {
            logger.error("problem pri logovani datumu a casu pri genupom", (Throwable)e);
        }
        if (!this.input.datumGen.after(limitniDatumProdleni)) {
            return 0;
        }
        logger.warn("vypujcka " + vypuc.getFK_VYPUC() + " je v prodleni");
        if (ctenVyp.getZPUS_PUJC() == 0) {
            datumVraceni = GenUpomExecutor.addDays((java.util.Date)vypuc.getDAT_PROL(), (int)vypuc.getDOB_VYP().shortValue());
            int x = Utils.daysBetween((java.util.Date)datumVraceni, (java.util.Date)this.input.datumGen);
            if (x <= 0) {
                return 0;
            }
            int p1 = ctenVyp.getDOBA_U1() > 0 ? ctenVyp.getDOBA_U1() - ctenVyp.getDOBA_VYP() : 0;
            int p2 = ctenVyp.getDOBA_U2() > 0 ? p1 + ctenVyp.getDOBA_U2() - ctenVyp.getDOBA_U1() : 0;
            int p3 = ctenVyp.getDOBA_U3() > 0 ? p2 + ctenVyp.getDOBA_U3() - ctenVyp.getDOBA_U2() : 0;
            int p4 = ctenVyp.getDOBA_U4() > 0 ? p3 + ctenVyp.getDOBA_U4() - ctenVyp.getDOBA_U3() : 0;
            if (0 < x && p1 == 0 || x <= p1) {
                return 1;
            }
            if (p1 < x && p2 == 0 || x <= p2) {
                return 2;
            }
            if (p2 < x && p3 == 0 || x <= p3) {
                return 3;
            }
            if (p3 < x && p4 == 0 || x <= p4) {
                return 4;
            }
            if (p4 > 0) {
                return 5;
            }
            return 0;
        }
        datumVraceni = null;
        short i = 1;
        do {
            cisloUpominky = i;
            datumVraceni = ctenVyp.getDATUM_Ux(i);
            if (datumVraceni == null) break;
            repeat = this.input.datumGen.after(datumVraceni);
            i = (short)(i + 1);
        } while (repeat);
        return cisloUpominky;
    }

    public GenUpomOutput genUpom() throws SQLException, AppServerStatus {
        String dateParameter;
        this.qr = this.core2.obtainQueryRunnerOpened();
        this.output = new GenUpomOutput();
        this.zpusUpom = GenUpomExecutor.zjistiTypUpomPopl((short)this.input.idPujc);
        this.upominkyNerozlisovatPujcovnu = DbCache2.queryIINIFlagIsTrue((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.KATALOGIZACE_UPOMINKYNEROZLISOVATPUJCOVNU(), null, null);
        Ctenari ctenar = GenUpomExecutor.nactiCtenare((int)this.input.idCten);
        this.ctenKat = (DefCtenKat)((Map)DbCache2NG.ctenKatMap().get()).get(ctenar.getFK_CTENKAT());
        if (!this.ctenKat.jeUpom()) {
            logger.info("ctenar " + ctenar.getFK_UZIV() + " ma kategorii nepovolujici generovani upominek, koncim");
            return this.output;
        }
        String string = dateParameter = ProxoolUtil.engine() == DatabaseEngine.FIREBIRD ? "DAT_PROL" : "TRUNC(DAT_PROL)";
        if (this.input.idPujc > 0) {
            String query = "SELECT * FROM VYPUC WHERE FK_UZIV_CTEN=? AND FK_PUJC=? AND CIS_REZE=0 AND DOB_VYP>=0 AND (" + dateParameter + "+DOB_VYP)<?";
            List seznamProslychVypujcek = (List)this.qr.query(query, (ResultSetHandler)new KPSYSBeanListHandler(Vypuc.class), new Object[]{this.input.idCten, this.input.idPujc, Utils.util2sqlDate((java.util.Date)this.input.datumGen)});
            this.seznamVypuc.addAll(seznamProslychVypujcek);
        } else {
            String query = "SELECT * FROM VYPUC WHERE FK_UZIV_CTEN=? AND CIS_REZE=0 AND DOB_VYP>=0  AND (" + dateParameter + "+DOB_VYP)<?";
            List seznamProslychVypujcek = (List)this.qr.query(query, (ResultSetHandler)new KPSYSBeanListHandler(Vypuc.class), new Object[]{this.input.idCten, Utils.util2sqlDate((java.util.Date)this.input.datumGen)});
            this.seznamVypuc.addAll(seznamProslychVypujcek);
        }
        this.output.pocVypuc = this.seznamVypuc.size();
        this.odfiltrujDleData(this.seznamVypuc);
        this.zpracujVypujcky(ctenar);
        return this.output;
    }

    private void odfiltrujDleData(List<Vypuc> seznamVypuc) throws SQLException {
        LinkedList<Vypuc> toRemove = new LinkedList<Vypuc>();
        for (Vypuc vypuc : seznamVypuc) {
            if (vypuc.getDOB_VYP() < 0) {
                toRemove.add(vypuc);
                continue;
            }
            try {
                short cisloUpom;
                DefCtenVyp ctenVyp = GenUpomExecutor.nactiKombinaciCtenKatVypKat((DefCtenKat)this.ctenKat, (DefVypKat)this.nactiVypKat(vypuc.getFK_VYPKAT()));
                short cisloUpomVypuc = vypuc.getCIS_UPOM();
                if (cisloUpomVypuc < (cisloUpom = this.zjistiCisloUpominky(vypuc, ctenVyp))) continue;
                toRemove.add(vypuc);
            }
            catch (Exception e) {
                toRemove.add(vypuc);
            }
        }
        seznamVypuc.removeAll(toRemove);
    }
}

