/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.db.DbCache2;
import cz.kpsys.db.GenVerdenikExecutorNG;
import cz.kpsys.db.IntegerHandler;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.model.v2.MVSVerDenik;
import cz.kpsys.db.model.v2.OpacLogSessionVerdenik;
import cz.kpsys.db.model.v2.PolVymFondBudExemp;
import cz.kpsys.db.model.v2.SpoctiKultVzdel;
import cz.kpsys.db.model.v2.StatElSluzby;
import cz.kpsys.db.model.v2.StatInternet;
import cz.kpsys.db.model.v2.StatKultVzdel;
import cz.kpsys.db.model.v2.StatMetodika;
import cz.kpsys.db.model.v2.StatVydSluzby;
import cz.kpsys.service.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenVerdenikCache {
    private static final Logger logger = LoggerFactory.getLogger(GenVerdenikCache.class);
    private final QueryRunner qr;
    private final Date datum;
    private final boolean isFirebird;
    final String dateSelectQuery;
    final String dateSelectQueryLogVypuc;
    private List<Map<String, Object>> seznamVypujcekCache;
    private List<Map<String, Object>> navstevniciPujcovenAStudovenCtenariCache;
    private List<StatElSluzby> statElSluzbyCache;
    private List<StatVydSluzby> statVydSluzbyCache;
    private List<StatKultVzdel> statKultVzdelCache;
    private List<SpoctiKultVzdel> spoctiKultVzdelCache;
    private List<StatInternet> statInternetCache;
    private List<StatMetodika> statMetodikaCache;
    private List<OpacLogSessionVerdenik> opacLogSessionsCache;
    private List<MVSVerDenik> mvsCache;
    private List<PolVymFondBudExemp> polVymFondCache;
    private final Map<Long, Integer> zmenaTituloveVypujckyCache = new HashMap();

    public GenVerdenikCache(QueryRunner qr, Date datum, boolean isFirebird) {
        this.qr = qr;
        this.datum = datum;
        this.isFirebird = isFirebird;
        if (isFirebird) {
            this.dateSelectQueryLogVypuc = "CAST(LOG_VYPUC.DATCAS AS DATE)=?";
            this.dateSelectQuery = "CAST(DATUM AS DATE)=?";
        } else {
            this.dateSelectQueryLogVypuc = "TRUNC(LOG_VYPUC.DATCAS)=?";
            this.dateSelectQuery = "TRUNC(DATUM)=?";
        }
    }

    public List<Map<String, Object>> seznamVypujcek() throws SQLException {
        if (this.seznamVypujcekCache == null) {
            this.seznamVypujcekCache = new LinkedList();
            Connection conn = ProxoolUtil.obtainConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT LOG_VYPUC.FK_PUJC, VYPUC2.FK_TEMSKUP,  CAST(COALESCE(OSOBY.DAT_NAR, '20.2.1980') AS DATE) AS DAT_NAR, LOG_VYPUC.FK_VYPAKCE, KAT1_5.FK_DOKFOND, VYPUC2.FK_TYPPUJC, VYPUC2.FK_VYPKAT, VYPUC2.ID_VYPUC, KAT1_5.FK_ZAZ FROM LOG_VYPUC JOIN VYPUC2 ON LOG_VYPUC.FK_VYPUC=VYPUC2.ID_VYPUC LEFT JOIN CTENARI ON CTENARI.FK_UZIV=LOG_VYPUC.FK_UZIV_CTEN JOIN OSOBY ON OSOBY.FK_UZIV=LOG_VYPUC.FK_UZIV_CTEN JOIN KAT1_5 ON KAT1_5.ID_EX=FK_EX WHERE " + this.dateSelectQueryLogVypuc + " AND FK_VYPAKCE IN (1,3,5,53) AND VYPUC2.FK_TYPPUJC!=3");
            ps.setDate(1, Utils.util2sqlDate((Date)this.datum));
            if (ps.execute()) {
                ResultSet rs = ps.getResultSet();
                while (rs.next()) {
                    HashMap<String, Object> mapa = new HashMap<String, Object>();
                    mapa.put("FK_PUJC", rs.getObject("FK_PUJC"));
                    mapa.put("FK_TEMSKUP", rs.getObject("FK_TEMSKUP"));
                    mapa.put("DAT_NAR", rs.getDate("DAT_NAR"));
                    mapa.put("FK_VYPAKCE", rs.getObject("FK_VYPAKCE"));
                    mapa.put("FK_DOKFOND", rs.getObject("FK_DOKFOND"));
                    mapa.put("FK_TYPPUJC", rs.getObject("FK_TYPPUJC"));
                    mapa.put("FK_VYPKAT", rs.getObject("FK_VYPKAT"));
                    mapa.put("ID_VYPUC", rs.getObject("ID_VYPUC"));
                    mapa.put("FK_ZAZ", rs.getObject("FK_ZAZ"));
                    this.seznamVypujcekCache.add(mapa);
                }
            }
            conn.close();
        }
        return Collections.unmodifiableList(this.seznamVypujcekCache);
    }

    public List<Map<String, Object>> navstevniciPujcovenAStudovenCtenari() throws SQLException {
        if (this.navstevniciPujcovenAStudovenCtenariCache == null) {
            this.navstevniciPujcovenAStudovenCtenariCache = (List)this.qr.query("SELECT LOG_VYPUC.FK_UZIV_CTEN, VYPUC2.FK_PUJC, VYPUC2.FK_TYPPUJC, VYPUC2.ID_VYPUC FROM LOG_VYPUC LEFT JOIN VYPUC2 ON VYPUC2.ID_VYPUC=LOG_VYPUC.FK_VYPUC WHERE FK_VYPAKCE IN (1, 2, 3, 4, 5, 11, 12, 13, 14, 15, 21, 25, 27, 31, 32, 33, 81, 87, 95) AND FK_TYPPUJC<>3 AND NOT (LOG_VYPUC.FK_UZIV=? AND FK_VYPAKCE IN (11,12,13,14)) AND " + this.dateSelectQueryLogVypuc, (ResultSetHandler)new MapListHandler(), new Object[]{DbCache2.opacUserID, this.datum});
        }
        return Collections.unmodifiableList(this.navstevniciPujcovenAStudovenCtenariCache);
    }

    public List<StatElSluzby> statElSluzby() throws SQLException {
        if (this.statElSluzbyCache == null) {
            String query = this.isFirebird ? "SELECT * FROM STAT_EL_SLUZBY WHERE DATUM=?" : "SELECT * FROM STAT_EL_SLUZBY WHERE TRUNC(DATUM)=?";
            this.statElSluzbyCache = (List)this.qr.query(query, (ResultSetHandler)new KPSYSBeanListHandler(StatElSluzby.class), new Object[]{this.datum});
        }
        return Collections.unmodifiableList(this.statElSluzbyCache);
    }

    public List<StatVydSluzby> statVydSluzby() throws SQLException {
        if (this.statVydSluzbyCache == null) {
            String query = this.isFirebird ? "SELECT * FROM STAT_VYD_SLUZBY WHERE DATUM=?" : "SELECT * FROM STAT_VYD_SLUZBY WHERE TRUNC(DATUM)=?";
            this.statVydSluzbyCache = (List)this.qr.query(query, (ResultSetHandler)new KPSYSBeanListHandler(StatVydSluzby.class), new Object[]{this.datum});
        }
        return Collections.unmodifiableList(this.statVydSluzbyCache);
    }

    public List<PolVymFondBudExemp> polVymFond() throws SQLException {
        if (this.polVymFondCache == null) {
            String query = "SELECT * FROM POL_VYMFOND WHERE DATUM_IN=?";
            this.polVymFondCache = (List)this.qr.query("SELECT * FROM POL_VYMFOND WHERE DATUM_IN=?", (ResultSetHandler)new KPSYSBeanListHandler(PolVymFondBudExemp.class), new Object[]{this.datum});
            GenVerdenikExecutorNG.doplnBudovyExemplaru((List)this.polVymFondCache);
        }
        return Collections.unmodifiableList(this.polVymFondCache);
    }

    public List<StatInternet> statInternet() throws SQLException {
        if (this.statInternetCache == null) {
            this.statInternetCache = (List)this.qr.query("SELECT * FROM STAT_INTERNET WHERE DATUM=?", (ResultSetHandler)new KPSYSBeanListHandler(StatInternet.class), new Object[]{this.datum});
        }
        return Collections.unmodifiableList(this.statInternetCache);
    }

    public List<StatKultVzdel> statKultVzdel() throws SQLException {
        if (this.statKultVzdelCache == null) {
            this.statKultVzdelCache = (List)this.qr.query("SELECT * FROM STAT_KULTVZDEL WHERE DATUM=?", (ResultSetHandler)new KPSYSBeanListHandler(StatKultVzdel.class), new Object[]{this.datum});
        }
        return Collections.unmodifiableList(this.statKultVzdelCache);
    }

    public List<StatMetodika> statMetodika() throws SQLException {
        if (this.statMetodikaCache == null) {
            this.statMetodikaCache = (List)this.qr.query("SELECT * FROM STAT_METODIKA WHERE DATUM=?", (ResultSetHandler)new KPSYSBeanListHandler(StatMetodika.class), new Object[]{this.datum});
        }
        return Collections.unmodifiableList(this.statMetodikaCache);
    }

    public List<MVSVerDenik> mvs() throws SQLException {
        String datPoz = "DAT_POZ";
        String datVyr = "DAT_VYR";
        if (this.mvsCache == null) {
            String query = "SELECT JE_AKTIV, MVS.FK_PUJC, KOD_STAVU, DAT_POZ, DAT_VYR FROM MVS JOIN CTENARI ON FK_UZIV=FK_UZIV_KNIH WHERE DAT_POZ=? OR DAT_VYR=?";
            this.mvsCache = (List)this.qr.query("SELECT JE_AKTIV, MVS.FK_PUJC, KOD_STAVU, DAT_POZ, DAT_VYR FROM MVS JOIN CTENARI ON FK_UZIV=FK_UZIV_KNIH WHERE DAT_POZ=? OR DAT_VYR=?", (ResultSetHandler)new KPSYSBeanListHandler(MVSVerDenik.class), new Object[]{this.datum, this.datum});
        }
        return Collections.unmodifiableList(this.mvsCache);
    }

    public List<OpacLogSessionVerdenik> opacLogSessions() throws SQLException {
        if (this.opacLogSessionsCache == null) {
            Object query = "select FK_UZIV, IP_ADRESA, UVNITR_KNIHOVNY, FK_PUJC from opac_log_sessions where JE_BOT=0 AND ";
            query = this.isFirebird ? (String)query + "CAST(CAS_VYTVORENI AS DATE)=?" : (String)query + "TRUNC(CAS_VYTVORENI)=?";
            this.opacLogSessionsCache = (List)this.qr.query((String)query, (ResultSetHandler)new KPSYSBeanListHandler(OpacLogSessionVerdenik.class), new Object[]{this.datum});
        }
        return Collections.unmodifiableList(this.opacLogSessionsCache);
    }

    public int zmenaTituloveVypujcky(long idVypuc) throws SQLException {
        if (!this.zmenaTituloveVypujckyCache.containsKey(idVypuc)) {
            int pocetKusu = (Integer)this.qr.query("SELECT SUM(ZMENA) from VYPUC_TITPER where FK_VYPUC=? and " + this.dateSelectQuery + " and ZMENA > 0", (ResultSetHandler)new IntegerHandler(Integer.valueOf(0)), new Object[]{idVypuc, this.datum});
            this.zmenaTituloveVypujckyCache.put(idVypuc, pocetKusu);
        }
        return (Integer)this.zmenaTituloveVypujckyCache.get(idVypuc);
    }
}

