/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.common.IniConstants;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GeneratorLuceneKlicu;
import cz.kpsys.db.ISBNUtil;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.db.RecordReconstructor2Cache;
import cz.kpsys.db.RecordReconstructor2Util;
import cz.kpsys.db.model.LuceneField;
import cz.kpsys.db.model.StringTouple;
import cz.kpsys.db.model.v2.FDef;
import cz.kpsys.db.model.v2.FDefAut;
import cz.kpsys.db.model.v2.FiktivniPoleIndexace;
import cz.kpsys.db.model.v2.LuceneTokenizerEnum;
import cz.kpsys.db.model.v2.ZpusobKlicovani;
import cz.kpsys.db.model.v2.ZpusobValidace;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Field008;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.SubField;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeneratorLuceneKlicu {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorLuceneKlicu.class);
    private static final int MAX_KEY_LENGTH = 8000;
    private static final int ROK_ZACATKU_ZPRACOVANI = 90;
    private static final int MINIMAL_WORD_LENGTH = 3;
    private static final HashSet<Short> poleSRoli = new HashSet<Short>(Arrays.asList((short)100, (short)110, (short)111, (short)600, (short)610, (short)611, (short)700, (short)710, (short)711));
    private final DbCore2 core2;
    private final Record r;
    Map<String, StringBuilder> obsahyPoli = new HashedMap();
    short cisloPoslednihoPole = 0;
    int opakovani = 0;
    private Set<String> keywordFieldNames;

    public GeneratorLuceneKlicu(DbCore2 core2, Record r) {
        this.core2 = core2;
        this.r = r;
    }

    private void pridejObsahPole(String klic, String obsahPole) {
        StringBuilder sb = (StringBuilder)this.obsahyPoli.get(klic);
        if (sb == null) {
            sb = new StringBuilder();
            this.obsahyPoli.put(klic, sb);
        }
        sb.append(obsahPole).append(" ");
    }

    public List<LuceneField> generujKlice() throws SQLException {
        String ERROR = "problem pri indexaci zaznamu ID:" + this.r.getId() + " - ";
        this.pripravSeznamKeywordsFieldu();
        boolean marcStrict = KPWINServiceApplication.configuration.marc21strict;
        try {
            this.doplnVizTvaryZAutorit();
        }
        catch (Exception e) {
            logger.warn(ERROR + "doplneni viz. tvaru", (Throwable)e);
        }
        for (Field f : this.r.getFields()) {
            if (this.cisloPoslednihoPole != f.getNumber()) {
                this.cisloPoslednihoPole = f.getNumber();
                this.opakovani = 1;
            } else {
                ++this.opakovani;
            }
            if (marcStrict) {
                if (f.getNumber() == 5) continue;
                if (DbCache2.jeDokFond((short)this.r.getFond()) && f.getNumber() == 8) {
                    try {
                        this.generujKliceZPole008(f);
                    }
                    catch (Exception e) {
                        logger.warn(ERROR + "parsovani pole 008", (Throwable)e);
                    }
                    continue;
                }
                if (DbCache2.jeDokFond((short)this.r.getFond()) && f.getNumber() == 245) {
                    try {
                        this.generujKlice245a(f);
                    }
                    catch (Exception e) {
                        logger.info("selhani", (Throwable)e);
                    }
                }
            }
            try {
                String key = Short.toString(f.getNumber());
                boolean pridamePlainContent = true;
                for (SubField sf : f.getSubfields()) {
                    ZpusobKlicovani zpusobKlicovani;
                    ZpusobValidace zpusobValidace;
                    String kodVal = null;
                    if (!this.r.isAuthority()) {
                        FDef fdef = DbCache2.najdiFDef((int)f.getNumber(), (String)sf.getPrefix());
                        zpusobValidace = fdef == null ? ZpusobValidace.BEZNY : fdef.zjistiZpusobValidace();
                        ZpusobKlicovani zpusobKlicovani2 = zpusobKlicovani = fdef == null ? ZpusobKlicovani.STANDARD : fdef.zjistiZpusobKlicovani();
                        if (fdef != null) {
                            kodVal = fdef.PIC;
                        }
                    } else {
                        FDefAut fdefAut = DbCache2.najdiFDefAut((int)f.getNumber(), (String)sf.getPrefix());
                        zpusobValidace = fdefAut == null ? ZpusobValidace.BEZNY : fdefAut.zjistiZpusobValidace();
                        ZpusobKlicovani zpusobKlicovani3 = zpusobKlicovani = fdefAut == null ? ZpusobKlicovani.STANDARD : fdefAut.zjistiZpusobKlicovani();
                        if (fdefAut != null) {
                            kodVal = fdefAut.PIC;
                        }
                    }
                    String input = sf.getContent();
                    if (zpusobKlicovani != ZpusobKlicovani.NEKLICOVAT) {
                        SubField sf4;
                        this.oklicuj(zpusobKlicovani, input, key, this.r.isAuthority());
                        if (poleSRoli.contains(f.getNumber()) && (sf4 = f.getFirstSubfield("4")) != null) {
                            Field fBez4 = f;
                            String kodRole = "_" + sf4.getContent().toLowerCase();
                            this.oklicuj(zpusobKlicovani, input, key + kodRole, this.r.isAuthority());
                        }
                    } else {
                        pridamePlainContent = false;
                    }
                    switch (1.$SwitchMap$cz$kpsys$db$model$v2$ZpusobValidace[zpusobValidace.ordinal()]) {
                        case 1: 
                        case 2: {
                            List validacniSlovnik;
                            List list = validacniSlovnik = kodVal != null ? DbCache2.validacniSlovnik((String)kodVal) : null;
                            if (validacniSlovnik == null) {
                                logger.error("v poli " + f.getNumber() + " podpoli " + sf.getPrefix() + " zaznamu " + this.r.getFondId() + " je definovana validace oproti slovniku, tento ale nebyl v databazi nalezen");
                                break;
                            }
                            String klic = sf.getContent();
                            String slovoZeSlovniku = DbCache2.najdiSlovoVeSlovniku((String)klic, (List)validacniSlovnik);
                            List lokalizovanaHesla = DbCache2.najdiLokalizace((String)klic, (String)kodVal);
                            if (slovoZeSlovniku != null) {
                                lokalizovanaHesla.add(slovoZeSlovniku);
                            }
                            for (String heslo : lokalizovanaHesla) {
                                this.oklicujStandard(key, heslo);
                            }
                            break;
                        }
                    }
                }
                if (!pridamePlainContent) continue;
                String plainContent = f.getPlainContent(KPWINServiceApplication.configuration.marc21strict);
                this.pridejObsahPole(key, plainContent);
            }
            catch (Exception e) {
                logger.warn(ERROR + "generovani klicu z pole " + f.getNumber(), (Throwable)e);
            }
        }
        try {
            ArrayList poleIndexace = DbCache2.virtualniPoleIndexace;
            for (FiktivniPoleIndexace fiktivniPoleIndexace : poleIndexace) {
                String keyFiktivniPole = Short.toString(fiktivniPoleIndexace.getDestinationFieldNumber());
                List fields = this.r.getFields(fiktivniPoleIndexace.getSourceFieldNumber());
                for (Field f : fields) {
                    if (this.keywordFieldNames.contains(keyFiktivniPole)) {
                        this.obsahyPoli.put(keyFiktivniPole, new StringBuilder(f.getPlainContent(KPWINServiceApplication.configuration.marc21strict)));
                        continue;
                    }
                    SubField sf = f.getFirstSubfield(fiktivniPoleIndexace.getSourceSubFieldPrefix());
                    ZpusobKlicovani zpusobKlicovani = DbCache2.najdiZpusobKlicovani((boolean)this.r.isAuthority(), (int)fiktivniPoleIndexace.getSourceFieldNumber(), (String)fiktivniPoleIndexace.getSourceSubFieldPrefix());
                    if (sf == null || !StringUtils.isNotBlank((CharSequence)sf.getContent())) continue;
                    this.oklicuj(zpusobKlicovani, sf.getContent(), keyFiktivniPole, this.r.isAuthority());
                }
            }
        }
        catch (Exception e) {
            logger.warn(ERROR + "generovani klicu z fiktivnich poli", (Throwable)e);
        }
        ArrayList<LuceneField> luceneFields = new ArrayList<LuceneField>(this.obsahyPoli.size());
        for (String key : this.obsahyPoli.keySet()) {
            String content = StringUtils.trimToEmpty((String)((StringBuilder)this.obsahyPoli.get(key)).toString());
            boolean indexAsKeyword = this.keywordFieldNames.contains(key);
            LuceneField lf = this.novyKlic(key, content, indexAsKeyword);
            luceneFields.add(lf);
        }
        return luceneFields;
    }

    private void pripravSeznamKeywordsFieldu() {
        this.keywordFieldNames = new HashSet();
        ArrayList poleIndexace = DbCache2.virtualniPoleIndexace;
        for (FiktivniPoleIndexace pole : poleIndexace) {
            if (pole.getLuceneTokenizer() != LuceneTokenizerEnum.KEYWORD) continue;
            this.keywordFieldNames.add(Short.toString(pole.getDestinationFieldNumber()));
        }
    }

    private void generujKlice245a(Field f) {
        String obsah = f.getSubfieldContent("a");
        if (StringUtils.isNotBlank((CharSequence)obsah)) {
            String obsahSpaced = GeneratorLuceneKlicu.nahradOddelovaceMezeramaSS((String)obsah);
            this.pridejObsahPole("245A", obsahSpaced);
        }
    }

    private void doplnVizTvaryZAutorit() throws SQLException {
        Object f2;
        HashedMap odkazyNaAutority = new HashedMap();
        Record prazdnyRecord = new Record();
        block2: for (Object f2 : this.r.getFields()) {
            if (f2.getNumber() < 10) continue;
            for (SubField sf : f2.getSubfields()) {
                if (sf.getAuthLink() == 0L) continue;
                odkazyNaAutority.put(sf.getAuthLinkID(), prazdnyRecord);
                continue block2;
            }
        }
        RecordReconstructor2 rc2 = new RecordReconstructor2(this.core2);
        RecordReconstructor2Util.cachePredemVsechnyOdkazovaneAutorityNormalizujUnicode((RecordReconstructor2Cache)rc2.cache, odkazyNaAutority.keySet(), null);
        rc2.setValidaceEnabled(false);
        f2 = odkazyNaAutority.keySet().iterator();
        while (f2.hasNext()) {
            long l = (Long)f2.next();
            try {
                odkazyNaAutority.put(l, rc2.reconstructRecord(l, true));
            }
            catch (SQLException e) {
                logger.warn("problem pri rekonsu autority pri indexaci VIZ. tvaru", (Throwable)e);
            }
        }
        ArrayList<Field> seznamPoliKPridani = new ArrayList<Field>(odkazyNaAutority.size() * 2);
        block5: for (Field f3 : this.r.getFields()) {
            if (f3.getNumber() < 10) continue;
            for (SubField sf : f3.getSubfields()) {
                if (sf.getAuthLink() == 0L) continue;
                Record autorita = (Record)odkazyNaAutority.get(sf.getAuthLinkID());
                List vizTvary = autorita.getXXXFieldsWithNumberStarting("4");
                for (Field vizTvar : vizTvary) {
                    vizTvar.setNumber(f3.getNumber());
                    seznamPoliKPridani.add(vizTvar);
                }
                List cizojazycneEkvivatenty = autorita.getXXXFieldsWithNumberStarting("7");
                for (Field cizJazTvar : cizojazycneEkvivatenty) {
                    cizJazTvar.setNumber(f3.getNumber());
                    seznamPoliKPridani.add(cizJazTvar);
                }
                continue block5;
            }
        }
        this.r.getFields().addAll(seznamPoliKPridani);
    }

    public void oklicuj(ZpusobKlicovani zpusobKlicovani, String input, String klic, boolean autorita) {
        switch (1.$SwitchMap$cz$kpsys$db$model$v2$ZpusobKlicovani[zpusobKlicovani.ordinal()]) {
            case 1: {
                this.oklicujStandard(klic, input);
                break;
            }
            case 2: {
                this.oklicujStandard(klic, input);
                break;
            }
            case 3: {
                this.oklicujJakoCelek(klic, input, autorita);
                break;
            }
            case 4: {
                this.oklicujIsbnIssn(klic, input);
                break;
            }
            case 5: {
                input = GeneratorLuceneKlicu.nahradOddelovaceMezeramaSS((String)input);
                input = this.vyberSlovaVeSvislitkach(input);
                this.oklicujStandard(klic, input);
            }
        }
    }

    private String vyberSlovaVeSvislitkach(String input) {
        input = input.trim();
        StringBuilder sb = new StringBuilder();
        if (input.length() == 0) {
            return sb.toString();
        }
        if (input.startsWith("|") && input.length() > 1) {
            int last = input.substring(1).indexOf(124);
            if (last == -1) {
                sb.append(input.substring(1)).append(" ");
                return sb.toString();
            }
            sb.append(input.substring(1, last + 1)).append(" ");
            sb.append(this.vyberSlovaVeSvislitkach(input.substring(last + 2)));
        } else {
            int last = input.indexOf(32);
            int lastSvislistko = input.indexOf(124);
            if (lastSvislistko > -1 && lastSvislistko < last) {
                last = lastSvislistko;
            }
            if (last == -1) {
                sb.append(input).append(" ");
                return sb.toString();
            }
            sb.append(input.substring(0, last)).append(" ");
            sb.append(this.vyberSlovaVeSvislitkach(input.substring(last)));
        }
        return sb.toString();
    }

    public static String nahradOddelovaceMezeramaSS(String input) {
        char[] delimetersArray;
        String delimeters = DbCache2.queryINIFlag((String)IniConstants.SEKCE_KPWIN(), (String)"DELIM", null, null);
        for (char c : delimetersArray = delimeters.toCharArray()) {
            input = input.replace(c, ' ');
        }
        input = input.replace("\u00df", "ss");
        return input;
    }

    public void oklicujStandard(String key, String input) {
        input = GeneratorLuceneKlicu.nahradOddelovaceMezeramaSS((String)input);
        this.pridejObsahPole(key, input);
    }

    public void oklicujJakoCelek(String key, String input, boolean autorita) {
        ArrayList slova = new ArrayList(20);
        ArrayList slovaSvislitka = new ArrayList(20);
        input = GeneratorLuceneKlicu.nahradOddelovaceMezeramaSS((String)input);
        this.pridejObsahPole(key, input);
    }

    private void oklicujIsbnIssn(String key, String input) {
        StringTouple isbnZbytek = ISBNUtil.najdiISBNISSNaVyplivniZbytek((String)input);
        String isbnIssn = isbnZbytek.getA();
        String zbytek = isbnZbytek.getB();
        if (StringUtils.isNotBlank((CharSequence)isbnIssn)) {
            ISBNUtil.NormalizedISXN normalizovaneISBN = ISBNUtil.normalizujISBN((String)isbnIssn);
            this.pridejObsahPole(key, isbnIssn);
            this.pridejObsahPole(key, normalizovaneISBN.original());
            this.pridejObsahPole(key, normalizovaneISBN.core());
        }
        if (StringUtils.isNotBlank((CharSequence)zbytek)) {
            this.oklicujStandard(key, zbytek);
        }
    }

    private void generujKliceZPole008(Field f) {
        int MAX_YEARS_INTERVAL = 40;
        Field008 f008 = Field008.instance((Field)f);
        Range rozsahLet = f008.parseRokyFrom008();
        if (rozsahLet.equals((Object)Field008.nullRange)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int minYear = (Integer)rozsahLet.getMinimum();
        int maxYear = (Integer)rozsahLet.getMaximum();
        if (maxYear - minYear > 40) {
            i = minYear;
            while (i < maxYear) {
                this.pridejObsahPole(Integer.toString(260), Integer.toString(i));
                i = 10 * ((i + 10) / 10);
            }
            this.pridejObsahPole(Integer.toString(260), Integer.toString(maxYear));
        } else {
            for (i = minYear; i <= maxYear; ++i) {
                try {
                    this.pridejObsahPole(Integer.toString(260), Integer.toString(i));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    logger.debug("neplatne cislo roku, zazn. id:" + this.r.getId());
                }
            }
        }
        String jazyk = f008.getKodJazyka();
        String popisJazyka = null;
        try {
            List slovnik = DbCache2.validacniSlovnik((String)"VAL63K");
            popisJazyka = DbCache2.najdiSlovoVeSlovniku((String)jazyk, (List)slovnik);
        }
        catch (SQLException e) {
            logger.warn("nepodarilo se nacist validacni slovnik jazyku", (Throwable)e);
        }
        String key41 = "41";
        this.pridejObsahPole("41", jazyk);
        if (popisJazyka != null) {
            this.pridejObsahPole("41", popisJazyka);
        }
        String key44 = "44";
        String zeme = f008.getKodStatu();
        this.pridejObsahPole("44", zeme);
    }

    private LuceneField novyKlic(String key, String obsah, boolean indexAsKeyword) {
        LuceneField luceneField = new LuceneField();
        luceneField.analyze = !indexAsKeyword;
        luceneField.store = false;
        luceneField.setContent(obsah.toLowerCase());
        luceneField.key = key;
        return luceneField;
    }
}

