/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.common.YearInterval;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GeneratorPole910NG;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefPujc;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.SubField;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;
import scala.collection.immutable.Map;

public class GeneratorPole910 {
    private static final String FAKE_SIGLA_KDYZ_NENI_HLAVNI = "-";
    private static final int POLE_910 = 910;
    static final String mezer30 = "                              ";
    private static final Logger logger = LoggerFactory.getLogger(GeneratorPole910.class);
    private final DbCore2 core2;
    private final Record r;
    private final Set<String> sigly = new HashSet();
    private final java.util.Map<String, String> siglaSignaMap = new HashMap();
    private final boolean generovatSiglu;
    private final boolean plnit910;
    private final boolean prepisovat910r;
    private boolean nepripojovatPriponuK910b = false;
    private List<Kat1_5> exemplare;
    private String siglaUK;

    protected GeneratorPole910() {
        this.r = null;
        this.core2 = null;
        this.generovatSiglu = false;
        this.plnit910 = false;
        this.prepisovat910r = true;
    }

    public GeneratorPole910(Record r, DbCore2 core2, boolean generovatSiglu, boolean plnit910, boolean prepisovat910r, String plnit910Volby) throws SQLException {
        String[] volbyPole;
        this.r = r;
        this.core2 = core2;
        this.generovatSiglu = generovatSiglu;
        this.plnit910 = plnit910;
        this.prepisovat910r = prepisovat910r;
        for (String hodnota : volbyPole = ((String)StringUtils.defaultIfBlank((CharSequence)plnit910Volby, (CharSequence)"")).split(";")) {
            if (!hodnota.toLowerCase().equals("b_bez_pripony")) continue;
            this.nepripojovatPriponuK910b = true;
        }
        this.pripravSeznamSigel(r, core2);
    }

    protected void pripravSeznamSigel(Record r, DbCore2 core2) throws SQLException {
        QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
        this.exemplare = (List)qr.query("SELECT * FROM KAT1_5 WHERE RECORD_ID=? AND FK_UBYTEK IS NULL AND TYP_CISLA!=1 ORDER BY FK_PUJC, PORADI, TRIDSIGN", (ResultSetHandler)BeanHandlers.kat1_5BLH(), new Object[]{r.recordId});
        GeneratorPole910NG.doplnSiglyZPrirustku((List)this.exemplare, (Set)this.sigly, (java.util.Map)this.siglaSignaMap, (boolean)this.nepripojovatPriponuK910b);
        this.siglaUK = DbCache.siglaKnihovny();
        if (this.jsouVsechnySiglyExemplaruPrazdne((Collection)this.exemplare)) {
            if (StringUtils.isBlank((CharSequence)this.siglaUK)) {
                this.siglaUK = FAKE_SIGLA_KDYZ_NENI_HLAVNI;
                String vnucenaSigna = null;
                if (this.exemplare.size() > 0) {
                    vnucenaSigna = ((Kat1_5)this.exemplare.get(0)).getSIGNATURA();
                }
                if (vnucenaSigna != null) {
                    this.siglaSignaMap.put(this.siglaUK, vnucenaSigna);
                }
            }
            this.sigly.add(this.siglaUK);
        }
    }

    private boolean jsouVsechnySiglyExemplaruPrazdne(Collection<Kat1_5> exemplare) {
        for (Kat1_5 kat1_5 : exemplare) {
            DefPujc pujcovna;
            Short pujcovnaExemplar = kat1_5.getFK_PUJC();
            if (pujcovnaExemplar == null || (pujcovna = (DefPujc)((Map)DbCache2NG.pujcovnyMap().get()).apply((Object)pujcovnaExemplar)) == null || !StringUtils.isNotBlank((CharSequence)pujcovna.getSIGLA())) continue;
            return false;
        }
        return true;
    }

    public void generujPole910() throws SQLException {
        Field f;
        SubField sfA;
        List seznamPoli910 = this.seznamPoliKeZpracovani();
        if (!this.generovatSiglu && StringUtils.isNotBlank((CharSequence)this.siglaUK)) {
            Field prvniPole910 = (Field)seznamPoli910.get(0);
            prvniPole910.getOrCreateSubfield("a").setContent(this.siglaUK);
        }
        if (this.plnit910) {
            boolean prvniOpakovani = true;
            for (Field f2 : seznamPoli910) {
                String signa = null;
                String sigla = f2.getSubfieldContent("a");
                if (StringUtils.isNotBlank((CharSequence)sigla) && StringUtils.isNotBlank((CharSequence)(signa = (String)this.siglaSignaMap.get(sigla)))) {
                    f2.getOrCreateSubfield("b").setContent(signa);
                }
                if (prvniOpakovani) {
                    String roky;
                    boolean periodikum;
                    if (seznamPoli910.size() == 1 && StringUtils.isBlank((CharSequence)signa)) {
                        for (Kat1_5 kat1_5 : this.exemplare) {
                            Object neprazdnaSignatura = kat1_5.getSIGNATURA();
                            if (!StringUtils.isNotBlank((CharSequence)neprazdnaSignatura)) continue;
                            if (this.nepripojovatPriponuK910b) {
                                Tuple3 prefBodSuff = GenericExecutorScala.signaturaPrefixBodySuffix((String)StringUtils.left((String)((String)StringUtils.defaultIfBlank((CharSequence)kat1_5.getTRIDSIGN(), (CharSequence)"") + mezer30), (int)30));
                                String novaSignatura = (String)prefBodSuff._1() + " " + (String)prefBodSuff._2();
                                neprazdnaSignatura = novaSignatura;
                            }
                            f2.getOrCreateSubfield("b").setContent((String)neprazdnaSignatura);
                            break;
                        }
                    }
                    if ((periodikum = this.jePeriodikum()) && this.prepisovat910r && StringUtils.isNotBlank((CharSequence)(roky = this.roky()))) {
                        f2.getOrCreateSubfield("r").setContent(roky);
                    }
                }
                prvniOpakovani = false;
                f2.sort(DbCache2.poradiPodpoli910ProFond((short)this.r.getFond()));
            }
        }
        if (seznamPoli910.size() > 0 && (sfA = (f = (Field)seznamPoli910.get(0)).getFirstSubfield("a")) != null && FAKE_SIGLA_KDYZ_NENI_HLAVNI.equals(sfA.getContent())) {
            sfA.setVisible(false);
        }
    }

    private List<Field> seznamPoliKeZpracovani() {
        List seznamPole910 = this.r.getFields(910);
        if (!this.generovatSiglu) {
            if (seznamPole910.size() == 0) {
                Field pole910 = this.vytvorPrazdnePole910();
                this.r.getFields().add(pole910);
                return this.r.getFields(910);
            }
            ArrayList<Field> seznamPoli910 = new ArrayList<Field>(1);
            seznamPoli910.add(this.r.getFirstField(910));
            return seznamPoli910;
        }
        HashSet<Field> poleKOdstraneni = new HashSet<Field>();
        HashSet chybejiciSigly = new HashSet();
        chybejiciSigly.addAll(this.sigly);
        ArrayList<Field> poleBezSigel = new ArrayList<Field>();
        for (Field f : this.r.getFields(910)) {
            String sigla = f.getSubfieldContent("a");
            if (StringUtils.isNotBlank((CharSequence)sigla)) {
                if (!this.sigly.contains(sigla)) {
                    poleKOdstraneni.add(f);
                    continue;
                }
                chybejiciSigly.remove(sigla);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)f.getSubfieldContent("b")) && StringUtils.isBlank((CharSequence)f.getSubfieldContent("r"))) {
                poleKOdstraneni.add(f);
                continue;
            }
            poleBezSigel.add(f);
        }
        if (chybejiciSigly.size() == 0 && poleKOdstraneni.size() == 1 && seznamPole910.size() == 1) {
            return seznamPole910;
        }
        this.r.getFields().removeAll(poleKOdstraneni);
        int pocitadloPoleBezSigel = 0;
        for (String sigla : chybejiciSigly) {
            if (pocitadloPoleBezSigel < poleBezSigel.size()) {
                Field f = (Field)poleBezSigel.get(pocitadloPoleBezSigel);
                SubField firstSubField = f.getFirstSubfield("a");
                if (firstSubField == null) {
                    SubField sf = new SubField("a", sigla);
                    f.insertSubFieldAt(0, sf);
                } else {
                    firstSubField.setContent(sigla);
                }
            } else {
                Field novePole910 = this.vytvorPrazdnePole910();
                novePole910.getOrCreateSubfield("a").setContent(sigla);
                this.r.getFields().add(novePole910);
            }
            ++pocitadloPoleBezSigel;
        }
        return this.r.getFields(910);
    }

    private Field vytvorPrazdnePole910() {
        Field f = new Field(910);
        return f;
    }

    private boolean jePeriodikum() {
        DefFond dokFond = (DefFond)DbCache2.defDokFondMap.get(this.r.getFond());
        if (dokFond == null) {
            return false;
        }
        return dokFond.isJE_PERIO();
    }

    public String roky() throws SQLException {
        return this.zpracujRokyVydani(GeneratorPole910NG.zjistiRokyVydani((long)this.r.getId()));
    }

    protected String zpracujRokyVydani(List<String> roky) {
        ArrayList<YearInterval> rokyVydani = new ArrayList<YearInterval>();
        for (String rokInterval : roky) {
            if (rokInterval.length() < 4) continue;
            try {
                YearInterval yearInterval = new YearInterval(Integer.parseInt(rokInterval.substring(0, 4)));
                rokInterval = rokInterval.replace("/", FAKE_SIGLA_KDYZ_NENI_HLAVNI);
                if (rokInterval.contains(FAKE_SIGLA_KDYZ_NENI_HLAVNI)) {
                    String[] viceLet = rokInterval.split(FAKE_SIGLA_KDYZ_NENI_HLAVNI);
                    yearInterval.setLastYear(Integer.parseInt(viceLet[1]));
                }
                yearInterval.normalize();
                rokyVydani.add(yearInterval);
            }
            catch (Exception tce) {
                logger.debug("rok_vol divny format", (Throwable)tce);
            }
        }
        String rokyRet = this.generujIntervalyZLet(rokyVydani);
        return rokyRet;
    }

    protected String generujIntervalyZLet(List<YearInterval> rokyVydani) {
        LinkedList<YearInterval> zpracovaneRokyVydani = new LinkedList<YearInterval>();
        TreeSet rokySet = new TreeSet();
        for (YearInterval yearInterval : rokyVydani) {
            yearInterval.pridejSeznamLet(rokySet);
        }
        YearInterval interval = null;
        int predchoziRok = 0;
        Iterator iterator = rokySet.iterator();
        while (iterator.hasNext()) {
            int year = (Integer)iterator.next();
            if (year - 1 != predchoziRok) {
                if (interval != null) {
                    interval.setLastYear(predchoziRok);
                    zpracovaneRokyVydani.add(interval);
                    interval = new YearInterval(year);
                } else {
                    interval = new YearInterval(year);
                }
            }
            predchoziRok = year;
        }
        if (interval != null) {
            interval.setLastYear(predchoziRok);
        } else if (predchoziRok != 0) {
            interval = new YearInterval(predchoziRok);
        }
        if (interval != null) {
            zpracovaneRokyVydani.add(interval);
        }
        return StringUtils.join(zpracovaneRokyVydani, (String)",");
    }
}

