/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.dbutils.ColumnHandler;
import org.apache.commons.dbutils.PropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KPSYSBeanProcessor {
    final Logger logger = LoggerFactory.getLogger(KPSYSBeanProcessor.class);
    private final boolean isFirebird;
    protected static final int PROPERTY_NOT_FOUND = -1;
    private static final Map<Class<?>, Object> primitiveDefaults = new HashMap();
    private static final ServiceLoader<ColumnHandler> columnHandlers = ServiceLoader.load(ColumnHandler.class);
    private static final ServiceLoader<PropertyHandler> propertyHandlers = ServiceLoader.load(PropertyHandler.class);
    private final Map<String, String> columnToPropertyOverrides;

    public KPSYSBeanProcessor(boolean isFirebird) {
        this(new HashMap(), isFirebird);
    }

    private KPSYSBeanProcessor() {
        this(new HashMap(), false);
    }

    public KPSYSBeanProcessor(Map<String, String> columnToPropertyOverrides, boolean isFirebird) {
        this.isFirebird = isFirebird;
        if (columnToPropertyOverrides == null) {
            throw new IllegalArgumentException("columnToPropertyOverrides map cannot be null");
        }
        this.columnToPropertyOverrides = columnToPropertyOverrides;
    }

    public <T> T toBean(ResultSet rs, Class<? extends T> type) throws SQLException {
        Object bean = this.newInstance(type);
        return (T)this.populateBean(rs, bean);
    }

    public <T> List<T> toBeanList(ResultSet rs, Class<? extends T> type) throws SQLException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (!rs.next()) {
            return results;
        }
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        do {
            results.add(this.createBean(rs, type, props, columnToProperty));
        } while (rs.next());
        return results;
    }

    private <T> T createBean(ResultSet rs, Class<T> type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        Object bean = this.newInstance(type);
        return (T)this.populateBean(rs, bean, props, columnToProperty);
    }

    public <T> T populateBean(ResultSet rs, T bean) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(bean.getClass());
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        return (T)this.populateBean(rs, bean, props, columnToProperty);
    }

    private <T> T populateBean(ResultSet rs, T bean, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        for (int i = 1; i < columnToProperty.length; ++i) {
            if (columnToProperty[i] == -1) continue;
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<Object> propType = prop.getPropertyType();
            Object value = null;
            if (propType != null) {
                boolean shortHackNeeded;
                boolean bl = shortHackNeeded = this.isFirebird && propType.getName().equals("boolean");
                if (shortHackNeeded) {
                    propType = Short.class;
                }
                if ((value = this.processColumn(rs, i, propType)) == null && propType.isPrimitive()) {
                    value = primitiveDefaults.get(propType);
                }
                if (shortHackNeeded) {
                    value = (Short)value > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            }
            this.callSetter(bean, prop, value);
        }
        return bean;
    }

    private short toShortExact(int value) {
        if ((short)value != value) {
            throw new ArithmeticException("short overflow");
        }
        return (short)value;
    }

    private void callSetter(Object target, PropertyDescriptor prop, Object value) throws SQLException {
        block11: {
            Method setter = this.getWriteMethod(target, prop, value);
            if (setter == null || setter.getParameterTypes().length != 1) {
                return;
            }
            try {
                Class<?> firstParam = setter.getParameterTypes()[0];
                for (PropertyHandler handler : propertyHandlers) {
                    if (!handler.match(firstParam, value)) continue;
                    value = handler.apply(firstParam, value);
                    break;
                }
                if (this.isCompatibleType(value, firstParam)) {
                    setter.invoke(target, value);
                    break block11;
                }
                String propName = prop.getName();
                String className = value.getClass().getName();
                String paramName = firstParam.getName();
                if ("java.lang.Long".equals(className) && "int".equals(paramName)) {
                    Integer intValue = Math.toIntExact((Long)value);
                    setter.invoke(target, intValue);
                    break block11;
                }
                if ("java.lang.Long".equals(className) && "java.lang.Integer".equals(paramName)) {
                    Integer intValue = Math.toIntExact((Long)value);
                    setter.invoke(target, intValue);
                    break block11;
                }
                if ("java.lang.Integer".equals(className) && "short".equals(paramName)) {
                    Short shortValue = this.toShortExact(((Integer)value).intValue());
                    setter.invoke(target, shortValue);
                    break block11;
                }
                if ("java.lang.Integer".equals(className) && "java.lang.Short".equals(paramName)) {
                    Short shortValue = this.toShortExact(((Integer)value).intValue());
                    setter.invoke(target, shortValue);
                    break block11;
                }
                throw new SQLException("Cannot set " + propName + ": incompatible types, cannot convert " + className + " to " + paramName);
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
            }
        }
    }

    private boolean isCompatibleType(Object value, Class<?> type) {
        return value == null || type.isInstance(value) || this.matchesPrimitive(type, value.getClass());
    }

    private boolean matchesPrimitive(Class<?> targetType, Class<?> valueType) {
        if (!targetType.isPrimitive()) {
            return false;
        }
        try {
            Field typeField = valueType.getField("TYPE");
            Object primitiveValueType = typeField.get(valueType);
            if (targetType == primitiveValueType) {
                return true;
            }
            this.logger.warn("neni shoda v datovych typech " + targetType + " " + primitiveValueType);
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    protected Method getWriteMethod(Object target, PropertyDescriptor prop, Object value) {
        Method method = prop.getWriteMethod();
        return method;
    }

    protected <T> T newInstance(Class<T> c) throws SQLException {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String propertyName;
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            if ((propertyName = (String)this.columnToPropertyOverrides.get(columnName)) == null) {
                propertyName = columnName;
            }
            for (int i = 0; i < props.length; ++i) {
                if (!propertyName.equalsIgnoreCase(props[i].getName())) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }

    protected Object processColumn(ResultSet rs, int index, Class<?> propType) throws SQLException {
        Object retval = rs.getObject(index);
        if (!propType.isPrimitive() && retval == null) {
            return null;
        }
        for (ColumnHandler handler : columnHandlers) {
            if (!handler.match(propType)) continue;
            retval = handler.apply(rs, index);
            break;
        }
        return retval;
    }

    static {
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

