/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ISBNUtil;
import cz.kpsys.db.StringHandler;
import cz.kpsys.db.StringListHandler;
import cz.kpsys.db.model.ZProxyInput;
import cz.kpsys.db.model.ZProxyOutput;
import cz.kpsys.db.model.v2.IsbnFailure;
import cz.kpsys.db.model.v2.IsbnMap;
import cz.kpsys.kpwin2.services.extzdroje.EBooksUtils;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.RecordExporter;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.KPUtils;
import cz.kpsys.service.Utils;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObalkyProxyExecutor
extends GenericExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ObalkyProxyExecutor.class);
    private final ZProxyInput input;
    private QueryRunner qr;
    private ZProxyOutput output;

    public ObalkyProxyExecutor(DbCore2 core2, ZProxyInput input) {
        this.core2 = core2;
        this.input = input;
        this.qr = core2.obtainQueryRunnerOpened();
    }

    public ZProxyOutput zProxy() {
        if (StringUtils.isNotBlank((CharSequence)this.input.getIsbn())) {
            return this.hled();
        }
        if (this.input.getIdZaz() > 0L) {
            return this.fetch();
        }
        return null;
    }

    ZProxyOutput fetch() {
        ZProxyOutput output = new ZProxyOutput();
        try {
            String data = (String)this.qr.query("SELECT XML_DATA FROM ISBN_ZAZ WHERE ID_ZAZ=?", (ResultSetHandler)new StringHandler(), new Object[]{this.input.getIdZaz()});
            output.setXmlData(data);
        }
        catch (SQLException e) {
            logger.error("P: nacitani zaznamu z cache", (Throwable)e);
        }
        return output;
    }

    synchronized ZProxyOutput hled() {
        ZProxyOutput output = new ZProxyOutput();
        String isbn = ISBNUtil.normalizujISBN((String)this.input.getIsbn()).original();
        long recId = 0L;
        try {
            if (isbn.length() < 9 || isbn.length() > 19 || this.neplatneZnaky(isbn)) {
                return output;
            }
            IsbnFailure isbnFailure = (IsbnFailure)this.qr.query("SELECT * FROM ISBN_FAILURE WHERE ISBN=?", (ResultSetHandler)BeanHandlers.isbnFailureHandler(), new Object[]{isbn});
            if (isbnFailure != null && isbnFailure.getDAT_OPAK().after(Utils.now())) {
                return output;
            }
            IsbnMap isbnMap = (IsbnMap)this.qr.query("SELECT * FROM ISBN_MAP WHERE ISBN=?", (ResultSetHandler)BeanHandlers.isbnMapHandler(), new Object[]{isbn});
            if (isbnMap != null) {
                long fkZaz = isbnMap.getFK_ZAZ();
                output.setRecId(fkZaz);
                List isbns = (List)this.qr.query("SELECT ISBN FROM ISBN_MAP WHERE FK_ZAZ=?", (ResultSetHandler)new StringListHandler(), new Object[]{fkZaz});
                output.getIsbn().add(isbn);
                output.getIsbn().addAll(isbns);
                return output;
            }
            EBooksUtils eBooksUtils = new EBooksUtils(this.core2);
            List<String> seznamISBN = Arrays.asList(isbn);
            Record r = eBooksUtils.zkusNajitZaznamZkem(seznamISBN);
            KPUtils.sleep((int)1000);
            if (r == null) {
                LocalDateTime ldt = LocalDateTime.now().plusHours(12L);
                this.qr.update("UPDATE OR INSERT INTO ISBN_FAILURE (ISBN, DAT_OPAK) VALUES (?,?) MATCHING (ISBN)", new Object[]{isbn, Utils.util2sqlDate((Date)DateConversions.localDateTime2utilDate((LocalDateTime)ldt))});
                return output;
            }
            this.qr.update("DELETE FROM ISBN_FAILURE WHERE ISBN=?", (Object)isbn);
            RecordExporter re = new RecordExporter();
            String xmlData = re.marcXml(r);
            long idZaz = (Long)this.qr.query("INSERT INTO ISBN_ZAZ (XML_DATA) VALUES (?) RETURNING ID_ZAZ", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{xmlData});
            HashSet<String> zaznamIsbn = new HashSet<String>();
            zaznamIsbn.add(isbn);
            for (Field pole20 : r.getFields(20)) {
                String podpoleA = pole20.getOrCreateSubfield("a").getContent();
                if (!StringUtils.isNotBlank((CharSequence)podpoleA)) continue;
                zaznamIsbn.add(ISBNUtil.normalizujISBN((String)podpoleA).original());
            }
            for (String isbnZapis : zaznamIsbn) {
                Long idZazUlozeny = (Long)this.qr.query("SELECT FK_ZAZ FROM ISBN_MAP WHERE ISBN=?", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{isbnZapis});
                if (idZazUlozeny == null) continue;
                this.qr.update("UPDATE ISBN_MAP SET FK_ZAZ=? WHERE FK_ZAZ=?", new Object[]{idZaz, idZazUlozeny});
                this.qr.update("DELETE FROM ISBN_ZAZ WHERE ID_ZAZ=?", (Object)idZazUlozeny);
            }
            for (String isbnZapis : zaznamIsbn) {
                this.qr.update("UPDATE OR INSERT INTO ISBN_MAP (ISBN, FK_ZAZ) VALUES (?,?) MATCHING (ISBN, FK_ZAZ)", new Object[]{isbnZapis, idZaz});
            }
            output.getIsbn().addAll(zaznamIsbn);
            output.setRecId(idZaz);
        }
        catch (SQLException e) {
            logger.error("P: zproxy hledani", (Throwable)e);
        }
        return output;
    }

    private boolean neplatneZnaky(String isbn) {
        return isbn.matches(".*[^0-9x].*");
    }
}

