/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2Helper;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.KontrolaCtenare;
import cz.kpsys.db.KontrolaCtenareHandler;
import cz.kpsys.db.KontrolaCtenarePozrezHandler$;
import cz.kpsys.db.OverRezeExecutor;
import cz.kpsys.db.PozRezExecutorHelper;
import cz.kpsys.db.PozRezExecutorHelper$;
import cz.kpsys.db.PozRezExecutorScala;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.LzeRezervovatExemplarOutput;
import cz.kpsys.db.model.OverRezeInput;
import cz.kpsys.db.model.PozRezInput;
import cz.kpsys.db.model.PozRezOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefPujc;
import cz.kpsys.db.model.v2.DefStatus;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.db.model.v2.PozRez;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.marc.SessionData;
import cz.kpsys.portaro.commons.object.repo.SingleValueRepository;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PozRezExecutor
extends GenericExecutor {
    public static final int ERR18_ZADNE_VALIDNI_PUJCOVNY = 18;
    public static final int ERR17_MULTIPLE_VERBISBOX = 17;
    public static final int ERR16_TIMESLOT_MNOHO_BUDOV = 16;
    public static final int ERR15_TIMESLOT_OBSAZENY = 15;
    public static final int ERR14_REZOBJ_NEVALIDNI_BUDOVA = 14;
    public static final int ERR13_PREKROCEN_LIMIT = 13;
    public static final int ERR12_PROSLA_REGISTRACE = 12;
    public static final int ERR11_TITUL_BYL_JIZ_VYPUJCEN = 11;
    public static final int ERR8_JIZ_VYPUJCENO_POZADOVANO_REZERVOVANO = 8;
    public static final int ERR7_NENI_NA_VALIDNI_BUDOVE = 7;
    public static final int ERR6_NEEXISTUJICI_IDEX = 6;
    public static final int ERR4_CTENAR_VYRAZEN = 4;
    public static final int ERR3_CTENAR_JE_BLOKOVAN = 3;
    public static final int ERR2_CTENAR_NEEXISTUJE = 2;
    public static final int ERR1_EXEMPLAR_NEEXISTUJE = 1;
    private static final Logger logger = LoggerFactory.getLogger(PozRezExecutor.class);
    final PozRezInput input;
    private final boolean povolitObjednavky;
    DefPujc pujcovna;
    private Ctenari cten;
    private Kat1_5 kat1_5;
    private DefStatus status;
    private Kat1_4 kat1_4;
    private DefFond dokFond;

    public PozRezExecutor(DbCore2 core2, PozRezInput input) {
        this.core2 = core2;
        this.input = input;
        this.povolitObjednavky = DbCache2.queryIINIFlagIsTrue((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.KATALOGIZACE_POVOLIT_OBJEDNAVKY(), null, null);
    }

    public static PozRezInput parsePozRezInput(Document doc, DbCore2 core2, SessionData sessionData) throws ParseException, SQLException {
        String HLASIT_JIZ_V_MINULOSTI_PUJCENO;
        Node HLASIT_JIZ_V_MINULOSTI_PUJCENO_EL;
        Node KONTROLOVAT_VYPUJCKU_TITULU_EL;
        Node PUJCOVNY_EL;
        Node PREZ_EL;
        Node ZAJEM_DO_EL;
        Element rootNode = doc.getRootElement();
        PozRezInput pozRezInput = new PozRezInput();
        pozRezInput.idCten = PozRezExecutor.parseCtenTag((Document)doc, (String)"//collection/pozrez/ID_CTEN", (boolean)false);
        pozRezInput.idZaz = Long.parseLong(doc.getRootElement().selectSingleNode("//collection/pozrez/ID_ZAZ").getText());
        pozRezInput.fkUziv = sessionData.getUcode();
        pozRezInput.pujcovna = PozRezExecutor.parsujPujcovnu((Document)doc);
        String prefix = "//collection/pozrez/";
        Node ID_EX_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/ID_EX");
        if (ID_EX_EL != null) {
            String ID_EX = ID_EX_EL.getText();
            pozRezInput.idEx = Long.parseLong(ID_EX);
        }
        if ((ZAJEM_DO_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/ZAJEM_DO")) != null) {
            String ZAJEM_DO = ZAJEM_DO_EL.getText();
            pozRezInput.zajemDo = Utils.sdfSQLDate().parse(ZAJEM_DO);
        }
        if ((PREZ_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/PREZ")) != null) {
            String PREZ = PREZ_EL.getText();
            pozRezInput.lzePrez = PozRezExecutor.tagHasTrueValue((String)PREZ);
        }
        @NotNull Set seznamPujcovenCtenare = PozRezExecutor.seznamPujcovenCtenare((Integer)pozRezInput.idCten, (Short)pozRezInput.pujcovna, (boolean)false);
        pozRezInput.seznamPredanychPujcovenPrazdny = true;
        Node BUDOVY_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/BUDOVY");
        if (BUDOVY_EL != null) {
            pozRezInput.seznamPredanychPujcovenPrazdny = false;
            String BUDOVY = BUDOVY_EL.getText();
            pozRezInput.pujcovny.addAll(PozRezExecutor.parsePujcovny((String)BUDOVY, (Set)seznamPujcovenCtenare));
        }
        if ((PUJCOVNY_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/PUJCOVNY")) != null) {
            pozRezInput.seznamPredanychPujcovenPrazdny = false;
            String PUJCOVNY = PUJCOVNY_EL.getText();
            pozRezInput.pujcovny.addAll(PozRezExecutor.parsePujcovny((String)PUJCOVNY, (Set)seznamPujcovenCtenare));
        }
        if (pozRezInput.pujcovny.isEmpty() && !pozRezInput.seznamPredanychPujcovenPrazdny) {
            throw new AppServerStatus("prunik povolenych pujcoven ctenare a pozadovanych pujcoven je prazdna mnozina", 18);
        }
        Node IP_ADRESA_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/IP_ADRESA");
        if (IP_ADRESA_EL != null) {
            String IP_ADRESA;
            pozRezInput.ipAdresa = IP_ADRESA = IP_ADRESA_EL.getText();
        }
        if ((KONTROLOVAT_VYPUJCKU_TITULU_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/KONTROLOVAT_VYPUJCKU_TITULU")) != null) {
            String KONTROLOVAT_VYPUJCKU_TITULU = KONTROLOVAT_VYPUJCKU_TITULU_EL.getText();
            if (pozRezInput.idEx > 0L) {
                pozRezInput.kontrolovatVypujckuTitulu = PozRezExecutor.tagHasTrueValue((String)KONTROLOVAT_VYPUJCKU_TITULU);
            }
        }
        if ((HLASIT_JIZ_V_MINULOSTI_PUJCENO_EL = doc.getRootElement().selectSingleNode("//collection/pozrez/HlasitJizVMinulostiPujceno")) != null && PozRezExecutor.tagHasTrueValue((String)(HLASIT_JIZ_V_MINULOSTI_PUJCENO = HLASIT_JIZ_V_MINULOSTI_PUJCENO_EL.getText()))) {
            pozRezInput.hlasitJizVMinulostiPujceno = true;
        }
        List slotyNodes = rootNode.selectNodes("//collection/pozrez/SLOTY/SLOT");
        slotyNodes.forEach(node -> pozRezInput.sloty.add(node.getText()));
        return pozRezInput;
    }

    protected void nactiUdaje() throws AppServerStatus {
        block4: {
            try {
                this.cten = PozRezExecutor.nactiCtenare((int)this.input.idCten);
                this.kat1_4 = DbCore2Utils.nactiKat1_4((long)this.input.idZaz, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
                this.dokFond = PozRezExecutor.nactiDokFond((short)this.kat1_4.getFK_DOKFOND());
                this.ctenKat = PozRezExecutor.nactiCtenKat((String)this.cten.getFK_CTENKAT());
                if (this.input.idEx != 0L) {
                    this.kat1_5 = DbCore2Utils.nactiKat1_5((long)this.input.idEx, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
                    this.vypKat = this.nactiVypKat(this.kat1_5.getFK_VYPKAT());
                    this.status = this.nactiStatus(this.kat1_5.getFK_STATUS());
                }
            }
            catch (SQLException e) {
                logger.error("selhani", (Throwable)e);
                if (this.kat1_5 == null) {
                    throw new AppServerStatus("exemplar neexistuje, ID: " + this.input.idEx, 1);
                }
                if (this.cten != null) break block4;
                throw new AppServerStatus("ctenar neexistuje, ID: " + this.input.idCten, 2);
            }
        }
    }

    public PozRezOutput pozRez() throws AppServerStatus, SQLException {
        PozRezOutput pozRezOutput = new PozRezOutput();
        if (this.input.idZaz == 0L && this.input.idCten == 0 || !DbCache2Helper.jeIdCtenValidni((Integer)this.input.idCten)) {
            throw new SQLException("chybny vstup, ID_ZAZ=0 nebo ID_CTEN=0 nebo uzivatel neni ctenar");
        }
        this.initVirtualniPujcovny(null, this.input.pujcovny);
        this.qr = this.core2.obtainQueryRunnerOpened();
        this.nactiUdaje();
        KontrolaCtenare.kontrolaCtenare((Ctenari)this.cten, (KontrolaCtenareHandler)KontrolaCtenarePozrezHandler$.MODULE$);
        SingleValueRepository dateRangeRepository = (SingleValueRepository)KPWINServiceApplication.applicationContext.getBean("dateRangeRepository");
        PozRezExecutorScala pozRezExecutorScala = new PozRezExecutorScala(this.core2, this.input, dateRangeRepository);
        PozRezExecutorHelper.kontrolaVerbisBoxPujcovny((List)this.input.pujcovny);
        if (this.dokFond.isJE_PERIO() || this.input.idEx > 0L) {
            if (this.input.idEx == 0L) {
                throw new AppServerStatus("nelze pujcit perio bez znalosti ID_EX " + this.input.idEx, 5);
            }
            if (this.kat1_5 == null) {
                throw new AppServerStatus("neexistujici ID_EX " + this.input.idEx, 6);
            }
            if (this.input.hlasitJizVMinulostiPujceno && this.jizVypujcenoVMinulostiExemplar(this.kat1_5.getID_EX(), this.input.idCten)) {
                throw new AppServerStatus("jiz vypujceno v minulosti", 11);
            }
            if (!(this.input.seznamPredanychPujcovenPrazdny || this.input.pujcovny.contains(this.kat1_5.getFK_PUJC()) || GenericExecutorScala.jeMoznyPresunNaVirtualniPujcovnu((Kat1_5)this.kat1_5, (Set)this.bratZ, (Set)this.posilatNa, (List)this.input.pujcovnyAsShortList()))) {
                throw new AppServerStatus("neni na validni budove " + this.kat1_5.getFK_PUJC(), 7);
            }
            OverRezeInput overRezeInput = new OverRezeInput();
            overRezeInput.idEx = this.input.idEx;
            overRezeInput.fkUzivCten = this.input.idCten;
            overRezeInput.nekontrolovatVyp = false;
            overRezeInput.idPozRez = 0L;
            overRezeInput.fkPujcovna = this.input.pujcovna;
            overRezeInput.zkopirujUdajeZExemplare(this.kat1_5);
            overRezeInput.kontrolovatVypujckuTitulu = this.input.kontrolovatVypujckuTitulu;
            OverRezeExecutor overRezeExecutor = new OverRezeExecutor(this.core2, overRezeInput);
            LzeRezervovatExemplarOutput output = overRezeExecutor.lzeRezervovatExemplar();
            PozRezExecutorHelper$.MODULE$.odstranVyjimkyPriPozRezRezervuj(output);
            output.incrementErrorCodeBy(50);
            PozRez pozRez = new PozRez();
            long fkZaz = RecordIdCache.getByRecordId((String)this.kat1_5.getRECORD_ID()).cisZaz();
            pozRez.setFK_ZAZ(fkZaz);
            pozRez.setFK_EX(Long.valueOf(this.input.idEx));
            pozRez.setFK_UZIV_CTEN(this.input.idCten);
            pozRez.setZAJEM_DO(this.input.zajemDo);
            pozRez.setPUJCOVNY(this.input.pujcovnyOddeleneStredniky());
            pozRez.setIP_ADDR(this.input.ipAdresa);
            pozRezOutput.pozrezId = PozRezExecutor.insertIntoPozRez((QueryRunnerOpened)((QueryRunnerOpened)this.qr), (PozRez)pozRez);
            pozRezExecutorScala.kontrolaPoctuRezervaci(this.input.idCten, this.ctenKat, this.input, pozRezOutput, this.core2);
            return pozRezOutput;
        }
        if (!this.input.sloty.isEmpty()) {
            pozRezOutput.pozrezId = pozRezExecutorScala.pozRezSloty();
            return pozRezOutput;
        }
        if (this.jeTitulVypRezPoz(this.input.idZaz, this.input.idCten)) {
            throw new AppServerStatus("je jiz vypujceno,pozadovano,rezervovano", 8);
        }
        if (this.input.hlasitJizVMinulostiPujceno && this.jizVypujcenoVMinulostiTitul(this.input.idZaz, this.input.idCten)) {
            throw new AppServerStatus("jiz vypujceno v minulosti", 11);
        }
        HashMap exempVypuc = this.nactiVsechnyExemplareAVypujcky(this.input.idZaz);
        Kat1_5 rezervovatelnyTitul = null;
        boolean pozadovanaVirtualniBudova = this.pozadovanaVirtualniPujcovna(this.input.pujcovny);
        for (Kat1_5 exemplar : exempVypuc.keySet()) {
            boolean jeMoznyPresunNaVirtualniBudovu;
            if (PozRezExecutor.preskocitExemplar((Ctenari)this.cten, (Kat1_5)exemplar, (Boolean)this.input.lzePrez)) continue;
            boolean bl = jeMoznyPresunNaVirtualniBudovu = GenericExecutorScala.jeMoznyPresunNaVirtualniPujcovnu((Kat1_5)exemplar, (Set)this.bratZ, (Set)this.posilatNa, (List)this.input.pujcovnyAsShortList()) && pozadovanaVirtualniBudova;
            if (!jeMoznyPresunNaVirtualniBudovu && !this.jePujcovnaVSeznamuPujcoven(exemplar.getFK_PUJC(), this.input.pujcovny)) continue;
            OverRezeInput overRezeInput = new OverRezeInput();
            overRezeInput.idEx = exemplar.getID_EX();
            overRezeInput.fkUzivCten = this.input.idCten;
            overRezeInput.nekontrolovatVyp = true;
            overRezeInput.idPozRez = 0L;
            overRezeInput.fkPujcovna = this.input.pujcovna;
            overRezeInput.fkLokace = exemplar.getFK_LOKACE();
            overRezeInput.fkStatus = exemplar.getFK_STATUS();
            overRezeInput.fkZpnab = exemplar.getFK_ZPNAB();
            overRezeInput.fkTempskup = exemplar.getFK_TEMSKUP();
            overRezeInput.fkVypkat = exemplar.getFK_VYPKAT();
            overRezeInput.setIngorovatVyjimkyNelzePujc(true);
            OverRezeExecutor overRezeExecutor = new OverRezeExecutor(this.core2, overRezeInput);
            LzeRezervovatExemplarOutput output = overRezeExecutor.lzeRezervovatExemplar();
            this.smazVyjimkyCoNebraniRezervovat(output);
            if (!output.vyjimky.isEmpty() || output.lzeReze.isEmpty() && output.lzeObjed.isEmpty() || !output.lzeObjed.isEmpty() && !this.povolitObjednavky) continue;
            if (exempVypuc.get(exemplar) != null) {
                rezervovatelnyTitul = exemplar;
                continue;
            }
            if (!this.povolitObjednavky && !output.lzePohlizetJakoNaRezervovany) {
                throw new AppServerStatus("nelze objednat (rezervovat volne)", 9);
            }
            PozRez pozRez = new PozRez();
            pozRez.setFK_ZAZ(this.input.idZaz);
            pozRez.setFK_EX(null);
            pozRez.setFK_UZIV_CTEN(this.input.idCten);
            pozRez.setZAJEM_DO(this.input.zajemDo);
            pozRez.setLZE_PREZ((short)(this.input.lzePrez ? 1 : 0));
            if (!this.input.seznamPredanychPujcovenPrazdny) {
                pozRez.setPUJCOVNY(this.input.pujcovnyOddeleneStredniky());
            }
            pozRez.setIP_ADDR(this.input.ipAdresa);
            pozRezOutput.pozrezId = PozRezExecutor.insertIntoPozRez((QueryRunnerOpened)((QueryRunnerOpened)this.qr), (PozRez)pozRez);
            pozRezExecutorScala.kontrolaPoctuRezervaci(this.input.idCten, this.ctenKat, this.input, pozRezOutput, this.core2);
            return pozRezOutput;
        }
        if (rezervovatelnyTitul == null) {
            throw new AppServerStatus("titul nelze rezervovat", 10);
        }
        PozRez pozRez = new PozRez();
        pozRez.setFK_ZAZ(this.input.idZaz);
        pozRez.setFK_EX(null);
        pozRez.setFK_UZIV_CTEN(this.input.idCten);
        pozRez.setZAJEM_DO(this.input.zajemDo);
        pozRez.setPUJCOVNY(this.input.pujcovnyOddeleneStredniky());
        pozRez.setIP_ADDR(this.input.ipAdresa);
        pozRez.setLZE_PREZ((short)(this.input.lzePrez ? 1 : 0));
        pozRezOutput.pozrezId = PozRezExecutor.insertIntoPozRez((QueryRunnerOpened)((QueryRunnerOpened)this.qr), (PozRez)pozRez);
        pozRezExecutorScala.kontrolaPoctuRezervaci(this.input.idCten, this.ctenKat, this.input, pozRezOutput, this.core2);
        return pozRezOutput;
    }

    private void smazVyjimkyCoNebraniRezervovat(LzeRezervovatExemplarOutput output) {
        output.smazVyjimku(new int[]{15, 24, 25, 23});
    }

    private boolean jizVypujcenoVMinulostiTitul(long idZaz, int idCten) throws SQLException {
        return ((Number)this.qr.query("SELECT COUNT(*) FROM VYPUC2 WHERE FK_UZIV_CTEN=? AND FK_ZAZ=? AND DAT_VR IS NOT NULL", (ResultSetHandler)new ScalarHandler(), new Object[]{idCten, idZaz})).intValue() > 0;
    }

    private boolean jizVypujcenoVMinulostiExemplar(long idEx, int idCten) throws SQLException {
        return ((Number)this.qr.query("SELECT COUNT(*) FROM VYPUC2 WHERE FK_UZIV_CTEN=? AND FK_EX=? AND DAT_VR IS NOT NULL", (ResultSetHandler)new ScalarHandler(), new Object[]{idCten, idEx})).intValue() > 0;
    }

    private boolean jeTitulVypRezPoz(long idZaz, int idCten) throws SQLException {
        if (((Number)this.qr.query("SELECT COUNT(*) FROM VYPUC WHERE FK_UZIV_CTEN=? AND FK_ZAZ=? AND FK_TYPPUJC!=3", (ResultSetHandler)new ScalarHandler(), new Object[]{idCten, idZaz})).intValue() > 0) {
            return true;
        }
        return ((Number)this.qr.query("SELECT COUNT(*) FROM POZ_REZ WHERE FK_UZIV_CTEN=? AND FK_ZAZ=? AND DAT_REZ IS NULL AND FK_VYPUC IS NOT NULL", (ResultSetHandler)new ScalarHandler(), new Object[]{idCten, idZaz})).intValue() > 0;
    }

    private boolean jePujcovnaVSeznamuPujcoven(Short fk_PUJC_EX, List<Short> pujcovny) {
        if (pujcovny.size() == 0) {
            return true;
        }
        if (fk_PUJC_EX == null) {
            return false;
        }
        for (short pujcovna : pujcovny) {
            if (!DbCache.nadrazenePujcVcetneJavaShort((Short)pujcovna).contains(fk_PUJC_EX)) continue;
            return true;
        }
        return false;
    }

    public static Long insertIntoPozRez(QueryRunnerOpened qr, PozRez pozRez) throws SQLException {
        return qr.queryUOI(ProxoolUtil.engine() == DatabaseEngine.FIREBIRD, "INSERT INTO POZ_REZ (FK_ZAZ, FK_EX, FK_UZIV_CTEN, DAT_POZ, DAT_REZ, ZAJEM_DO, PUJCOVNY, FK_VYPUC, IP_ADDR, LZE_PREZ) VALUES (?,?,?,?,?,?,?,?,?,?) RETURNING ID_POZREZ", new Object[]{pozRez.getFK_ZAZ(), pozRez.getFK_EX(), pozRez.getFK_UZIV_CTEN(), Utils.util2sqlDate((Date)Utils.now()), Utils.util2sqlDate((Date)pozRez.getDAT_REZ()), Utils.util2sqlDate((Date)pozRez.getZAJEM_DO()), pozRez.getPUJCOVNY(), pozRez.getFK_VYPUC(), pozRez.getIP_ADDR(), pozRez.getLZE_PREZ()});
    }
}

