/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.BigDecimalHandler;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.RegistraceInput;
import cz.kpsys.db.model.RegistraceOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenKat;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.Utils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegistraceExecutor
extends GenericExecutor {
    private static final int ERR_2_KATEGORIE_CTENARE_NEPLATNA = 2;
    private static final int ERR_1_CTENAR_NEEXISTUJE = 1;
    private static final Logger logger = LoggerFactory.getLogger(RegistraceExecutor.class);
    final RegistraceInput input;
    private RegistraceOutput output;

    public RegistraceExecutor(DbCore2 core2, RegistraceInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static RegistraceInput parseRegistraceInput(Document doc, DbCore2 core2) throws ParseException, SQLException {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/registrace/";
        RegistraceInput registraceInput = new RegistraceInput();
        registraceInput.idUzivCten = RegistraceExecutor.parseCtenTag((Document)doc, (String)"//collection/registrace/ID_CTEN", (boolean)false);
        return registraceInput;
    }

    public RegistraceOutput registrace() throws AppServerStatus, SQLException {
        this.output = new RegistraceOutput();
        this.qr = this.core2.obtainQueryRunnerOpened();
        Ctenari cten = DbCore2Utils.nactiCtenare((Integer)this.input.idUzivCten, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        if (cten == null) {
            AppServerStatus ase = new AppServerStatus("ctenar neexistuje", 1);
            ase.addReturnValue("ID_CTEN", Integer.toString(this.input.idUzivCten));
            throw ase;
        }
        if (cten.getDATP_REG() == null) {
            this.output.setDatPReg(Utils.today());
        } else {
            this.output.setDatPReg(cten.getDATP_REG());
        }
        DefCtenKat ctenKat = (DefCtenKat)((Map)DbCache2NG.ctenKatMap().get()).get(cten.getFK_CTENKAT());
        if (ctenKat == null) {
            AppServerStatus ase = new AppServerStatus("kategorie ctenare je neplatna", 2);
            ase.addReturnValue("FK_CTENKAT", cten.getFK_CTENKAT());
            throw ase;
        }
        Short pujcovna = cten.getFK_PUJC();
        String zacReg = DbCache2.queryINIFlag((String)"CTEN", (String)"ZAC_REG", (Short)pujcovna, null);
        String datReg = DbCache2.queryINIFlag((String)"CTEN", (String)"DAT_REG", (Short)pujcovna, null);
        if ("ODZAPL".equalsIgnoreCase(zacReg)) {
            this.output.setDatReg(Utils.today());
        } else if ("ODPREG".equalsIgnoreCase(zacReg)) {
            Calendar cal = Calendar.getInstance();
            Date konReg = cten.getKON_REG();
            if (konReg == null) {
                cal.setTime(Utils.today());
            } else {
                cal.setTime(cten.getKON_REG());
                cal.add(5, 1);
            }
            this.output.setDatReg(cal.getTime());
        } else if ("ODDATA".equalsIgnoreCase(zacReg)) {
            if (StringUtils.isNotBlank((CharSequence)datReg)) {
                try {
                    this.output.setDatReg(Utils.sdfSQLDate().parse(datReg));
                }
                catch (ParseException pe) {
                    this.output.setDatReg(Utils.today());
                }
            } else {
                this.output.setDatReg(Utils.today());
            }
        }
        String datumDo = ctenKat.getDATUM_DO();
        if (StringUtils.isNotBlank((CharSequence)datumDo)) {
            Calendar cal = Calendar.getInstance();
            Date today = Utils.today();
            cal.set(today.getYear() + 1900, Integer.parseInt(datumDo.substring(2, 4)) - 1, Integer.parseInt(datumDo.substring(0, 2)), 0, 0, 0);
            if (today.after(cal.getTime())) {
                cal.add(1, 1);
            }
            this.output.setKonReg(cal.getTime());
        } else {
            short dobaReg = ctenKat.getDOBA_REG();
            LocalDate initialDate = "ODDATA".equalsIgnoreCase(zacReg) ? DateConversions.utilDate2localDateTime((Date)this.output.getDatReg()).toLocalDate() : ("ODPREG".equalsIgnoreCase(zacReg) ? DateConversions.utilDate2localDate((Date)this.output.getDatReg()) : LocalDate.now());
            LocalDate endDate = dobaReg == -1 ? initialDate.plusYears(1L) : initialDate.plusMonths(dobaReg);
            this.output.setKonReg(DateConversions.localDate2utilDate((LocalDate)endDate));
        }
        BigDecimal castka = (BigDecimal)this.qr.query("SELECT SUM(CASTKA) FROM PLATBY WHERE VRACENO IS NULL AND FK_UZIV_VLASTNIK=? AND FK_POPL=5 AND NOT (CASTKA>0 AND DATUM=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + ")", (ResultSetHandler)new BigDecimalHandler(), new Object[]{this.input.idUzivCten});
        BigDecimal regPopl = ctenKat.getREG_POPL();
        castka = castka.compareTo(BigDecimal.ZERO) < 0 && castka.abs().compareTo(regPopl) < 0 ? regPopl.add(castka) : (castka.compareTo(BigDecimal.ZERO) >= 0 ? regPopl : BigDecimal.ZERO);
        this.output.setCastka(castka);
        return this.output;
    }
}

