/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.db.DbCore2;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.SpravceAutoritnichVazebHelper;
import cz.kpsys.db.VazbaInfo;
import cz.kpsys.db.model.v2.AutVazby;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.SubField;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpravceAutoritnichVazeb {
    static final Logger logger = LoggerFactory.getLogger(SpravceAutoritnichVazeb.class);
    private final DbCore2 core2;
    private final List<VazbaInfo> vazbyKOvereni = new LinkedList();
    private final Record r;
    private final long origAuthID;
    private final int origAuthFond;
    private final QueryRunner qr;
    private final String origAuthIDString;
    private final SpravceAutoritnichVazebHelper helper;
    private List<AutVazby> seznamVazeb;

    public SpravceAutoritnichVazeb(Record r, DbCore2 core2) {
        this.core2 = core2;
        this.r = r;
        this.origAuthID = r.getId();
        this.origAuthFond = r.getFond();
        this.origAuthIDString = Integer.toString(this.origAuthFond) + this.origAuthID;
        this.qr = core2.obtainQueryRunnerOpened();
        this.helper = new SpravceAutoritnichVazebHelper(core2, this.origAuthID, this.origAuthIDString);
    }

    private List<AutVazby> nactiSeznamStarychVazeb() throws SQLException {
        LinkedList<AutVazby> seznamVazeb = new LinkedList<AutVazby>();
        seznamVazeb.addAll((Collection)this.qr.query("SELECT * FROM AUT_VAZBY WHERE FK_AUTNAD=? OR FK_AUTPOD=?", (ResultSetHandler)new KPSYSBeanListHandler(AutVazby.class), new Object[]{this.origAuthID, this.origAuthID}));
        return seznamVazeb;
    }

    private List<AutVazby> pripravSeznamVazeb() {
        long zapisovanaAutorita = this.r.getFkZaz();
        int poradi = 0;
        LinkedList<AutVazby> autoritniVazby = new LinkedList<AutVazby>();
        HashSet<Long> autorityZminovane = new HashSet<Long>();
        List pole5XX = this.r.getXXXFieldsWithNumberStarting("5");
        for (Field f : pole5XX) {
            String wCont;
            long idAutority;
            int fondAutority;
            SubField podPoleW = f.getFirstSubfield("w");
            String odkazString = f.najdiOdkazNaAutoritu();
            if (StringUtils.isEmpty((CharSequence)odkazString)) continue;
            try {
                fondAutority = Integer.parseInt(odkazString.substring(0, 2));
                idAutority = Long.parseLong(odkazString.substring(2));
            }
            catch (NumberFormatException nfe) {
                logger.warn("pripravSeznamVazeb NFE", (Throwable)nfe);
                continue;
            }
            if (idAutority == 0L) {
                logger.warn("vazba na autoritu s ID=0 neni pripustna");
                continue;
            }
            if (idAutority == zapisovanaAutorita) {
                logger.warn("pokus o zapsani vazby viz. tez./NADPOD na stejnou autoritu " + this.r.getId());
                continue;
            }
            String content = "";
            if (podPoleW != null && ("g".equals(wCont = podPoleW.getContent()) || "h".equals(wCont))) {
                content = wCont;
            }
            if (StringUtils.isNotBlank((CharSequence)content)) {
                AutVazby autVazby = new AutVazby();
                VazbaInfo vazbaInfo = new VazbaInfo();
                vazbaInfo.sourceFieldNumber = f.getNumber();
                vazbaInfo.typNadr = 0;
                this.vazbyKOvereni.add(vazbaInfo);
                boolean tatoJePod = content.equals("g");
                if (tatoJePod) {
                    autVazby.FK_AUTPOD = zapisovanaAutorita;
                    autVazby.FK_AUTNAD = idAutority;
                    autVazby.PORADI = poradi++;
                    autVazby.TYP_NADR = 0;
                    autoritniVazby.add(autVazby);
                    vazbaInfo.destAuthID = autVazby.FK_AUTNAD;
                    autorityZminovane.add(autVazby.FK_AUTNAD);
                    continue;
                }
                autVazby.FK_AUTNAD = zapisovanaAutorita;
                autVazby.FK_AUTPOD = idAutority;
                autVazby.PORADI = poradi++;
                autVazby.TYP_NADR = 0;
                autoritniVazby.add(autVazby);
                vazbaInfo.destAuthID = autVazby.FK_AUTPOD;
                autorityZminovane.add(autVazby.FK_AUTPOD);
                continue;
            }
            int poradiTemp = poradi++;
            AutVazby autVazby = new AutVazby();
            autVazby.FK_AUTNAD = zapisovanaAutorita;
            autVazby.FK_AUTPOD = idAutority;
            autVazby.PORADI = poradiTemp;
            autVazby.TYP_NADR = 1;
            autoritniVazby.add(autVazby);
            autVazby = new AutVazby();
            autVazby.FK_AUTPOD = zapisovanaAutorita;
            autVazby.FK_AUTNAD = idAutority;
            autVazby.PORADI = poradiTemp;
            autVazby.TYP_NADR = 1;
            autoritniVazby.add(autVazby);
            VazbaInfo vazbaInfo = new VazbaInfo();
            vazbaInfo.destAuthID = idAutority;
            vazbaInfo.sourceFieldNumber = f.getNumber();
            vazbaInfo.typNadr = 1;
            if (fondAutority != this.r.getFond()) {
                vazbaInfo.rozdilneFondyNezapisovat = true;
            }
            this.vazbyKOvereni.add(vazbaInfo);
            autorityZminovane.add(idAutority);
        }
        HashSet<Long> odkazovaneAutority = new HashSet<Long>();
        for (Field f : this.r.getFields()) {
            for (SubField sf : f.getSubfields()) {
                long fkAuth = sf.getAuthLinkID();
                if (fkAuth <= 0L || autorityZminovane.contains(fkAuth)) continue;
                odkazovaneAutority.add(fkAuth);
            }
        }
        for (Long fkAuth : odkazovaneAutority) {
            AutVazby autVazby = new AutVazby();
            autVazby.FK_AUTNAD = zapisovanaAutorita;
            autVazby.FK_AUTPOD = fkAuth;
            autVazby.TYP_NADR = (short)2;
            autoritniVazby.add(autVazby);
        }
        return autoritniVazby;
    }

    public void zpracujAZapisAutoritniVazby() throws SQLException {
        this.seznamVazeb = this.pripravSeznamVazeb();
        this.helper.overVazby(this.seznamVazeb);
    }
}

