/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GeneratorKlicu;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.model.VyberKliceInput;
import cz.kpsys.db.model.VyberKliceOutput;
import cz.kpsys.db.model.v2.Kat1_2;
import cz.kpsys.db.model.v2.ZpusobKlicovani;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VyberKliceExecutor
extends GenericExecutor {
    private static final Logger logger = LoggerFactory.getLogger(VyberKliceExecutor.class);
    private final VyberKliceInput input;
    private VyberKliceOutput output;

    public VyberKliceExecutor(DbCore2 core2, VyberKliceInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static VyberKliceInput parseVyberKliceInput(Document doc) throws SQLException {
        VyberKliceInput input = new VyberKliceInput();
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/vyber_klice/";
        Node textNode = rootNode.selectSingleNode("//collection/vyber_klice/TEXT");
        if (textNode == null) {
            throw new SQLException("chybejici element TEXT");
        }
        input.slova = textNode.getText();
        Node klicovaniNode = rootNode.selectSingleNode("//collection/vyber_klice/KLICOVANI");
        if (klicovaniNode == null) {
            input.zpusobKlicovani = ZpusobKlicovani.STANDARD;
        } else {
            String klicovaniString = klicovaniNode.getText().toUpperCase();
            if ("STANDARD".equals(klicovaniString)) {
                input.zpusobKlicovani = ZpusobKlicovani.STANDARD;
            } else if ("ISBN".equals(klicovaniString)) {
                input.zpusobKlicovani = ZpusobKlicovani.ISBN_ISSN;
            } else if ("MEZERY".equals(klicovaniString)) {
                input.zpusobKlicovani = ZpusobKlicovani.JEDNOTLIVA_SLOVA;
            } else if ("CELEK".equals(klicovaniString)) {
                input.zpusobKlicovani = ZpusobKlicovani.JAKO_CELEK;
            } else {
                throw new SQLException("neznamy zpusob klicovani " + klicovaniString);
            }
        }
        input.pole = VyberKliceExecutor.parseTag((Document)doc, (String)"//collection/vyber_klice/POLE", null);
        return input;
    }

    protected void zpracujStandard(VyberKliceInput input) {
        String slova = input.slova;
        slova = this.zpracujSlovaVUvozovkach(slova);
        GeneratorKlicu generatorKlicu = new GeneratorKlicu(this.core2, new Record());
        Field f = new Field(0);
        boolean opakovani = false;
        ArrayList kliceList = new ArrayList();
        generatorKlicu.oklicuj(input.zpusobKlicovani, slova, f, kliceList, kliceList, false, 0, "");
        LinkedList klice = generatorKlicu.getKlice();
        for (Kat1_2 kat1_2 : klice) {
            this.output.addSlovo(StringUtils.lowerCase((String)kat1_2.UTF_KLIC));
        }
        this.escapeKlicovaLuceneSlova(this.output.slova);
    }

    public VyberKliceOutput vyberKlice() {
        this.output = new VyberKliceOutput();
        if (this.input.pole != null) {
            if (this.input.pole.equalsIgnoreCase("P80")) {
                this.output.slova.add(QueryParser.escape((String)this.input.slova.replace(" ", "\\ ")));
            } else {
                this.zpracujStandard(this.input);
            }
        } else {
            this.zpracujStandard(this.input);
        }
        return this.output;
    }

    private void escapeKlicovaLuceneSlova(List<String> slova) {
        for (int i = 0; i < slova.size(); ++i) {
            String slovo = slova.get(i);
            if (slovo.startsWith("\"") && slovo.endsWith("\"")) continue;
            if (slovo.equalsIgnoreCase("AND") || slovo.equalsIgnoreCase("OR") || slovo.equalsIgnoreCase("NOT")) {
                slova.set(i, StringUtils.lowerCase((String)slovo));
                continue;
            }
            slova.set(i, QueryParser.escape((String)slovo));
        }
    }

    private String zpracujSlovaVUvozovkach(String slova) {
        Pattern p = Pattern.compile("\"([^\"]*)\"");
        Matcher m = p.matcher(slova);
        while (m.find()) {
            this.output.addSlovo("\"" + m.group(1) + "\"");
        }
        return m.replaceAll("");
    }
}

