/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.ZjistiPokutyInput;
import cz.kpsys.db.model.ZjistiPokutyOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenKat;
import cz.kpsys.db.model.v2.DefCtenVyp;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.RecordDbBean;
import cz.kpsys.db.model.v2.Uzivatele;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.service.Utils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZjistiPokutyExecutor
extends GenericExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ZjistiPokutyExecutor.class);
    private final ZjistiPokutyInput input;
    private QueryRunner qr;
    private ZjistiPokutyOutput output;
    private Uzivatele uzivatel;

    public ZjistiPokutyExecutor(DbCore2 core2, ZjistiPokutyInput input) {
        this.core2 = core2;
        this.input = input;
        this.qr = core2.obtainQueryRunnerOpened();
        this.output = new ZjistiPokutyOutput();
    }

    public static ZjistiPokutyInput parseZjistiPokutyInput(Document doc) throws AppServerStatus {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/zjisti_pokuty/";
        ZjistiPokutyInput zjistiPokutyInput = new ZjistiPokutyInput();
        zjistiPokutyInput.datumGen = Utils.today();
        zjistiPokutyInput.idPujc = Short.parseShort(ZjistiPokutyExecutor.parseTag((Document)doc, (String)"//collection/zjisti_pokuty/PUJCOVNA", (String)"0"));
        try {
            zjistiPokutyInput.idCten = ZjistiPokutyExecutor.parseCtenTag((Document)doc, (String)"//collection/zjisti_pokuty/ID_CTEN", (boolean)false);
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("v elementu ID_CTEN neni platna hodnota");
        }
        String datumString = null;
        try {
            datumString = ZjistiPokutyExecutor.parseTag((Document)doc, (String)"//collection/zjisti_pokuty/DATUM_GEN", (String)"");
            if (StringUtils.isNotBlank((CharSequence)datumString)) {
                zjistiPokutyInput.datumGen = Utils.sdfSQLDate().parse(datumString);
            }
        }
        catch (ParseException e) {
            logger.error("ParseException", (Throwable)e);
            throw new AppServerStatus("datum zadan v nespravnem tvaru: " + datumString, 106);
        }
        return zjistiPokutyInput;
    }

    private void zjistiPokutuVraceni(Vypuc vypuc) throws SQLException, AppServerStatus {
        if (vypuc.getCIS_REZE() == null || vypuc.getCIS_REZE() > 0) {
            return;
        }
        this.vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(vypuc.getFK_VYPKAT());
        this.ctenVyp = ZjistiPokutyExecutor.nactiKombinaciCtenKatVypKat((DefCtenKat)this.ctenKat, (DefVypKat)this.vypKat);
        String recordId = vypuc.getRECORD_ID();
        if (!StringUtils.equals((CharSequence)recordId, (CharSequence)RecordDbBean.RECORD_ZERO_ID) && vypuc.getCIS_REZE() != null && vypuc.getCIS_REZE() == 0) {
            String nazev;
            Kat1_4 kat1_4 = DbCore2Utils.nactiKat1_4((String)recordId, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            BigDecimal castkaPokuty = GenericExecutorScala.spoctuPokutu((DefCtenVyp)this.ctenVyp, (short)vypuc.getFK_PUJC(), (short)kat1_4.getFK_DOKFOND(), (Date)vypuc.getDAT_PROL(), (int)vypuc.getDOB_VYP().shortValue());
            ZjistiPokutyOutput.VypujckaPokutaInfo info = new ZjistiPokutyOutput.VypujckaPokutaInfo(this.output);
            info.castka = castkaPokuty;
            this.output.celkovaCastka = this.output.celkovaCastka.add(castkaPokuty);
            info.nazev = nazev = kat1_4.getNAZEV();
            info.idVypuc = vypuc.getFK_VYPUC();
            this.output.pokuty.add(info);
            ++this.output.pocetPokut;
        }
    }

    public ZjistiPokutyOutput zjistiPokuty() throws SQLException, AppServerStatus {
        boolean jeCtenar;
        boolean bl = jeCtenar = (Integer)this.qr.query("SELECT COUNT(*) FROM CTENARI WHERE FK_UZIV=?", (ResultSetHandler)BeanHandlers.INTEGER_HANDLER(), new Object[]{this.input.idCten}) > 0;
        if (jeCtenar) {
            HashSet<Short> seznamPujcoven = new HashSet<Short>();
            if (this.input.idPujc > 0) {
                seznamPujcoven.add(this.input.idPujc);
            }
            List vypujckyCtenare = (List)this.qr.query("SELECT * FROM VYPUC WHERE FK_UZIV_CTEN=? AND CIS_REZE=0", (ResultSetHandler)new KPSYSBeanListHandler(Vypuc.class), new Object[]{this.input.idCten});
            if (seznamPujcoven.size() > 0) {
                this.odfiltrujDlePujcoven(seznamPujcoven, vypujckyCtenare);
            }
            Ctenari cten = ZjistiPokutyExecutor.nactiCtenare((int)this.input.idCten);
            this.ctenKat = ZjistiPokutyExecutor.nactiCtenKat((String)cten.getFK_CTENKAT());
            this.output.pocetVypujcek = vypujckyCtenare.size();
            for (Vypuc vypujcka : vypujckyCtenare) {
                this.zjistiPokutuVraceni(vypujcka);
            }
        }
        return this.output;
    }

    private void odfiltrujDlePujcoven(Set<Short> seznamPujcoven, List<Vypuc> vypujckyCtenare) {
        HashSet<Vypuc> kOdstraneni = new HashSet<Vypuc>();
        for (Vypuc vypujcka : vypujckyCtenare) {
            if (seznamPujcoven.contains(vypujcka.getFK_PUJC())) continue;
            kOdstraneni.add(vypujcka);
        }
        vypujckyCtenare.removeAll(kOdstraneni);
    }
}

