/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db.extern;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.common.Licensing;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.extern.ExternCtenExecutor;
import cz.kpsys.db.extern.ExternCtenExecutorVFU;
import cz.kpsys.db.extern.loan.ExternalLoanService;
import cz.kpsys.db.extern.loan.ExternalLoanServiceResolver;
import cz.kpsys.db.model.ExternCtenInput;
import cz.kpsys.db.model.ExternCtenModel;
import cz.kpsys.db.model.ExternCtenOutput;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.db.model.v2.tul.TulStudProgramy;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.services.extzdroje.EBooksUtils;
import cz.kpsys.kpwin2.services.extzdroje.ExterniZdrojeProvider;
import cz.kpsys.service.Utils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExternCtenExecutor {
    public static final String URL_EXTERN_TUL = "url_extern_tul";
    private static final int ERR2_NEPLATNA_INSTITUCE = 2;
    private static final int ERR1_DOTAZ_JE_PRAZDNY = 1;
    private static final Logger logger = LoggerFactory.getLogger(ExternCtenExecutor.class);
    private final ExternCtenInput input;
    private final DbCore2 core2;
    private ExternCtenOutput output;
    private QueryRunnerOpened qr;

    public ExternCtenExecutor(DbCore2 core2, ExternCtenInput input) {
        this.core2 = core2;
        this.input = input;
        this.qr = core2.obtainQueryRunnerOpened();
    }

    public static Connection obtainTulConnection() throws AppServerStatus, SQLException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new AppServerStatus("nenalezen MySQL JDBC driver", 1);
        }
        String urlExternTul = KPWINServiceApplication.configuration.urlExternTul();
        if (StringUtils.isBlank((CharSequence)urlExternTul)) {
            throw new IllegalStateException("neni definovan klic url_extern_tul v kpwin.ini");
        }
        Connection conn = DriverManager.getConnection(urlExternTul);
        return conn;
    }

    public static ExternCtenInput parseExternCtenInput(Document doc) throws SQLException, AppServerStatus {
        boolean supportedLibrary;
        1 input = new /* Unavailable Anonymous Inner Class!! */;
        boolean bl = supportedLibrary = Licensing.isTUL() || Licensing.isVSB() || Licensing.isUPCE() || Licensing.isVFU();
        if (!supportedLibrary) {
            throw new AppServerStatus("neplatna instituce, API nepodporovano", 2);
        }
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/extern_cten/";
        for (String key : ExternCtenInput.povoleneTagy) {
            Node paramNode = rootNode.selectSingleNode("//collection/extern_cten/" + key);
            String value = paramNode != null ? paramNode.getText() : null;
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            input.getSearchMap().put(key, value);
        }
        for (Object nodeObject : rootNode.selectNodes("//collection/extern_cten//IGNORUJ")) {
            Node node = (Node)nodeObject;
            String text = node.getText();
            try {
                int id = Integer.parseInt(text);
                input.ignoreList.add(id);
            }
            catch (Exception e) {
                logger.warn("neplatny parametr v tagu INGORUJ: " + text, (Throwable)e);
            }
        }
        return input;
    }

    public static void zpracujExterniObjednavky() {
        logger.info("spustena uloha automatickeho zpracovani externich objednavek");
        try {
            DbCore2 core2 = new DbCore2(ProxoolUtil.obtainConnection());
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            core2.loginAsAS();
            List seznamVypujcek = (List)qr.query("SELECT * FROM VYPUC WHERE FK_TYPPUJC=3 AND CIS_REZE=0", (ResultSetHandler)new KPSYSBeanListHandler(Vypuc.class));
            java.util.Date today = Utils.today();
            for (Vypuc vypuc : seznamVypujcek) {
                try {
                    String oznaceni = vypuc.getOZNAC();
                    if (oznaceni == null || !oznaceni.startsWith(EBooksUtils.EBooksProvider.EREADING.name() + ":") && !oznaceni.startsWith(EBooksUtils.EBooksProvider.FLEXIBOOKS.name() + ":") && !oznaceni.startsWith(EBooksUtils.EBooksProvider.LEVNA_KNIHOVNA.name() + ":") || !GenericExecutor.addDays((java.util.Date)vypuc.getDAT_PROL(), (int)vypuc.getDOB_VYP().shortValue()).before(today)) continue;
                    qr.update("UPDATE VYPUC2 SET DAT_VR=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_VYPUC=?", (Object)vypuc.getFK_VYPUC());
                }
                catch (Exception e) {
                    logger.error("problem pri automatickem vraceni externi objednavky " + vypuc);
                }
            }
            core2.closeConnectionCommit();
        }
        catch (SQLException e) {
            logger.error("problem pri automatickem zpracovani externich objednavek");
        }
    }

    public static void stahniExterniZaznamy() {
        boolean aktualizacePovolena = DbCache2.queryIINIFlagIsTrue((String)IniConstants.SEKCE_EXT_ZDROJE(), (String)IniConstants.EXT_ZDROJE_POVOLIT_AKTUALIZACE(), null, null);
        ExternalLoanServiceResolver externalLoanServiceResolver = (ExternalLoanServiceResolver)KPWINServiceApplication.applicationContext.getBean(ExternalLoanServiceResolver.class);
        if (aktualizacePovolena) {
            logger.info("spustena uloha automatickeho stahovani externich zaznamu");
            DbCore2 core2 = null;
            try {
                core2 = new DbCore2(ProxoolUtil.obtainConnectionBackground());
                for (ExternalLoanService externalLoanService : externalLoanServiceResolver.getAllEnabledSomewhere()) {
                    logger.info("pokus o aktualizaci externi zdroju poskytovatele: " + externalLoanService.provider());
                    ExterniZdrojeProvider specificProvider = externalLoanService.obtainProvider();
                    specificProvider.update();
                }
                core2.closeConnectionCommit();
            }
            catch (Exception e) {
                logger.error("problem pri aktualizaci externich zaznamu", (Throwable)e);
                if (core2 != null) {
                    core2.closeConnectionRollback();
                }
            }
        } else {
            logger.warn("uloha automatickeho stahovani externich zaznamu je zakazana nastavenim v INI [EXT_ZDROJE]POVOLIT_AKTUALIZACE");
        }
    }

    public ExternCtenOutput externCten() throws SQLException, AppServerStatus {
        ExternCtenOutput output = new ExternCtenOutput();
        if (this.input.getSearchMap().isEmpty()) {
            throw new AppServerStatus("dotaz je prazdny", 1);
        }
        if (Licensing.isTUL()) {
            this.externCtenTul(output);
        } else if (!Licensing.isUPCE() && Licensing.isVFU()) {
            ExternCtenExecutorVFU.externCten((ExternCtenInput)this.input, (ExternCtenOutput)output);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externCtenTul(ExternCtenOutput output) throws SQLException, AppServerStatus {
        try (Connection conn = null;){
            long otevreniSpojeniBegin = System.currentTimeMillis();
            conn = ExternCtenExecutor.obtainTulConnection();
            long otevreniSpojeniEnd = System.currentTimeMillis();
            output.otevreniSpojeni = otevreniSpojeniEnd - otevreniSpojeniBegin;
            long casStudentBegin = System.currentTimeMillis();
            List studenti = this.hledejVeView(TulTypCtenEnum.STUDENT, conn);
            long casStudentEnd = System.currentTimeMillis();
            output.casStudent = casStudentEnd - casStudentBegin;
            long casZamestnanecBegin = System.currentTimeMillis();
            List zamestnanci = this.hledejVeView(TulTypCtenEnum.ZAMESTNANEC, conn);
            long casZamestnanecEnd = System.currentTimeMillis();
            output.casZamestnanec = casZamestnanecEnd - casZamestnanecBegin;
            output.getNalezeniCtenari().addAll(studenti);
            output.getNalezeniCtenari().addAll(zamestnanci);
        }
    }

    private List<ExternCtenModel> hledejVeView(TulTypCtenEnum typCten, Connection conn) throws SQLException, AppServerStatus {
        ArrayList<ExternCtenModel> ctenari = new ArrayList<ExternCtenModel>();
        String nazevView = null;
        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
            case 1: {
                nazevView = "student_view_knihovna";
                break;
            }
            case 2: {
                nazevView = "zamestnanec_view_knihovna";
            }
        }
        WherePartPrepravka wherePart = this.pripravWherePart(typCten);
        StringBuilder sb = new StringBuilder("SELECT * FROM " + nazevView + " WHERE ");
        sb.append(wherePart.sqlQueryPart);
        logger.warn("hledani extern_cten v TUL: " + sb.toString());
        logger.warn(wherePart.params.toString());
        PreparedStatement ps = conn.prepareStatement(sb.toString());
        int i = 1;
        for (Object p : wherePart.params) {
            if (p instanceof String) {
                ps.setString(i, p + "%");
            } else if (p instanceof Long) {
                ps.setLong(i, (Long)p);
            } else if (p instanceof Date) {
                ps.setDate(i, (Date)p);
            }
            ++i;
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ExternCtenModel ctenar = new ExternCtenModel();
            switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                case 1: {
                    ctenar.prijmeni = rs.getString("prijmeni");
                    ctenar.jmeno = rs.getString("jmeno");
                    ctenar.titul = Utils.concat((String)rs.getString("tit_pred"), (String)rs.getString("tit_za"), (String)", ");
                    ctenar.datNar = rs.getDate("datum_narozeni");
                    ctenar.barCod = rs.getString("cislo_karty");
                    if (StringUtils.isNotBlank((CharSequence)ctenar.barCod) && !ctenar.barCod.startsWith("U")) {
                        ctenar.barCod = "U" + ctenar.barCod;
                    }
                    String formaStudia = rs.getString("forma_studia");
                    ctenar.typUziv = this.naplnTypUziv(formaStudia);
                    String stavStudenta = rs.getString("stav_studenta");
                    ctenar.stav = this.naplnStavStudenta(ctenar, stavStudenta);
                    ctenar.trvMi = this.zpracujObec(rs.getString("obec"), rs.getString("obec_cast"));
                    ctenar.trvUl = rs.getString("ulice");
                    String cisloUliceCtenar = rs.getString("cislo");
                    if (StringUtils.isNotBlank((CharSequence)cisloUliceCtenar)) {
                        ctenar.trvUl = ctenar.trvUl + " " + cisloUliceCtenar;
                    }
                    ctenar.trvPsc = rs.getString("psc");
                    if (StringUtils.isBlank((CharSequence)ctenar.trvMi)) {
                        ctenar.trvMi = rs.getString("obec_cizi");
                    }
                    ctenar.preUl = null;
                    if (StringUtils.isBlank((CharSequence)ctenar.trvPsc)) {
                        ctenar.trvPsc = rs.getString("psc_cizi");
                    }
                    ctenar.fakulta = rs.getString("fakulta");
                    ctenar.obor = rs.getString("st_program");
                    ctenar.obor = this.dohledejProgramTUL(ctenar.obor);
                    ctenar.email = this.zpracujEmail(ctenar.barCod, rs.getString("email"));
                    ctenar.mobil = rs.getString("mobil");
                    ctenar.uid = rs.getString("rod_cislo");
                    ctenar.getCustomMap().put("CIS_LEG", rs.getString("cislo_cipu"));
                    break;
                }
                case 2: {
                    ctenar.prijmeni = rs.getString("prijmeni");
                    ctenar.jmeno = rs.getString("jmeno");
                    ctenar.titul = Utils.concat((String)rs.getString("tit_pred"), (String)rs.getString("tit_za"), (String)", ");
                    ctenar.datNar = rs.getDate("datum_narozeni");
                    ctenar.barCod = rs.getString("cislo_karty");
                    if (StringUtils.isNotBlank((CharSequence)ctenar.barCod) && !ctenar.barCod.startsWith("U")) {
                        ctenar.barCod = "U" + ctenar.barCod;
                    }
                    ctenar.typUziv = "ZAM";
                    String obec = rs.getString("obec");
                    String castObce = rs.getString("obec_cast");
                    ctenar.trvMi = this.zpracujObec(obec, castObce);
                    ctenar.trvUl = rs.getString("ulice");
                    String cisloUliceZamest = rs.getString("cislo");
                    if (StringUtils.isNotBlank((CharSequence)cisloUliceZamest)) {
                        ctenar.trvUl = ctenar.trvUl + " " + cisloUliceZamest;
                    }
                    ctenar.trvPsc = rs.getString("psc");
                    ctenar.preMi = null;
                    ctenar.preUl = null;
                    ctenar.prePsc = null;
                    ctenar.fakulta = rs.getString("fakulta");
                    ctenar.obor = rs.getString("pracoviste_nazev");
                    if (StringUtils.isBlank((CharSequence)ctenar.obor)) {
                        ctenar.obor = rs.getString("pracoviste");
                    }
                    ctenar.email = this.zpracujEmail(ctenar.barCod, rs.getString("email"));
                    ctenar.mobil = null;
                    ctenar.uid = rs.getString("rod_cislo");
                    ctenar.getCustomMap().put("CIS_LEG", rs.getString("cislo_cipu"));
                }
            }
            ctenari.add(ctenar);
        }
        ps.close();
        return ctenari;
    }

    private String zpracujEmail(String barCod, String email) throws SQLException {
        return email.toLowerCase();
    }

    private String dohledejProgramTUL(String obor) {
        String result = obor;
        try {
            QueryRunner qr = ProxoolUtil.obtainQueryRunnerRO();
            TulStudProgramy program = (TulStudProgramy)qr.query("SELECT * FROM TUL_STUD_PROGRAMY WHERE KOD_PROGRAMU=?", (ResultSetHandler)new BeanHandler(TulStudProgramy.class), new Object[]{obor});
            if (program != null && StringUtils.isNotBlank((CharSequence)program.getNAZEV_PROGRAMU())) {
                result = program.getNAZEV_PROGRAMU();
            }
        }
        catch (SQLException e) {
            logger.error("nepodarilo se dohledat studijni program " + obor, (Throwable)e);
        }
        return result;
    }

    private String naplnTypUziv(String formaStudia) {
        if ("P".equals(formaStudia)) {
            return "DEN";
        }
        if ("K".equals(formaStudia)) {
            return "DALK";
        }
        return "EXT";
    }

    private String naplnStavStudenta(ExternCtenModel ctenar, String stavStudenta) {
        if ("S".equals(stavStudenta)) {
            return "AKTIVNI";
        }
        if ("P".equals(stavStudenta) || "N".equals(stavStudenta)) {
            ctenar.typUziv = "EXT";
            return "AKTIVNI";
        }
        return "NEZNAMY";
    }

    private String zpracujObec(String obec, String castObce) {
        if (StringUtils.isNotBlank((CharSequence)obec) && obec.equals(castObce)) {
            castObce = null;
        }
        return Utils.concat((String)obec, (String)castObce, (String)", \u010d\u00e1st ");
    }

    private WherePartPrepravka pripravWherePart(TulTypCtenEnum typCten) throws AppServerStatus {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        boolean first = true;
        boolean pridatHlavni = true;
        for (String key : this.input.getSearchMap().keySet()) {
            String value = (String)this.input.getSearchMap().get(key);
            int paramsCount = 1;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if (!first) {
                    sb.append(" AND (");
                } else {
                    sb.append(" (");
                    first = false;
                }
                if ("PRIJMENI".equalsIgnoreCase(key)) {
                    sb.append("prijmeni like ?");
                } else if ("JMENO".equalsIgnoreCase(key)) {
                    sb.append("jmeno like ?");
                } else if ("TITUL".equalsIgnoreCase(key)) {
                    sb.append("tit_pred like ? or tit_za like ?");
                    paramsCount = 2;
                } else if ("DAT_NAR".equalsIgnoreCase(key)) {
                    sb.append("datum_narozeni like ?");
                } else if ("BAR_COD".equalsIgnoreCase(key)) {
                    value = this.upravBarCodTUL(value);
                    sb.append("cislo_karty like ?");
                } else {
                    if ("TYP_UZIV".equalsIgnoreCase(key)) {
                        throw new AppServerStatus("neplatny parametr TYP_UZIV", 1);
                    }
                    if ("STAV".equalsIgnoreCase(key)) {
                        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                            case 1: {
                                sb.append("stav_cten like ?");
                                break;
                            }
                            case 2: {
                                paramsCount = 0;
                            }
                        }
                        sb.append("stav_studenta like ?");
                    } else if ("TRV_MI".equalsIgnoreCase(key)) {
                        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                            case 1: {
                                sb.append("obec like ? OR obec_cast like ? OR obec_cizi like ?");
                                paramsCount = 3;
                                break;
                            }
                            case 2: {
                                sb.append("obec like ? OR obec_cast like ?");
                                paramsCount = 2;
                            }
                        }
                    } else if ("TRV_UL".equalsIgnoreCase(key)) {
                        sb.append("ulice like ?");
                    } else if ("TRV_PSC".equalsIgnoreCase(key)) {
                        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                            case 1: {
                                sb.append("psc like ? OR psc_cizi like ?");
                                paramsCount = 2;
                                break;
                            }
                            case 2: {
                                sb.append("psc like ?");
                            }
                        }
                    } else if ("PRE_MI".equalsIgnoreCase(key)) {
                        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                            case 1: {
                                sb.append("obec like ? OR obec_cast like ? OR obec_cizi like ?");
                                paramsCount = 3;
                                break;
                            }
                            case 2: {
                                sb.append("obec like ? OR obec_cast like ?");
                                paramsCount = 2;
                            }
                        }
                    } else if ("PRE_UL".equalsIgnoreCase(key)) {
                        sb.append("ulice like ?");
                    } else if ("PRE_PSC".equalsIgnoreCase(key)) {
                        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                            case 1: {
                                sb.append("psc like ? OR psc_cizi like ?");
                                paramsCount = 2;
                                break;
                            }
                            case 2: {
                                sb.append("psc like ?");
                            }
                        }
                    } else if ("FAKULTA".equalsIgnoreCase(key)) {
                        sb.append("fakulta like ?");
                    } else if ("OBOR".equalsIgnoreCase(key)) {
                        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                            case 1: {
                                sb.append("obor like ?");
                                break;
                            }
                            case 2: {
                                paramsCount = 0;
                            }
                        }
                    } else if ("EMAIL".equalsIgnoreCase(key)) {
                        sb.append("email like ?");
                    } else if ("MOBIL".equalsIgnoreCase(key)) {
                        switch (2.$SwitchMap$cz$kpsys$db$extern$ExternCtenExecutor$TulTypCtenEnum[typCten.ordinal()]) {
                            case 1: {
                                sb.append("mobil like ?");
                                break;
                            }
                            case 2: {
                                paramsCount = 0;
                            }
                        }
                    } else if ("UID".equalsIgnoreCase(key)) {
                        sb.append("rod_cislo like ?");
                    } else if ("ID".equalsIgnoreCase(key)) {
                        sb.append("(((cislo_karty like ? OR cislo_cipu like ? OR cislo_cipu_fides like ? OR rod_cislo like ?) and hlavni = 1) or os_cislo like ?)");
                        params.add(this.upravBarCodTUL(value));
                        paramsCount = 4;
                        pridatHlavni = false;
                    }
                }
                for (int i = 0; i < paramsCount; ++i) {
                    params.add(value);
                }
            }
            sb.append(")");
        }
        if (pridatHlavni) {
            sb.append(" AND hlavni = 1");
        }
        WherePartPrepravka prepravka = new WherePartPrepravka(this);
        prepravka.sqlQueryPart = sb.toString();
        prepravka.params = params;
        return prepravka;
    }

    private String upravBarCodTUL(String value) {
        if (value.length() > 1 && (value.startsWith("U") || value.startsWith("u"))) {
            value = value.substring(1);
        }
        return value;
    }
}

