/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db.file;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.model.NactiBlobInput;
import cz.kpsys.db.model.NactiBlobOutput;
import cz.kpsys.db.model.TypZdroje;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.services.MIMETypeService;
import cz.kpsys.portaro.commons.file.FileUtils;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.StreamUtils;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.thumbnail.Thumbnail;
import cz.kpsys.portaro.commons.thumbnail.ThumbnailProvider;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.text.FileTextProvider;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.springframework.lang.Nullable;

public class NactiBlobExecutor {
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final ThumbnailProvider thumbnailProvider;
    @NonNull
    private final FileTextProvider fileTextProvider;
    @NonNull
    private final FileDataStreamer fileDataStreamer;

    public NactiBlobOutput nactiBlob(NactiBlobInput input) throws AppServerStatus {
        Long fileId = input.getID_FULLTEXT();
        IdentifiedFile file = (IdentifiedFile)this.identifiedFileLoader.getById((Object)fileId);
        if (input.getZDROJ().equals((Object)TypZdroje.NAHLED) && Configuration.thumbnailGenerator != Configuration.THUMBNAIL_GENERATOR.OFF) {
            Thumbnail thumbnail = this.thumbnailProvider.getThumbnail(file);
            return this.writeOutput(input, thumbnail.getInputStream(), thumbnail.getFilename(), Long.valueOf(thumbnail.getSize()));
        }
        if (input.getZDROJ().equals((Object)TypZdroje.TEXT)) {
            String readableText = this.fileTextProvider.getText(file);
            byte[] bytes = readableText.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(bytes);
            return this.writeOutput(input, (InputStream)inputStream2, file.getFilename(), Long.valueOf(bytes.length));
        }
        NactiBlobOutput[] nactiBlobOutput = new NactiBlobOutput[1];
        this.fileDataStreamer.streamData(fileId, (filename, size, inputStream) -> {
            nactiBlobOutput[0] = this.writeOutput(input, inputStream, filename, size);
        });
        return nactiBlobOutput[0];
    }

    private NactiBlobOutput writeOutput(NactiBlobInput input, InputStream inputStream, String filename, @Nullable Long size) {
        NactiBlobOutput output = new NactiBlobOutput();
        if (size != null) {
            output.contentLength = size;
        }
        output.contentType = this.zjistiContentType(filename);
        output.fileName = filename;
        input.headersSetter().apply((Object)output);
        OutputStream outputStream = input.getOutputStream();
        try {
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Exception while writing file input stream to output stream", e);
            }
            catch (Throwable throwable) {
                StreamUtils.quietCloseAll((Closeable[])new Closeable[]{inputStream, outputStream});
                throw throwable;
            }
        }
        StreamUtils.quietCloseAll((Closeable[])new Closeable[]{inputStream, outputStream});
        return output;
    }

    private String zjistiContentType(String filename) {
        return FileUtils.tryParseExtension((String)filename).map(MIMETypeService::zjistiMimeType).orElse("application/octet-stream");
    }

    @ConstructorProperties(value={"identifiedFileLoader", "thumbnailProvider", "fileTextProvider", "fileDataStreamer"})
    @Generated
    public NactiBlobExecutor(@NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull ThumbnailProvider thumbnailProvider, @NonNull FileTextProvider fileTextProvider, @NonNull FileDataStreamer fileDataStreamer) {
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(thumbnailProvider, "thumbnailProvider is marked non-null but is null");
        Objects.requireNonNull(fileTextProvider, "fileTextProvider is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        this.identifiedFileLoader = identifiedFileLoader;
        this.thumbnailProvider = thumbnailProvider;
        this.fileTextProvider = fileTextProvider;
        this.fileDataStreamer = fileDataStreamer;
    }
}

