/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import cz.kpsys.as.config.AppserverApplication;
import cz.kpsys.common.Licensing;
import cz.kpsys.common.registry.SystemRegistry;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.model.intern.SearchCache;
import cz.kpsys.kpwin2.rest.Autoexec;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.rest.ConfigurationFactory;
import cz.kpsys.kpwin2.rest.CustomerSpecificStartupTasks;
import cz.kpsys.kpwin2.rest.LogConfigurator;
import cz.kpsys.kpwin2.rest.StartupUtils;
import cz.kpsys.kpwin2.services.ExternDirMonitorService;
import cz.kpsys.kpwin2.services.FilesystemBlobStorageService;
import cz.kpsys.kpwin2.services.ObalkyKnihService;
import cz.kpsys.kpwin2.services.ProvisioningUtil;
import cz.kpsys.kpwin2.services.SSHService;
import cz.kpsys.kpwin2.services.UzivJmenoGenerator;
import cz.kpsys.marc.SessionData;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.logging.TraceIdRepository;
import cz.kpsys.service.KontrolySpusteni;
import cz.kpsys.service.LuceneManager;
import cz.kpsys.service.MessagesQueueManagerNG;
import cz.kpsys.service.PerfMon;
import cz.kpsys.service.QuartzHelper;
import cz.kpsys.service.TaskQueueManager;
import cz.kpsys.service.TaskQueueManagerNG;
import cz.kpsys.service.Utils;
import cz.kpsys.service.ci.CentralIndexContributorService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.Cipher;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.lucene.search.BooleanQuery;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import scala.util.Properties;

/*
 * Exception performing whole class analysis ignored.
 */
public class KPWINServiceApplication {
    public static final int FORM_CONTENT_SIZE = 0x40000000;
    public static DbConfig dbConfig;
    public static final int EXIT_CODE_CACHE_INVALID = 11;
    public static ConfigurableApplicationContext applicationContext;
    public static Configuration configuration;
    public static Date datumACasSpusteni;
    public static SessionData debugSessionData;
    public static String luceneIndexDir;
    public static boolean reindexPriPujcVrac;
    public static String versionString;
    public static boolean exitOnNextRequest;
    public static String externDir;
    public static FilesystemBlobStorageService blobStorageService;
    public static int externSizeLimit;
    private static Logger logger;
    private static Boolean internalBuild;
    private Connection connKPWIN;
    private ExternDirMonitorService dirMonitorService;

    public static boolean internalBuild() {
        if (internalBuild != null) {
            return internalBuild;
        }
        internalBuild = "true".equalsIgnoreCase(System.getProperty("internal"));
        if (!internalBuild.booleanValue()) {
            logger.info("verejny build " + versionString);
        } else {
            logger.warn("!!! AS spu\u0161t\u011bn v re\u017eimu INTERN\u00cd BUILD !!!");
        }
        return internalBuild;
    }

    public static void preHeat() {
        LogConfigurator.configure();
    }

    public static void main(String[] args) {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        TimeZone.setDefault(CoreConstants.CZECH_TIME_ZONE);
        KPWINServiceApplication.preHeat();
        KPWINServiceApplication application = new KPWINServiceApplication();
        application.parseCommandLine(args);
        application.initConfiguration();
        application.init();
    }

    private static void vaadinDebug() {
        try {
            IOUtils.copy((InputStream)KPWINServiceApplication.class.getClassLoader().getResourceAsStream("cz/kpsys/kpwin2/webface/war/WEB-INF/web.xml"), (OutputStream)new FileOutputStream("/tmp/web.xml"));
        }
        catch (IOException e) {
            logger.error("selhani", (Throwable)e);
        }
    }

    public static void naplanujUkonceniAS(int time) {
        Timer tm = new Timer("ukonceni AS timer thread");
        tm.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, time * 1000);
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static String zpracujHlaseniVyjimky(Exception e) {
        return ExceptionUtils.getMessage((Throwable)e) + "\n" + ExceptionUtils.getStackTrace((Throwable)e);
    }

    public static boolean restrictedCryptography() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES/CBC/PKCS5Padding") < Integer.MAX_VALUE;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The transform \"AES/CBC/PKCS5Padding\" is not available (the availability of this algorithm is mandatory for Java SE implementations)", e);
        }
    }

    private boolean initSystem() {
        Autoexec.autoexec();
        logger.info("scala ve verzi: " + Properties.versionString());
        return true;
    }

    public void initConfiguration() {
        configuration = new Configuration((org.apache.commons.configuration2.Configuration)ConfigurationFactory.createMachineConfig(), (org.apache.commons.configuration2.Configuration)ConfigurationFactory.createAppserverConfig());
        Utils.loadVersionProperties();
        try {
            versionString = Utils.getVersionString();
        }
        catch (Exception e) {
            logger.error("problem pri zjistovani verze AS, neni soubor AS poskozeny?");
            throw e;
        }
        System.getProperties().put("mail.smtp.ssl.trust", "*");
    }

    public String getJavaInfo() {
        return System.getProperty("java.version") + " " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.info") + " " + System.getProperty("java.vm.name");
    }

    public void printJavaInfo() {
        logger.info("java verze: " + this.getJavaInfo());
    }

    public void init() {
        this.initEventBus();
        logger.info("inicializace aplikacniho serveru");
        this.registerForceShutdownHook();
        this.clearTempFiles();
        ProxoolUtil.setupDbConfig((DbConfig)dbConfig);
        applicationContext = SpringApplication.run(AppserverApplication.class, (String[])new String[0]);
        TraceIdRepository traceIdRepository = (TraceIdRepository)applicationContext.getBean(TraceIdRepository.class);
        traceIdRepository.create();
        datumACasSpusteni = Utils.now();
        this.printJavaInfo();
        logger.info("spoustim DB");
        this.startupDb();
        SystemRegistry.registerSystemFactories();
        if (configuration.loginKPWIN()) {
            this.loginAsKpwin();
        }
        this.initLuceneEngine();
        CustomerSpecificStartupTasks.init();
        this.initBlobService();
        if (KPWINServiceApplication.restrictedCryptography()) {
            logger.warn("neni nainstalovana plna verze JCE - omezene moznosti kryptografie");
        }
        ProvisioningUtil.checkValidUUID();
        TaskQueueManager.initService((TaskQueueManager)new TaskQueueManager(traceIdRepository));
        TaskQueueManagerNG.init();
        this.spustProvadeniUlohNaPozadi();
        this.spustSledovaniZmenExternihoAdresare();
        this.initQuartz();
        this.initSystem();
        StartupUtils.updateUtilDir();
        StartupUtils.checkWorkDir();
        StartupUtils.updateNSSMStartupScripts();
        KontrolySpusteni.kontroly();
        this.generujFlatJmeno();
        logger.info("nahazuji CentralIndexContributorService");
        CentralIndexContributorService.getInstance();
        SearchCache.init();
        PerfMon.init();
        logger.info("ziskavam licenceProvider");
        Provider licenceProvider = (Provider)applicationContext.getBean("licenceProvider");
        logger.info("inicializace sluzby zpracovani fronty zprav");
        MessagesQueueManagerNG.init((Provider)licenceProvider);
        SSHService.openBandaskaConnection();
    }

    private void initEventBus() {
        logger.info("nahazuji eventbus");
        Utils.registerEventHandler((Object)this);
    }

    private void registerForceShutdownHook() {
        logger.info("registruji forceShutDownHook");
        Runtime.getRuntime().addShutdownHook((Thread)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void smazMQTTPahoLock() {
        try {
            FileUtils.deleteDirectory((File)new File("as-tcplogkpsyscz1883"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void generujFlatJmeno() {
        UzivJmenoGenerator.generuj();
    }

    private void debugFileAbsolutePath(File file) {
        logger.info("soubor " + file.getAbsolutePath());
    }

    private void clearTempFiles() {
        logger.info("cistim adresar TEMP od starych pracovnich souboru");
        String tempDirString = System.getProperty("java.io.tmpdir");
        if (StringUtils.isNotBlank((CharSequence)tempDirString)) {
            String[] soubory;
            File tempDir = new File(tempDirString);
            for (String soubor : soubory = tempDir.list()) {
                if (!soubor.matches("erd...................\\.xml") && !soubor.matches("erd_book...................\\.xml") && !soubor.matches("jar_cache(.*)\\.tmp")) continue;
                FileUtils.deleteQuietly((File)new File(soubor));
            }
        }
    }

    private void initBlobService() {
        if (configuration.blobDir() != null) {
            logger.info("inicializace externiho uloziste souboru, blob dir: " + configuration.blobDir());
            try {
                blobStorageService = new FilesystemBlobStorageService(configuration.blobDir());
            }
            catch (IOException | ConfigurationException e) {
                logger.error("problem pri inicializaci filesystemblobstorageservice", e);
            }
        }
    }

    private void spustSledovaniZmenExternihoAdresare() {
        logger.info("spusteni sledovani zmen konfiguracnich souboru");
        this.dirMonitorService = new ExternDirMonitorService();
        try {
            this.dirMonitorService.initWatcher();
        }
        catch (Exception e) {
            logger.error("nepodarilo se nahodit automaticke sledovani zmen externich souboru, pripadne zmeny se neprojevi az do dalsiho restartu AS");
        }
    }

    private void initQuartz() {
        logger.info("nahazuji interni job scheduler");
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            QuartzHelper quartzHelper = new QuartzHelper(scheduler);
            quartzHelper.naplanujUlohuAutomatickehoVraceniExternichObjednavek();
            quartzHelper.naplanujUlohuAutomatickehoStazeniExternichZaznamu();
            quartzHelper.naplanujUlohuOdKarantenovani();
            quartzHelper.naplanujUlohuGenerovaniRegistracnichPoplatku();
            quartzHelper.naplanujUlohuEET();
            quartzHelper.naplanujUlohyCisteniNahleduObalkyKnih();
            quartzHelper.naplanujUlohuAnonymizaceCtenaruAVypujcek();
            quartzHelper.naplanujUlohuNastaveniObalekKeStahovani();
            quartzHelper.naplanujUlohuMazaniNepouzitychHeselZRejstriku();
            quartzHelper.naplanujUlohuLuceneCommitOptimize();
            if (Licensing.isNPMK()) {
                quartzHelper.naplanujUlohuOpravaDuplicitnichObjednavekNPMK();
                quartzHelper.naplanujUlohuDoplnLokaci54();
            }
            if (KPWINServiceApplication.configuration.provisioning) {
                quartzHelper.naplanujUlohuProvisioning();
            }
            quartzHelper.naplanujUlohuKontrolaZmenKonfigurace();
            quartzHelper.naplanujUlohuAktualizaceExternichCtenaru();
            scheduler.start();
        }
        catch (Exception e) {
            logger.error("problem pri inicializaci scheduleru Quartz", (Throwable)e);
        }
        ObalkyKnihService.startObalkyKnihService();
    }

    public void spustProvadeniUlohNaPozadi() {
        logger.info("priprava automaticky spoustenych uloh");
        try {
            DbCore2 core2 = new DbCore2(ProxoolUtil.obtainConnection());
            core2.kontrolaIndexuNadLokalizaci();
            DbCore2.naplanujAutomatickeUlohy();
            core2.closeConnectionCommit();
        }
        catch (SQLException se) {
            logger.error("problem pri iniciliazaci naplanovanych uloh", (Throwable)se);
        }
    }

    protected void initLuceneEngine() {
        try {
            logger.info("inicializuji lucene engine");
            BooleanQuery.setMaxClauseCount((int)4096);
            String luceneDir = configuration.indexDir();
            LuceneManager.initLucene((String)luceneDir, (DbConfig)dbConfig);
        }
        catch (Exception se) {
            logger.error("komplikace inicializace Lucene", (Throwable)se);
        }
    }

    protected void startupDb() {
        try {
            configuration.startupDb();
        }
        catch (SQLException e) {
            logger.error("problem pri navazovani spojeni s DB", (Throwable)e);
            System.exit(2);
        }
    }

    void parseCommandLine(String[] args) {
        Options options = new Options();
        options.addOption("uuid", true, "UUID nevim k cemu");
        options.addOption("vurl", true, "verifyURL nevim k cemu");
        options.addOption("tm", "timelimit", true, "time limit - pro spusteni na omezenou dobu");
        DefaultParser parser = new DefaultParser();
        try {
            int time;
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("timelimit") && (time = Integer.parseInt(cmd.getOptionValue("timelimit"))) > 0) {
                exitOnNextRequest = true;
                KPWINServiceApplication.naplanujUkonceniAS((int)time);
            }
        }
        catch (Exception e) {
            System.err.println("selhalo parsovani parametru prikazove radky\n" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void loginAsKpwin() {
        if (ProxoolUtil.engine() != DatabaseEngine.FIREBIRD) {
            return;
        }
        long activeTime = 43200L;
        logger.error("DEBUG MODE: loguji se jako aplikace KPWIN a drzim spojeni po dobu (s): 43200");
        ProxoolUtil.setMaximumActiveTime((Long)43200L);
        try {
            DbConfig dbConfigKP = dbConfig.clone();
            dbConfigKP.username_$eq("KATALOG");
            dbConfigKP.password_$eq("tadeasek");
            HikariConfig configStandard = ProxoolUtil.createHikariConfig((DbConfig)dbConfigKP, (boolean)true);
            configStandard.setPoolName("KPWIN login simulation pool");
            this.connKPWIN = ProxoolUtil.obtainConnection((DataSource)new HikariDataSource(configStandard), (boolean)true);
            if (dbConfigKP.dbEngine() == DatabaseEngine.FIREBIRD) {
                int fkUziv;
                PreparedStatement ps = this.connKPWIN.prepareStatement("SELECT FIRST 1 FK_UZIV FROM DEF_UZIV WHERE UROVEN=0 AND JE_POVOL=1 ORDER BY FK_UZIV");
                ps.execute();
                ResultSet rs = ps.getResultSet();
                if (rs.next()) {
                    fkUziv = rs.getInt("FK_UZIV");
                    rs.close();
                    ps.close();
                } else {
                    rs.close();
                    ps.close();
                    ps = this.connKPWIN.prepareStatement("SELECT FIRST 1 FK_UZIV FROM DEF_UZIV WHERE JE_POVOL=1 ORDER BY FK_UZIV");
                    ps.execute();
                    rs = ps.getResultSet();
                    rs.next();
                    fkUziv = rs.getInt("FK_UZIV");
                    rs.close();
                    ps.close();
                }
                ps = this.connKPWIN.prepareStatement("SELECT USERNAME FROM UZIVATELE WHERE ID_UZIV=?");
                ps.setInt(1, fkUziv);
                ps.execute();
                rs = ps.getResultSet();
                rs.next();
                String userName = rs.getString("USERNAME");
                ps = this.connKPWIN.prepareStatement("SELECT * FROM LOG_IN_USER20(?, ?)");
                ps.setString(1, userName);
                ps.setInt(2, fkUziv);
                if (ps.execute()) {
                    rs = ps.getResultSet();
                    rs.next();
                    debugSessionData = new SessionData();
                    debugSessionData.setTypSession(0);
                    debugSessionData.setUcode(rs.getInt("ID_UZIV"));
                    debugSessionData.setuSess(Long.valueOf(rs.getLong("ROW_ID")));
                    logger.error(debugSessionData.toString());
                }
            } else {
                logger.warn("metoda loginAsKpwin je podporovana pouze pro Firebird");
            }
        }
        catch (Exception e) {
            logger.error("nepodarilo se prihlasit jako KPWIN", (Throwable)e);
        }
    }

    static {
        debugSessionData = null;
        reindexPriPujcVrac = false;
        exitOnNextRequest = false;
        externSizeLimit = 0x100000;
        logger = LoggerFactory.getLogger(KPWINServiceApplication.class);
    }
}

