/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ExternKontoExecutor;
import cz.kpsys.db.model.ExternKontoInput;
import cz.kpsys.db.model.ExternKontoOutput;
import cz.kpsys.db.model.ProlOutput;
import cz.kpsys.db.model.VypucMVSInput;
import cz.kpsys.db.model.VypucMVSOutput;
import cz.kpsys.kpwin2.rest.action.RESTActionsServlet;
import cz.kpsys.marc.SessionData;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternKonto
extends RESTActionsServlet<VypucMVSInput, VypucMVSOutput> {
    private static final Logger logger = LoggerFactory.getLogger(ExternKonto.class);
    static final String externKontoHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<extern_konto>\n";
    static final String externKontoBody = "   <stav_konta>%s</stav_konta>\n";
    static final String externKontoTail = "</extern_konto>\n";

    public String fillOutputTemplate(ExternKontoOutput output) {
        BigDecimal castka = output.stavKonta.setScale(2, RoundingMode.DOWN);
        String castkaString = castka.toPlainString();
        StringBuilder sb = new StringBuilder(externKontoHead);
        sb.append(String.format(externKontoBody, castkaString));
        sb.append(externKontoTail);
        return sb.toString();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.postHandler(req, resp);
    }

    private String fillProlReturnTemplate(ProlOutput prolOutput) {
        return externKontoHead + String.format(externKontoBody, prolOutput.pocDni, prolOutput.pocProl) + externKontoTail;
    }

    public RESTActionsServlet.ResultData<VypucMVSInput, VypucMVSOutput> postCore(Document doc, SessionData sessionData, DbCore2 core2) throws Exception, AppServerStatus {
        ExternKontoInput input = ExternKontoExecutor.parseExternKontoInput((Document)doc, (DbCore2)core2);
        ExternKontoExecutor executor = new ExternKontoExecutor(core2, input);
        ExternKontoOutput output = executor.externKonto();
        return new RESTActionsServlet.ResultData((RESTActionsServlet)this, this.fillOutputTemplate(output), (Object)input, (Object)output);
    }
}

