/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.HledExecutor;
import cz.kpsys.db.HledExecutorNG;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.model.Facet;
import cz.kpsys.db.model.HledInput;
import cz.kpsys.db.model.HledOutput;
import cz.kpsys.db.model.v2.DefRez;
import cz.kpsys.kpwin2.rest.action.API_THREAD_ID;
import cz.kpsys.kpwin2.rest.action.RESTActionsServlet;
import cz.kpsys.kpwin2.rest.common.CacheOnlineWaiter;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.Utils;
import cz.kpsys.service.rezy.RezyFactory;
import cz.kpsys.service.rezy.TGeneratorRezu;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.TextStringBuilder;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

/*
 * Exception performing whole class analysis ignored.
 */
public class Hled
extends RESTActionsServlet<HledInput, HledOutput> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Hled.class);
    private HledInput hledInput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setThreadName(API_THREAD_ID.HLED);
        CacheOnlineWaiter.waitForCacheOnline();
        String query = req.getParameter("q");
        boolean dia = "true".equals(StringUtils.defaultIfBlank((CharSequence)req.getParameter("d"), (CharSequence)"false"));
        boolean prefix = "true".equals(StringUtils.defaultIfBlank((CharSequence)req.getParameter("p"), (CharSequence)"true"));
        String sep = ((String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("s"), (CharSequence)",")).replace("CR", "\r").replace("LF", "\n");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            HledInput hledInput = new HledInput();
            hledInput.query = query;
            hledInput.diacritic = dia;
            hledInput.searchWithFacets = false;
            hledInput.prefix = prefix;
            try {
                DbCore2 core2 = new DbCore2(ProxoolUtil.obtainConnection());
                try {
                    HledExecutor hledExecutor = new HledExecutor(core2, hledInput);
                    try {
                        HledOutput hledOutput = hledExecutor.hled();
                        String nalezeneZaznamy = StringUtils.join((Iterable)hledOutput.ids, (String)sep);
                        resp.setContentType("text/html;charset=utf-8");
                        resp.getWriter().println(nalezeneZaznamy);
                    }
                    catch (Exception e) {
                        logger.error("problem pri GET hledani, vstup: " + hledInput, (Throwable)e);
                        resp.setStatus(500);
                    }
                }
                finally {
                    core2.closeConnectionCommit();
                }
            }
            catch (SQLException e) {
                logger.error("nepodarilo se ziskat spojeni", (Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setThreadName(API_THREAD_ID.HLED);
        this.postHandler(req, resp);
    }

    public boolean validateRelogUser() {
        return false;
    }

    public static String fillHledReturnTemplate(HledInput hledInput, HledOutput hledOutput) {
        TextStringBuilder strBuilder = new TextStringBuilder(4096);
        String diacritic = hledInput.diacritic ? "diacritic=\"true\"" : "diacritic=\"false\"";
        strBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<hled id=\"").append(hledInput.id).append("\" ").append(diacritic).append(">\n");
        strBuilder.append("  <QUERY>").append(Utils.xmlEscape((String)hledInput.query)).append("</QUERY>\n");
        strBuilder.append("  <TOTAL>").append(String.valueOf(hledOutput.total)).append("</TOTAL>\n");
        strBuilder.append("  <COUNT>").append(String.valueOf(hledOutput.outputIds.size())).append("</COUNT>\n");
        strBuilder.append("  <IDS>");
        strBuilder.append(StringUtils.join((Iterable)hledOutput.outputIds, (String)";"));
        strBuilder.append("</IDS>\n");
        strBuilder.append("  <FACETS>\n");
        for (Facet facet : hledOutput.facets) {
            DefRez defRez = DbCache2.rezByName((String)facet.id);
            if (defRez != null) {
                Option rezOption = RezyFactory.rez((int)defRez.getID_REZ());
                if (rezOption.isDefined()) {
                    TGeneratorRezu generatorRezu = (TGeneratorRezu)rezOption.get();
                    String dataType = generatorRezu.datatype().dataTypeId();
                    strBuilder.append("  <FACET id=\"" + Utils.xmlEscape((String)facet.id) + "\" datatype=\"" + dataType + "\" grouping=\"" + facet.grouping.name().toLowerCase() + "\" " + (String)(facet.limit > 0 ? "limit=\"" + facet.limit + "\"" : "") + ">\n");
                    strBuilder.append(HledExecutorNG.fillFacetsOutput((HledInput)hledInput, (HledOutput)hledOutput, (Facet)facet));
                    strBuilder.append("  </FACET>\n");
                    continue;
                }
                logger.warn("pozadovany rez neni v systemu definovan " + facet);
                continue;
            }
            logger.warn("pozadovan nedefinovany rez " + facet);
        }
        strBuilder.append("  </FACETS>\n");
        strBuilder.append("</hled>\n");
        String result = strBuilder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("hled RAW return: \n" + result);
        }
        return result;
    }

    public RESTActionsServlet.ResultData<HledInput, HledOutput> postCore(Document doc, SessionData sessionData, DbCore2 core2) throws Exception {
        Object retString = null;
        this.hledInput = HledExecutor.parseHledInput((Document)doc, (SessionData)sessionData);
        HledExecutor hledExecutor = new HledExecutor(core2, this.hledInput);
        try {
            HledOutput hledOutput = hledExecutor.hled();
            return new RESTActionsServlet.ResultData((RESTActionsServlet)this, Hled.fillHledReturnTemplate((HledInput)this.hledInput, (HledOutput)hledOutput), (Object)this.hledInput, (Object)hledOutput);
        }
        catch (Exception e) {
            logger.error("problem pri hledani, vstup: " + this.hledInput, (Throwable)e);
            throw e;
        }
    }
}

