/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbHelpers;
import cz.kpsys.db.TableDescriptor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ProcedureExecutor.class);
    private DbCore2 core2;

    public ProcedureExecutor(DbCore2 core2) {
        this.core2 = core2;
    }

    public String executeProcedure(Document doc, boolean selectable) throws SQLException {
        if (!selectable) {
            throw new InputMismatchException("procedury nevracejici hodnoty nejsou podporovany");
        }
        Element rootNode = doc.getRootElement();
        Node recordNode = rootNode.selectSingleNode("//collection/record");
        if (recordNode == null) {
            throw new InputMismatchException("dotaz neobsahuje node <record>");
        }
        String procedureName = null;
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        HashMap<String, String> whereParameters = new HashMap<String, String>();
        List procedureNodes = recordNode.selectNodes("*");
        for (Node node : procedureNodes) {
            String paramValue;
            String paramName;
            if (node.getName().equalsIgnoreCase("procedure")) {
                procedureName = node.getText();
            }
            if (node.getName().startsWith("param_")) {
                paramName = node.getName().substring(6).toUpperCase();
                if (!DbHelpers.isValidSQLName((String)paramName)) {
                    throw new InputMismatchException("dotaz obsahuje neplatny parametr: " + paramName);
                }
                paramValue = node.getText();
                inputParameters.put(paramName, paramValue);
                continue;
            }
            if (!node.getName().startsWith("where_")) continue;
            paramName = node.getName().substring(6).toUpperCase();
            if (!DbHelpers.isValidSQLName((String)paramName)) {
                throw new InputMismatchException("dotaz obsahuje neplatny parametr v podmince WHERE: " + paramName);
            }
            paramValue = node.getText();
            whereParameters.put(paramName, paramValue);
        }
        if (procedureName == null || !DbHelpers.isValidSQLName(procedureName)) {
            throw new InputMismatchException("dotaz neobsahuje nazev procedury nebo je chybny: " + procedureName);
        }
        TableDescriptor inputParametersDescriptors = DbCache2.tableDescriptorProvider.getProcedureDescriptor(procedureName, true);
        TableDescriptor outputParametersDescriptors = DbCache2.tableDescriptorProvider.getProcedureDescriptor(procedureName, false);
        if (selectable && outputParametersDescriptors.getTableColumns().size() == 0) {
            throw new InputMismatchException("pozadovano SELECT ... FROM volani procedury ale procedura nevraci zadne hodnoty: " + procedureName);
        }
        StringBuilder sb = new StringBuilder("SELECT * FROM " + procedureName + "\t(" + DbHelpers.generateQuestionMarks((int)inputParameters.size()) + ") ");
        if (whereParameters.size() > 0) {
            sb.append(" WHERE ");
            boolean first = true;
            for (Iterator whereParameter : whereParameters.keySet()) {
                if (!first) {
                    sb.append(" AND ");
                }
                sb.append((String)((Object)whereParameter) + " = ?");
                first = false;
            }
        }
        if (inputParameters.size() != inputParametersDescriptors.getTableColumns().size()) {
            throw new InputMismatchException("pocet predanych parametru (" + inputParameters.size() + ") nesouhlasi se skutecnym poctem parametru (" + inputParametersDescriptors.getTableColumns().size() + ") metody");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("predpripraveny query: " + sb.toString());
        }
        PreparedStatement ps = this.core2.getConnection().prepareStatement(sb.toString());
        int index = 1;
        for (String parameterName : inputParametersDescriptors.getTableColumns().keySet()) {
            this.core2.writeField(index, ps, parameterName, (String)inputParameters.get(parameterName), inputParametersDescriptors);
            ++index;
        }
        for (String parameterName : whereParameters.keySet()) {
            this.core2.writeField(index, ps, parameterName, (String)inputParameters.get(parameterName), inputParametersDescriptors);
            ++index;
        }
        ResultSet rs = ps.executeQuery();
        sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<collection>\n");
        while (rs.next()) {
            sb.append((CharSequence)this.getXMLResultRow(rs));
        }
        sb = sb.append("</collection>");
        return sb.toString();
    }

    private StringBuilder getXMLResultRow(ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder("   <record>\n");
        int columnCount = rs.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = rs.getMetaData().getColumnName(i).toUpperCase();
            sb.append("      <" + columnName + ">" + rs.getObject(i) + "</" + columnName + ">\n");
        }
        sb.append("   </record>\n");
        return sb;
    }
}

