/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.RegistraceExecutor;
import cz.kpsys.db.model.RegistraceInput;
import cz.kpsys.db.model.RegistraceOutput;
import cz.kpsys.kpwin2.rest.action.API_THREAD_ID;
import cz.kpsys.kpwin2.rest.action.RESTActionsServlet;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.Utils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registrace
extends RESTActionsServlet<RegistraceInput, RegistraceOutput> {
    private static final Logger logger = LoggerFactory.getLogger(Registrace.class);
    static final String registraceTemplateHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<registrace>\n";
    static final String registraceTemplateBody = "   <DAT_REG>%s</DAT_REG>\n   <DATP_REG>%s</DATP_REG>\n   <KON_REG>%s</KON_REG>\n   <CASTKA>%s</CASTKA>\n";
    static final String registraceTemplateTail = "</registrace>\n";

    public String fillOutputTemplate(RegistraceOutput output) {
        StringBuilder sb = new StringBuilder(registraceTemplateHead);
        sb.append(String.format(registraceTemplateBody, Utils.sdfSQLDate().format(output.getDatReg()), Utils.sdfSQLDate().format(output.getDatPReg()), Utils.sdfSQLDate().format(output.getKonReg()), output.getCastka().toPlainString()));
        sb.append(registraceTemplateTail);
        return sb.toString();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setThreadName(API_THREAD_ID.REGISTRACE);
        this.postHandler(req, resp);
    }

    public RESTActionsServlet.ResultData<RegistraceInput, RegistraceOutput> postCore(Document doc, SessionData sessionData, DbCore2 core2) throws Exception, AppServerStatus {
        RegistraceInput input = RegistraceExecutor.parseRegistraceInput((Document)doc, (DbCore2)core2);
        RegistraceExecutor executor = new RegistraceExecutor(core2, input);
        RegistraceOutput output = executor.registrace();
        return new RESTActionsServlet.ResultData((RESTActionsServlet)this, this.fillOutputTemplate(output), (Object)input, (Object)output);
    }
}

