/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ZjistiPokutyExecutor;
import cz.kpsys.db.model.ZjistiPokutyInput;
import cz.kpsys.db.model.ZjistiPokutyOutput;
import cz.kpsys.kpwin2.rest.action.API_THREAD_ID;
import cz.kpsys.kpwin2.rest.action.RESTActionsServlet;
import cz.kpsys.marc.SessionData;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZjistiPokuty
extends RESTActionsServlet<ZjistiPokutyInput, ZjistiPokutyOutput> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ZjistiPokuty.class);
    static final String zjistiPokutyTemplateHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<zjisti_pokuty>\n";
    static final String zjistiPokutyTemplateTail = "</zjisti_pokuty>\n";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.postHandler(req, resp);
    }

    public RESTActionsServlet.ResultData<ZjistiPokutyInput, ZjistiPokutyOutput> postCore(Document doc, SessionData sessionData, DbCore2 core2) throws SQLException, AppServerStatus {
        this.setThreadName(API_THREAD_ID.ZJISTI_POKUTY);
        Object retString = null;
        ZjistiPokutyInput input = ZjistiPokutyExecutor.parseZjistiPokutyInput((Document)doc);
        ZjistiPokutyExecutor zjistiPokutyExecutor = new ZjistiPokutyExecutor(core2, input);
        ZjistiPokutyOutput output = zjistiPokutyExecutor.zjistiPokuty();
        return new RESTActionsServlet.ResultData((RESTActionsServlet)this, this.fillZjistiPokutyTemplate(output), (Object)input, (Object)output);
    }

    private String fillZjistiPokutyTemplate(ZjistiPokutyOutput output) {
        DecimalFormat df = new DecimalFormat("#0.##");
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<zjisti_pokuty>\n   <POCET_VYPUJCEK>" + output.pocetVypujcek + "</POCET_VYPUJCEK>\n   <POCET_POKUT>" + output.pocetPokut + "</POCET_POKUT>\n   <CASTKA>" + df.format(output.celkovaCastka) + "</CASTKA>\n" + this.seznamPokutovanych(output) + zjistiPokutyTemplateTail;
    }

    private String seznamPokutovanych(ZjistiPokutyOutput output) {
        StringBuilder sb = new StringBuilder();
        DecimalFormat df = new DecimalFormat("#0.##");
        sb.append("   <POKUTOVANE_VYPUJCKY>\n");
        for (ZjistiPokutyOutput.VypujckaPokutaInfo info : output.pokuty) {
            sb.append("      <VYPUC>\n");
            sb.append("         <ID_VYPUC>" + info.idVypuc + "</ID_VYPUC>\n");
            sb.append("         <NAZEV>" + StringEscapeUtils.escapeXml10((String)info.nazev) + "</NAZEV>\n");
            sb.append("         <CASTKA>" + df.format(info.castka) + "</CASTKA>\n");
            sb.append("      </VYPUC>\n");
        }
        sb.append("   </POKUTOVANE_VYPUJCKY>\n");
        return sb.toString();
    }
}

