/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.actions;

import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.model.InfoOutput;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoExecutor
extends GenericExecutor {
    private static final Logger logger = LoggerFactory.getLogger(InfoExecutor.class);
    private InfoOutput infoOutput;

    public InfoExecutor(DbCore2 core2) {
        this.core2 = core2;
    }

    public InfoOutput info() {
        this.infoOutput = new InfoOutput();
        this.infoOutput.dbUrl = KPWINServiceApplication.dbConfig.jdbcURL();
        this.infoOutput.version = KPWINServiceApplication.versionString;
        this.infoOutput.freeSpaceLogMB = this.zjistiVolneMisto(KPWINServiceApplication.configuration.indexDir());
        this.infoOutput.freeSpaceDbMB = this.zjistiVolneMisto(KPWINServiceApplication.configuration.dbDir());
        return this.infoOutput;
    }

    private int zjistiVolneMisto(String cesta) {
        try {
            FileStore fileStore = Files.getFileStore(FileSystems.getDefault().getPath(cesta, new String[0]));
            return (int)(fileStore.getUsableSpace() / 1024L);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

