/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.health;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.rest.health.HealthResponse;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.service.ConnectionCheckerService;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class Health
extends HttpServlet {
    private final Provider<Licence> licenceProvider;
    private final ConnectionCheckerService connectionCheckerService;
    private final ObjectMapper jsonMapper;

    public Health(ApplicationContext applicationContext) {
        this.licenceProvider = (Provider)applicationContext.getBean("licenceProvider", Provider.class);
        this.connectionCheckerService = (ConnectionCheckerService)applicationContext.getBean(ConnectionCheckerService.class);
        this.jsonMapper = (ObjectMapper)applicationContext.getBean("jsonMapper", ObjectMapper.class);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String status = this.connectionCheckerService.isServiceAvailable() ? "UP" : "DOWN";
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("version", KPWINServiceApplication.versionString);
        details.put("licenceVersion", ((Licence)this.licenceProvider.get()).getLicenceVersion().getValue());
        HealthResponse response = new HealthResponse(status, details);
        resp.setContentType("application/json;charset=utf-8");
        String retString = this.jsonMapper.writeValueAsString((Object)response);
        resp.getWriter().println(retString);
    }
}

