/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.startup;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCore2;
import cz.kpsys.kpwin2.XMLService;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.rest.action.API_THREAD_ID;
import cz.kpsys.kpwin2.rest.action.StartupScala;
import cz.kpsys.kpwin2.rest.startup.LicenceResponse;
import cz.kpsys.kpwin2.rest.startup.ModuleResponse;
import cz.kpsys.kpwin2.rest.startup.StartupResponse;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.Module;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

/*
 * Exception performing whole class analysis ignored.
 */
@Deprecated
public class Startup
extends HttpServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Startup.class);
    @NonNull
    private final Provider<Licence> licenceProvider;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final Converter<String, Department> stringToDepartmentConverter;
    @NonNull
    private final ObjectMapper xmlMapper;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            Department department = Optional.ofNullable(req.getParameter("department")).map(arg_0 -> ((Converter)this.stringToDepartmentConverter).convert(arg_0)).orElseGet((Supplier<Department>)this.rootDepartmentProvider);
            String responseBody = this.postHandler(department);
            this.finish(resp, responseBody);
        }
        catch (AppServerStatus ase) {
            if (ase.getErrorCode() == 1002) {
                resp.setStatus(401);
            } else {
                log.error("nepodarilo se sestavit odpoved", (Throwable)ase);
            }
        }
        catch (Exception e) {
            log.error("problem pri sestavovani odpovedi", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String data = req.getParameter("data");
            if (StringUtils.isBlank((CharSequence)data)) {
                throw new IllegalArgumentException("parametr DATA v POST HTTP pozadavku je prazdny");
            }
            Department department = this.getDepartmentFromXmlOrDefault(data);
            String responseBody = this.postHandler(department);
            this.finish(resp, responseBody);
        }
        catch (AppServerStatus ase) {
            if (ase.getErrorCode() == 1002) {
                resp.setStatus(401);
            } else {
                log.error("nepodarilo se sestavit odpoved", (Throwable)ase);
            }
        }
        catch (Exception e) {
            log.error("problem pri sestavovani odpovedi", (Throwable)e);
        }
    }

    private String postHandler(Department department) throws AppServerStatus {
        Thread.currentThread().setName(API_THREAD_ID.STARTUP.name());
        Licence licence = (Licence)this.licenceProvider.get();
        String dbUrl = Startup.convertToNativeURL((String)KPWINServiceApplication.dbConfig.jdbcURL());
        String remote = KPWINServiceApplication.getConfiguration().getRemote();
        String remoteUrl = null;
        if (StringUtils.isNotBlank((CharSequence)remote)) {
            remoteUrl = this.poskladejURL(remote, dbUrl);
        }
        String URLDlePujcovny = this.najdiURLDlePujcovny(((Integer)department.getId()).intValue());
        dbUrl = this.poskladejURL(URLDlePujcovny, dbUrl);
        DatabaseEngine dbEngine = KPWINServiceApplication.dbConfig.dbEngine();
        String dbEngineVersion = DbCore2.dbEngineVersion((DatabaseEngine)dbEngine);
        StartupResponse startupResponse = new StartupResponse(dbUrl, remoteUrl, dbEngine.name().toLowerCase(Locale.ROOT), dbEngineVersion, KPWINServiceApplication.versionString, Integer.valueOf(StartupScala.requiredVerbisVersion()), licence.getLicenceVersion().getValue(), new LicenceResponse(licence.getLicenceVersion().getValue(), licence.getEditorLimit(), licence.getDocumentLimit(), licence.getMaintenanceExpirationDate(), licence.isTesting(), (Collection)Arrays.stream(Module.values()).filter(arg_0 -> ((Licence)licence).isEnabled(arg_0)).map(Module::getName).map(ModuleResponse::new).collect(Collectors.toList())));
        return this.xmlMapper.writeValueAsString((Object)startupResponse);
    }

    private Department getDepartmentFromXmlOrDefault(String data) {
        try {
            Document doc = XMLService.getDocument((String)data);
            Node pujcovnaNode = doc.getRootElement().selectSingleNode("//collection/pujcovna");
            if (pujcovnaNode != null && StringUtils.isNotBlank((CharSequence)pujcovnaNode.getText())) {
                return (Department)this.stringToDepartmentConverter.convert((Object)pujcovnaNode.getText());
            }
        }
        catch (Exception e) {
            log.warn("Error while parsing startup xml", (Throwable)e);
        }
        return (Department)this.rootDepartmentProvider.get();
    }

    private String najdiURLDlePujcovny(int pujcovna) {
        String url = (String)KPWINServiceApplication.getConfiguration().getURLServeruPodlePujcoven().get("host." + pujcovna);
        if (StringUtils.isBlank((CharSequence)url)) {
            Short nadrazenaPujcovna = DbCache.nejblizsiNadrazenaPujcovna((Short)((short)pujcovna));
            if (nadrazenaPujcovna != null) {
                return this.najdiURLDlePujcovny(nadrazenaPujcovna.intValue());
            }
            return null;
        }
        return url;
    }

    public static String convertToNativeURL(String jdbcURL) {
        String hostPart;
        String[] castiUrl = jdbcURL.split(":");
        if (jdbcURL.contains("oracle:thin")) {
            return jdbcURL;
        }
        if (castiUrl.length == 3) {
            castiUrl = Startup.osetriVariantuBezPortu((String[])castiUrl);
        }
        String result = (hostPart = castiUrl[2]).startsWith("//") ? hostPart.replace("//", "") + "/" + castiUrl[3].replace("/", ":").replace("?lc_ctype=UTF8", "") : castiUrl[2].replace(":", "/") + ":" + castiUrl[3].replace("?lc_ctype=UTF8", "");
        return result;
    }

    private static String[] osetriVariantuBezPortu(String[] castiUrl) {
        String[] ret = new String[4];
        ret[0] = castiUrl[0];
        ret[1] = castiUrl[1];
        String val = castiUrl[2];
        int index = val.indexOf("/", 2);
        ret[2] = val.substring(2, index);
        ret[3] = val.substring(index + 1);
        return ret;
    }

    protected void finish(HttpServletResponse resp, String response) throws IOException {
        resp.setContentType("text/xml;charset=utf-8");
        resp.getWriter().println(response);
        if (log.isDebugEnabled() && !KPWINServiceApplication.internalBuild()) {
            log.debug(response);
        }
    }

    public String poskladejURL(String alternativniIP, String dbUrl) {
        String[] parts;
        if (StringUtils.isNotBlank((CharSequence)alternativniIP)) {
            parts = ((String)dbUrl).split(":");
            if (((String)dbUrl).contains("oracle:thin")) {
                String[] ipPortAlternativni = alternativniIP.split(":");
                if (ipPortAlternativni.length == 2) {
                    parts[4] = ipPortAlternativni[1];
                }
            } else {
                dbUrl = alternativniIP + ":" + parts[1];
            }
        }
        if (((String)dbUrl).contains("oracle:thin")) {
            parts = ((String)dbUrl).split(":");
            dbUrl = parts[3].replace("@", "") + ":" + parts[4] + "/" + parts[5];
        }
        return dbUrl;
    }

    @ConstructorProperties(value={"licenceProvider", "rootDepartmentProvider", "stringToDepartmentConverter", "xmlMapper"})
    @Generated
    public Startup(@NonNull Provider<Licence> licenceProvider, @NonNull Provider<Department> rootDepartmentProvider, @NonNull Converter<String, Department> stringToDepartmentConverter, @NonNull ObjectMapper xmlMapper) {
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(stringToDepartmentConverter, "stringToDepartmentConverter is marked non-null but is null");
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        this.licenceProvider = licenceProvider;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.stringToDepartmentConverter = stringToDepartmentConverter;
        this.xmlMapper = xmlMapper;
    }
}

