/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services;

import cz.kpsys.kpwin2.rest.ConfigurationUtils;
import cz.kpsys.kpwin2.services.FilesystemBlobStorageServiceStats;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemBlobStorageService {
    static final Logger logger = LoggerFactory.getLogger(FilesystemBlobStorageService.class);
    PropertiesConfiguration configuration;
    private String directory;

    public FilesystemBlobStorageService(String directory) throws ConfigurationException, IOException {
        this.directory = directory;
        this.kontrolaOtevreniStorage();
        this.initConfiguration(directory);
        this.kontrolaVerze();
        this.vycistiTemp();
    }

    protected void initConfiguration(String directory) throws IOException {
        File configurationFile = new File(directory + File.separator + "config.properties");
        if (!configurationFile.exists()) {
            configurationFile.createNewFile();
        }
        this.configuration = ConfigurationUtils.createReloadableFileConfiguration((File)configurationFile, (boolean)true);
    }

    public void kontrolaOtevreniStorage() throws FileNotFoundException {
        File dirFile = new File(this.directory);
        if (!dirFile.exists()) {
            logger.info("storage adresar neexistuje, zakladam prazdny: " + this.directory);
            boolean result = dirFile.mkdirs();
            if (!result) {
                String message = "neporadilo se zalozit adresar pro uloziste BLOBu: " + this.directory;
                logger.error(message);
                throw new FileNotFoundException(message);
            }
        }
        if (!dirFile.isDirectory()) {
            throw new FileNotFoundException("nastavena storage cesta neukazuje na adresar " + this.directory);
        }
        if (!dirFile.canWrite()) {
            throw new FileNotFoundException("zapis do adresare neni povolen " + this.directory);
        }
    }

    public void kontrolaVerze() {
        int verze = this.configuration.getInt("version", 0);
        if (verze == 0) {
            this.configuration.setProperty("version", (Object)1);
        }
    }

    public void vycistiTemp() throws IOException {
        File tempDir = new File(this.directory + File.separator + "tmp");
        if (tempDir.exists()) {
            FileUtils.deleteDirectory((File)tempDir);
        }
        tempDir.mkdir();
    }

    public String storeBlob(InputStream is) throws IOException {
        boolean dirCreateResult;
        String uuid = UUID.randomUUID().toString();
        String path = this.pripravCestuZUUUID(uuid);
        File storeDir = new File(this.directory + File.separator + path);
        if (!storeDir.exists() && !(dirCreateResult = storeDir.mkdirs())) {
            throw new IOException("nepodarilo se zalozit pozadovou vetev adresarove struktury " + path);
        }
        String localFilePath = path + File.separator + uuid;
        String filePath = this.directory + File.separator + localFilePath;
        File storedFile = new File(filePath);
        if (storedFile.exists()) {
            throw new IOException("pokus o prepsani souboru ale nevolano update API " + filePath);
        }
        FileOutputStream fos = new FileOutputStream(filePath);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        IOUtils.copyLarge((InputStream)is, (OutputStream)bos);
        bos.close();
        return localFilePath;
    }

    public String opravaCesty(String cesta) {
        if (cesta.contains("\\") && SystemUtils.IS_OS_LINUX) {
            cesta = cesta.replace('\\', '/');
        } else if (cesta.contains("/") && SystemUtils.IS_OS_WINDOWS) {
            cesta = cesta.replace('/', '\\');
        }
        return cesta;
    }

    public InputStream retrieveBlob(String blobId) {
        blobId = this.opravaCesty(blobId);
        File dataFile = new File(this.directory + File.separator + blobId);
        logger.debug("nacitam blob ze souboru " + dataFile.getAbsolutePath());
        try {
            return new BufferedInputStream(new FileInputStream(dataFile));
        }
        catch (FileNotFoundException e) {
            throw new ItemNotFoundException(File.class, (Object)dataFile.getAbsolutePath());
        }
    }

    public long blobSize(String blobId) {
        File dataFile = new File(this.directory + File.separator + (blobId = this.opravaCesty(blobId)));
        if (!dataFile.exists()) {
            throw new ItemNotFoundException(File.class, (Object)dataFile.getAbsolutePath());
        }
        return dataFile.length();
    }

    private String pripravCestuZUUUID(String uuid) {
        return "data" + File.separator + uuid.substring(0, 2) + File.separator + uuid.substring(2, 4) + File.separator + uuid.substring(4, 6);
    }

    public boolean deleteBlob(String blobPathId) {
        blobPathId = this.opravaCesty(blobPathId);
        if (StringUtils.isNotBlank((CharSequence)this.directory)) {
            File blobFile = new File(this.directory + File.separator + blobPathId);
            FileUtils.deleteQuietly((File)blobFile);
            return !blobFile.exists();
        }
        return true;
    }

    public FilesystemBlobStorageServiceStats stats() {
        FilesystemBlobStorageServiceStats stats = new FilesystemBlobStorageServiceStats();
        Iterator it = FileUtils.iterateFiles((File)new File(this.directory + File.separator + "data"), null, (boolean)true);
        while (it.hasNext()) {
            File f = (File)it.next();
            if (f.isDirectory()) {
                ++stats.pocetAdresaru;
                continue;
            }
            ++stats.pocetSouboru;
            stats.obsazeneMisto += f.length();
        }
        return stats;
    }

    public InputStream zakodujBlobIdAsBlob(String blobId) {
        return new ByteArrayInputStream(("BLOB:FS:" + blobId).getBytes(StandardCharsets.UTF_8));
    }
}

