/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services;

import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.services.ProvisioningService$MqttHandler$;
import cz.kpsys.service.Utils;
import cz.kpsys.verbis.api.ASAPI;
import java.io.File;
import java.util.UUID;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.sys.process.package$;

public final class ProvisioningService$ {
    public static ProvisioningService$ MODULE$;
    private String infoCmdChannel;
    private final String GELF_MSG;
    private final String user;
    private final String pass;
    private final Logger logger;
    private final String UUID_KEY;
    private final String timeStartAS;
    private final String timeKpwinINI;
    private MqttClient client;
    private volatile boolean bitmap$0;

    static {
        new ProvisioningService$();
    }

    private String infoCmdChannel$lzycompute() {
        ProvisioningService$ provisioningService$ = this;
        synchronized (provisioningService$) {
            if (!this.bitmap$0) {
                this.infoCmdChannel = "as/cmd/ping";
                this.bitmap$0 = true;
            }
        }
        return this.infoCmdChannel;
    }

    public String infoCmdChannel() {
        if (!this.bitmap$0) {
            return this.infoCmdChannel$lzycompute();
        }
        return this.infoCmdChannel;
    }

    public String GELF_MSG() {
        return this.GELF_MSG;
    }

    public String user() {
        return this.user;
    }

    public String pass() {
        return this.pass;
    }

    public Logger logger() {
        return this.logger;
    }

    public String UUID_KEY() {
        return this.UUID_KEY;
    }

    public String timeStartAS() {
        return this.timeStartAS;
    }

    public String timeKpwinINI() {
        return this.timeKpwinINI;
    }

    public MqttClient client() {
        return this.client;
    }

    public void client_$eq(MqttClient x$1) {
        this.client = x$1;
    }

    public String provisioningPingChannel() {
        return new StringBuilder(14).append("prov/cmd/ping/").append(this.uuid()).toString();
    }

    public void publishPingReply(ASAPI.PingReply reply) {
        this.client().publish(this.infoCmdChannel(), reply.toByteArray(), 1, false);
    }

    public void publishReply(byte[] reply, int qos, boolean retained) {
        this.client().publish(this.infoCmdChannel(), reply, qos, retained);
    }

    public int publishReply$default$2() {
        return 1;
    }

    public boolean publishReply$default$3() {
        return false;
    }

    public void sendValidateUUIDMessage() {
        MqttMessage message = new MqttMessage(new StringBuilder(11).append("VALIDATE ").append(this.uuid()).append(":").append(this.timeStartAS()).append(":").append(this.timeKpwinINI()).toString().getBytes());
        this.client().publish(this.specificCmdChannel(), message);
    }

    public void subscribe() {
        this.client().subscribe((String[])((Object[])new String[]{this.infoCmdChannel(), this.specificCmdChannel()}));
    }

    public void unsubscribe() {
        this.client().unsubscribe((String[])((Object[])new String[]{this.infoCmdChannel(), this.specificCmdChannel()}));
    }

    public String specificCmdChannel() {
        return new StringBuilder(7).append("as/cmd/").append(this.uuid()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String uuid() {
        String string;
        String storedUUID = KPWINServiceApplication.configuration.machineConfiguration.getString(this.UUID_KEY());
        if (StringUtils.isBlank((CharSequence)storedUUID)) {
            String generatedUUID = UUID.randomUUID().toString();
            this.setStoredUUID(generatedUUID);
            string = generatedUUID;
        } else {
            void var2_1;
            string = var2_1;
        }
        void configUUID = string;
        return configUUID;
    }

    public void setStoredUUID(String uuid) {
        KPWINServiceApplication.configuration.machineConfiguration.setProperty(this.UUID_KEY(), (Object)uuid);
    }

    public void init() {
        try {
            this.client_$eq(new MqttClient("tcp://mqtt.kpsys.cz:1883", this.uuid(), (MqttClientPersistence)new MemoryPersistence()));
            MqttConnectOptions options = new MqttConnectOptions();
            options.setWill("as/crash", this.crashHlaseni().getBytes(), 2, false);
            options.setUserName(this.user());
            options.setPassword(this.pass().toCharArray());
            options.setAutomaticReconnect(true);
            options.setCleanSession(true);
            this.client().connect(options);
            this.client().setCallback((MqttCallback)ProvisioningService$MqttHandler$.MODULE$);
            this.sendValidateUUIDMessage();
            this.subscribe();
        }
        catch (Exception e) {
            this.logger().error("selhani", (Throwable)e);
        }
    }

    public String crashHlaseni() {
        return "";
    }

    public void updateAS() {
        if (SystemUtils.IS_OS_LINUX) {
            package$.MODULE$.stringToProcess("updater/updater.sh").run(false);
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            package$.MODULE$.stringToProcess("updater/updater.cmd").$bang();
            return;
        }
    }

    private ProvisioningService$() {
        MODULE$ = this;
        this.GELF_MSG = "mqtt";
        this.user = "as";
        this.pass = Utils.decodeString((String)"VmV2ZFJmbjZoaEhH");
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
        this.UUID_KEY = "uuid";
        this.timeStartAS = Long.toString(KPWINServiceApplication.datumACasSpusteni.getTime());
        File iniFile = new File(Configuration.iniFile());
        this.timeKpwinINI = iniFile.exists() ? Long.toString(iniFile.lastModified()) : Long.toString(Math.abs(RandomUtils.nextLong()));
        this.client = null;
    }
}

