/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services;

import com.thoughtworks.xstream.XStream;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ISBNUtil;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.kpwin2.XMLService;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.services.ZaznamyNarodkaService;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.service.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZaznamyNarodkaService {
    final Logger logger = LoggerFactory.getLogger(ZaznamyNarodkaService.class);
    private String recordsCacheDir;
    private DbCore2 core2;
    private List<CacheZaznam> cacheSeznam = new ArrayList();
    private XStream xStream;

    public ZaznamyNarodkaService(DbCore2 core2) {
        this.core2 = core2;
        this.recordsCacheDir = KPWINServiceApplication.getConfiguration().externCacheDir;
        this.xStream = Utils.obtainNarodkaCacheXStream();
        this.nactiMapuZDisku();
    }

    public void nactiMapuZDisku() {
        File mapaFile = new File(this.recordsCacheDir + File.separator + "erd" + File.separator + "mapa.xml");
        if (mapaFile.exists()) {
            List cacheSeznamTemp = (List)this.xStream.fromXML(mapaFile);
            this.cacheSeznam.clear();
            this.cacheSeznam.addAll(cacheSeznamTemp);
        }
    }

    public void zapisMapuNaDisk() throws IOException {
        File mapaFile = new File(this.recordsCacheDir + File.separator + "mapa.xml");
        String xml = this.xStream.toXML((Object)this.cacheSeznam);
        FileUtils.writeStringToFile((File)mapaFile, (String)xml, (Charset)StandardCharsets.UTF_8);
    }

    public CacheZaznam seznamISBN(String isbn) {
        String normalized = ISBNUtil.normalizujISBN((String)isbn).original();
        for (CacheZaznam zaznam : this.cacheSeznam) {
            if (!zaznam.isbnSeznam.contains(isbn) && !zaznam.isbnSeznam.contains(normalized)) continue;
            return zaznam;
        }
        return null;
    }

    public void generujMapuPredstazenychZaznamu() {
        this.cacheSeznam.clear();
        File cacheDir = new File(this.recordsCacheDir);
        if (!cacheDir.exists()) {
            cacheDir.mkdir();
            return;
        }
        Collection seznamZaznamu = FileUtils.listFiles((File)new File(this.recordsCacheDir), (String[])new String[]{"xml"}, (boolean)false);
        for (File f : seznamZaznamu) {
            if (f.getName().equals("mapa.xml")) continue;
            try {
                Record r = this.nactiRecordZCache(f.getName(), this.core2);
                if (r == null) continue;
                String idERDString = f.getName().replace(".xml", "");
                int idERD = Integer.parseInt(idERDString);
                this.pridejZaznamDoMapy(r, idERD);
            }
            catch (Exception e) {
                this.logger.warn("P: predzpracovany externi zaznam: " + f, (Throwable)e);
            }
        }
        this.logger.debug("generovani mapy dobehlo");
    }

    public void pridejZaznamDoMapy(Record r, int idERD) {
        CacheZaznam cacheZaznam = this.vytvorCacheZaznam(r, idERD);
        this.cacheSeznam.add(cacheZaznam);
    }

    public CacheZaznam vytvorCacheZaznam(Record r, int idERD) {
        List pole020 = r.getFields(20);
        LinkedList<String> isbnVZaznamu = new LinkedList<String>();
        for (Field pole : pole020) {
            String isbnRawA = pole.getSubfieldContent("a");
            String isbnRawX = pole.getSubfieldContent("x");
            String isbnRawZ = pole.getSubfieldContent("z");
            if (StringUtils.isNotBlank((CharSequence)isbnRawA)) {
                isbnVZaznamu.add(isbnRawA);
            }
            if (StringUtils.isNotBlank((CharSequence)isbnRawX)) {
                isbnVZaznamu.add(isbnRawX);
            }
            if (!StringUtils.isNotBlank((CharSequence)isbnRawZ)) continue;
            isbnVZaznamu.add(isbnRawZ);
        }
        CacheZaznam cacheZaznam = new CacheZaznam();
        cacheZaznam.idERD = idERD;
        for (String isbnRaw : isbnVZaznamu) {
            if (!StringUtils.isNotBlank((CharSequence)isbnRaw)) continue;
            String isbn = ISBNUtil.najdiISBNISSNaVyplivniZbytek((String)isbnRaw.trim()).getA();
            String isbnNormalized = ISBNUtil.normalizujISBN((String)isbn).original();
            cacheZaznam.isbnSeznam.add(isbn);
            if (isbnNormalized.equals(isbn)) continue;
            cacheZaznam.isbnSeznam.add(isbnNormalized);
        }
        return cacheZaznam;
    }

    public Record nactiRecordZCache(int idERD, DbCore2 core2) {
        String fileName = String.format("%06d.xml", idERD);
        return this.nactiRecordZCache(fileName, core2);
    }

    public Record nactiRecordZCache(String fileName, DbCore2 core2) {
        try {
            File f = new File(this.recordsCacheDir + File.separator + fileName);
            if (!f.exists() && !(f = new File(this.recordsCacheDir + File.separator + "erd" + File.separator + fileName)).exists()) {
                return null;
            }
            String xml = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isNotBlank((CharSequence)xml)) {
                RecordReconstructor2 rc2 = new RecordReconstructor2(core2);
                Document doc = XMLService.getDocument((String)xml);
                Record r = RecordReconstructor2.recordFromXML((Document)doc);
                return r;
            }
        }
        catch (Exception e) {
            this.logger.error("P: nacteni zaznamu z cache " + fileName, (Throwable)e);
        }
        return null;
    }

    public String getRecordsCacheDir() {
        return this.recordsCacheDir;
    }

    public void setRecordsCacheDir(String recordsCacheDir) {
        this.recordsCacheDir = recordsCacheDir;
    }
}

