/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services.extzdroje;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.kpwin2.XMLService;
import cz.kpsys.kpwin2.services.LongProcessMeter;
import cz.kpsys.kpwin2.services.extzdroje.EBooksUtils;
import cz.kpsys.kpwin2.services.extzdroje.FlexibooksUtils;
import cz.kpsys.kpwin2.services.model.FlexibooksMap;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.RecordExporter;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.service.KPUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.ElementHandler;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexibooksUtils {
    private static final Logger logger = LoggerFactory.getLogger(FlexibooksUtils.class);

    @Deprecated
    public static XStream obtainFLBXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.processAnnotations(FlexibooksMapaRecord.class);
        xstream.processAnnotations(FlexibooksMap.class);
        return xstream;
    }

    protected void generovaniZaznamu(String mapaPath, String definicniSoubor, FlexibooksMap cacheMapa) throws FileNotFoundException, DocumentException, SQLException, IOException {
        logger.info("generuji zaznamy z definicniho  souboru");
        FileReader rd = new FileReader(new File(definicniSoubor));
        Map mapa = this.parsujXMLFlexi((Reader)rd);
        for (String id : mapa.keySet()) {
            this.naplnCacheMapu(cacheMapa, mapa, id);
            String fileName = mapaPath + File.separator + id + ".xml";
            File recordFile = new File(fileName);
            if (recordFile.exists()) continue;
            RecordExporter re = new RecordExporter();
            Record r = this.vytvorMarcZaznam((FlexibooksRecord)mapa.get(id));
            String marcXml = re.marcXml(r, true);
            FileUtils.writeStringToFile((File)recordFile, (String)marcXml, (Charset)StandardCharsets.UTF_8);
        }
    }

    protected void naplnCacheMapu(FlexibooksMap cacheMapa, Map<String, FlexibooksRecord> mapa, String id) {
        FlexibooksRecord fr = mapa.get(id);
        FlexibooksMapaRecord flexibooksMapaRecord = new FlexibooksMapaRecord();
        flexibooksMapaRecord.cenaZaVypujcku = fr.priceLoan;
        flexibooksMapaRecord.id = fr.id;
        flexibooksMapaRecord.url = fr.url;
        cacheMapa.data.put(id, flexibooksMapaRecord);
    }

    protected void dososaniNarodka(DbCore2 core2, String mapaPath, File mapaDir, FlexibooksMap cacheMapa) throws IOException, DocumentException {
        LongProcessMeter longProcessMeter = new LongProcessMeter();
        Iterator it = FileUtils.iterateFiles((File)mapaDir, (String[])new String[]{"xml"}, (boolean)false);
        ArrayList<File> files = new ArrayList<File>(5000);
        while (it.hasNext()) {
            files.add((File)it.next());
        }
        longProcessMeter.setTotalItemsCount(files.size());
        longProcessMeter.start();
        for (File f : files) {
            Record r;
            longProcessMeter.incrementItemsProcessed();
            longProcessMeter.logInfo();
            String flbID = f.getName().replace(".xml", "");
            if (flbID.equals("mapa")) continue;
            RecordReconstructor2 rc2 = new RecordReconstructor2(core2);
            String marcXML = FileUtils.readFileToString((File)f);
            Document doc = XMLService.getDocument((String)marcXML);
            try {
                r = RecordReconstructor2.recordFromXML((Document)doc);
            }
            catch (AppServerStatus e) {
                r = null;
            }
            if (r == null) {
                logger.error("soubor se nepodarilo otevrit jako marc xml zaznam, mazu " + f.getAbsolutePath());
                FileUtils.deleteQuietly((File)f);
                continue;
            }
            String zdrojKatalogizace = r.getOrCreateField(40).getOrCreateSubfield("a").getContent();
            List seznamPole20 = r.getFields(20);
            if ("FLB".equals(zdrojKatalogizace)) {
                EBooksUtils eBooksUtils = new EBooksUtils(core2);
                ArrayList<String> seznamIsbn = new ArrayList<String>();
                for (Field pole20 : seznamPole20) {
                    String isbn = pole20.getOrCreateSubfield("a").getContent();
                    if (!StringUtils.isNotBlank((CharSequence)isbn)) continue;
                    seznamIsbn.add(isbn);
                }
                Record nalezenyZaznam = eBooksUtils.zkusNajitZaznamZkem(seznamIsbn);
                if (nalezenyZaznam != null) {
                    String fileName = mapaPath + File.separator + f.getName();
                    File recordFile = new File(fileName);
                    RecordExporter re = new RecordExporter();
                    String marcXml = re.marcXml(nalezenyZaznam, true);
                    FileUtils.writeStringToFile((File)recordFile, (String)marcXml, (Charset)StandardCharsets.UTF_8);
                }
                KPUtils.sleep((int)2000);
            }
            FlexibooksMapaRecord flexibooksMapaRecord = (FlexibooksMapaRecord)cacheMapa.data.get(flbID);
            for (Field pole20 : seznamPole20) {
                String isbn = pole20.getOrCreateSubfield("a").getContent();
                if (!StringUtils.isNotBlank((CharSequence)isbn)) continue;
                flexibooksMapaRecord.seznamISBN.add(isbn);
                flexibooksMapaRecord.datumGenerovani = r.datumPosledniZmeny();
            }
        }
    }

    public Record vytvorMarcZaznam(FlexibooksRecord flexibooksRecord) {
        Record r = new Record();
        r.setRecordStatus(RecordStatus.FINISHED_CATALOGING.getId().intValue());
        r.getOrCreateField(40).getOrCreateSubfield("a").setContent("FLB");
        r.getOrCreateField(245).getOrCreateSubfield("a").setContent(flexibooksRecord.name);
        if (StringUtils.isNotBlank((CharSequence)flexibooksRecord.isbnEBook)) {
            Field f020 = new Field(20);
            f020.getOrCreateSubfield("a").setContent(flexibooksRecord.isbnEBook);
            r.addField(f020);
        }
        int autorFieldNumber = 100;
        for (String autor : flexibooksRecord.authors) {
            Field autorField = new Field((short)autorFieldNumber);
            autorField.getOrCreateSubfield("a").setContent(autor);
            r.addField(autorField);
            autorFieldNumber = 700;
        }
        if (StringUtils.isNotBlank((CharSequence)flexibooksRecord.publisher)) {
            Field f264 = new Field(264);
            f264.getOrCreateSubfield("b").setContent(flexibooksRecord.publisher);
            String rok = flexibooksRecord.year;
            if (StringUtils.isNotBlank((CharSequence)rok) && rok.length() == 4) {
                f264.getOrCreateSubfield("c").setContent(rok);
            }
        }
        return r;
    }

    public Map<String, FlexibooksRecord> parsujXMLFlexi(Reader rd) throws DocumentException, SQLException {
        HashMap<String, FlexibooksRecord> zdroje = new HashMap<String, FlexibooksRecord>();
        SAXReader reader = new SAXReader();
        reader.addHandler("/output/produkt", (ElementHandler)new /* Unavailable Anonymous Inner Class!! */);
        Document document = reader.read(rd);
        logger.info("dokonceno");
        return zdroje;
    }
}

