/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.tasks;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.AutomatLogger;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenUpomExecutor;
import cz.kpsys.db.IntegerListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.model.GenUpomInput;
import cz.kpsys.db.model.v2.DefAutomat;
import cz.kpsys.kpwin2.tasks.AppServerTimerTask;
import cz.kpsys.service.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerovaniUpominekTimerTask
extends AppServerTimerTask {
    private static final Logger logger = LoggerFactory.getLogger(GenerovaniUpominekTimerTask.class);
    private static final int ERR1_NEPLATNY_PARAMETR = 1;

    public GenerovaniUpominekTimerTask(DefAutomat defAutomat) {
        super(defAutomat);
    }

    public void doJob(Connection conn, DbCore2 core2, QueryRunner qr, AutomatLogger automatLogger) throws SQLException, AppServerStatus {
        logger.info("spoustim generovani upominek");
        List seznamCtenaru = (List)qr.query("SELECT DISTINCT FK_UZIV_CTEN FROM VYPUC", (ResultSetHandler)new IntegerListHandler());
        List seznamPujcovenDleVypujcek = (List)qr.query("SELECT DISTINCT FK_PUJC FROM VYPUC", (ResultSetHandler)BeanHandlers.JSHORT_LIST_HANDLER());
        Set seznamPujcoven = this.zjistiSeznamPujcoven().stream().filter(x -> seznamPujcovenDleVypujcek.contains(x)).collect(Collectors.toSet());
        Iterator iterator = seznamPujcoven.iterator();
        while (iterator.hasNext()) {
            short pujcovna = (Short)iterator.next();
            logger.info("automaticky generuji upominky pro " + (String)(pujcovna == 0 ? "celou knihovnu" : "pujcovnu " + pujcovna));
            for (Integer idCten : seznamCtenaru) {
                try {
                    GenUpomInput input = new GenUpomInput();
                    input.datumGen = Utils.today();
                    input.idCten = idCten;
                    input.idPujc = pujcovna;
                    input.fkUziv = DbCache2.appServerUserID;
                    DbCore2.relogUserCommit((int)input.fkUziv, (short)(pujcovna == 0 ? (Short)DbCache.rootPujcovna().get() : pujcovna), (Connection)conn, (DatabaseEngine)ProxoolUtil.engine());
                    GenUpomExecutor executor = new GenUpomExecutor(core2, input);
                    executor.genUpom();
                    core2.commit();
                }
                catch (Exception e) {
                    logger.error("P: generovani upominek pro ctenare " + idCten, (Throwable)e);
                    core2.rollback();
                }
            }
        }
        logger.info("generovani upominek dobehlo, zpracovano " + seznamCtenaru.size() + " ctenaru");
    }

    public String oznaceniTypuUlohy() {
        return "Generovani upominek";
    }

    private Set<Short> zjistiSeznamPujcoven() throws AppServerStatus {
        String key = "PUJCOVNY=";
        HashSet<Short> seznamPujcoven = new HashSet<Short>();
        String parametry = this.defAutomat.getPARAMETRY();
        if (StringUtils.isBlank((CharSequence)parametry)) {
            seznamPujcoven.add((short)0);
        } else if ((parametry = parametry.trim().toUpperCase()).startsWith("PUJCOVNY=")) {
            StringTokenizer st = new StringTokenizer(parametry.substring("PUJCOVNY=".length()), ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    Short fkPujc = Short.parseShort(token);
                    seznamPujcoven.add(fkPujc);
                }
                catch (NumberFormatException nfe) {
                    logger.warn("chybny parametry - cislo pujcovny " + token + " u naplanovane ulohy " + this.defAutomat);
                }
            }
        } else {
            throw new AppServerStatus("parametr ulohy neni platny, pripustny je pouze PUJCOVNY=...", 1);
        }
        return DbCache.expandujNaPodstromyJava(seznamPujcoven);
    }

    public String toString() {
        return String.format("GenerovaniUpominekTimerTask [toString()=%s]", this.defAutomat != null ? this.defAutomat.toString() : "-");
    }
}

