/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.tasks;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.AutomatLogger;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenVerdenikExecutor;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.model.GenVerdenikInput;
import cz.kpsys.db.model.v2.DefAutomat;
import cz.kpsys.db.model.v2.StatVerdenik;
import cz.kpsys.kpwin2.tasks.AppServerTimerTask;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.Utils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerovaniVerDenikuTimerTask
extends AppServerTimerTask {
    private static final Logger logger = LoggerFactory.getLogger(GenerovaniVerDenikuTimerTask.class);

    public GenerovaniVerDenikuTimerTask(DefAutomat defAutomat) {
        super(defAutomat);
    }

    protected void generujProDatum(DbCore2 core2, java.util.Date datum) throws SQLException {
        GenVerdenikInput input = new GenVerdenikInput();
        input.setDatum(datum);
        GenVerdenikExecutor executor = new GenVerdenikExecutor(core2, input);
        executor.generujAZapis();
    }

    public void doJob(Connection conn, DbCore2 core2, QueryRunner qr, AutomatLogger automatLogger) throws SQLException, AppServerStatus {
        logger.info("spoustim generovani verejneho deniku");
        java.util.Date today = Utils.today();
        long todayLong = Utils.today().getTime();
        java.util.Date datumVypoctu = this.zjistiPrvniDatumVypoctu(core2);
        if (!datumVypoctu.before(today)) {
            logger.info("denik jiz byl vygenerovan, koncim bez provedeni akce");
            return;
        }
        LocalDate aktualniDatumVypoctu = DateConversions.utilDate2localDate((java.util.Date)datumVypoctu);
        boolean repeat = true;
        do {
            logger.info("automaticky generuji verdenik pro datum " + datumVypoctu);
            try {
                this.generujProDatum(core2, datumVypoctu);
            }
            catch (Exception e) {
                logger.error("selhalo generovani deniku pro datum " + Utils.sdfHumanDate().format(datumVypoctu), (Throwable)e);
                throw e;
            }
        } while (repeat = (aktualniDatumVypoctu = aktualniDatumVypoctu.plusDays(1L)).isBefore(LocalDate.now()));
        logger.info("generovani verejneho deniku dobehlo");
    }

    public String oznaceniTypuUlohy() {
        return "Generovani verdeniku";
    }

    private java.util.Date zjistiPrvniDatumVypoctu(DbCore2 core2) throws SQLException {
        QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
        StatVerdenik posledniRadekDeniku = ProxoolUtil.engine() == DatabaseEngine.FIREBIRD ? (StatVerdenik)qr.query("SELECT FIRST 1 * FROM STAT_VERDENIK ORDER BY DATUM DESC", (ResultSetHandler)BeanHandlers.statVerdenikHandler()) : (StatVerdenik)qr.query("SELECT * FROM STAT_VERDENIK WHERE ROWNUM=1 ORDER BY DATUM DESC", (ResultSetHandler)BeanHandlers.statVerdenikHandler());
        if (posledniRadekDeniku == null) {
            return Utils.yesterday();
        }
        java.util.Date datumPredRokem = DateConversions.localDate2utilDate((LocalDate)LocalDate.now().plusYears(-1L));
        Date datumPosledniRadek = posledniRadekDeniku.getDATUM();
        if (datumPosledniRadek.before(datumPredRokem)) {
            return datumPredRokem;
        }
        return GenericExecutor.addDays((java.util.Date)datumPosledniRadek, (int)1);
    }

    public String toString() {
        return String.format("GenerovaniVerDenikuTimerTask", new Object[0]);
    }
}

