/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.tasks;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.AutomatLogger;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.PosilaniPredupominekExecutor;
import cz.kpsys.db.model.PosilaniPredupominekInput;
import cz.kpsys.db.model.v2.DefAutomat;
import cz.kpsys.kpwin2.tasks.AppServerTimerTask;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosilaniPredupominekTimerTask
extends AppServerTimerTask {
    private static final Logger logger = LoggerFactory.getLogger(PosilaniPredupominekTimerTask.class);

    public String oznaceniTypuUlohy() {
        return "Posilani predupominek";
    }

    public PosilaniPredupominekTimerTask(DefAutomat defAutomat) {
        super(defAutomat);
    }

    public void doJob(Connection conn, DbCore2 core2, QueryRunner qr, AutomatLogger automatLogger) throws SQLException, AppServerStatus {
        logger.info("spoustim posilani predupominek");
        PosilaniPredupominekInput input = PosilaniPredupominekExecutor.parsePosilaniPredupominekInput((String)this.defAutomat.getPARAMETRY());
        PosilaniPredupominekExecutor executor = new PosilaniPredupominekExecutor(core2, input);
        executor.posliPredupominky(input);
        if (input.isTestovaciRezim()) {
            core2.rollback();
            logger.info("posilani predupominek v TESTOVACIM rezimu dobehlo");
        } else {
            logger.info("posilani predupominek dobehlo");
        }
    }

    public String toString() {
        return String.format("PosilaniPredupominekTimerTask", new Object[0]);
    }
}

