/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.tasks;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.AutomatLogger;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.model.v2.DefAutomat;
import cz.kpsys.kpwin2.tasks.AppServerTimerTask;
import cz.kpsys.service.Utils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZalohaDBTimerTask
extends AppServerTimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ZalohaDBTimerTask.class);

    public ZalohaDBTimerTask(DefAutomat defAutomat) {
        super(defAutomat);
    }

    public void doJob(Connection conn, DbCore2 core2, QueryRunner qr, AutomatLogger automatLogger) throws SQLException, AppServerStatus {
        boolean created;
        logger.info("spoustim zalohu databaze");
        String path = this.defAutomat.getPARAMETRY();
        boolean absolutFile = path.toLowerCase().endsWith(".fbk");
        File backupDir = absolutFile ? new File(FilenameUtils.getFullPathNoEndSeparator((String)path) + File.separator) : new File(path);
        logger.info("adresar pro zalohu DB " + backupDir);
        if (backupDir.exists() && absolutFile && backupDir.isFile()) {
            logger.error("nastavena cesta zalohy ukazuje na soubor, nutno nastavit adresar");
            throw new AppServerStatus("spatne nastavena cesta", 1);
        }
        if (!backupDir.exists() && !(created = backupDir.mkdirs())) {
            logger.error("nastaveny adresar zalohy neexistuje a ani se jej nepodarilo vytvorit");
            throw new AppServerStatus("adresar neexistuje", 2);
        }
        DbConfig dbConfig = ProxoolUtil.dbConfig;
        String[] urlFrags = dbConfig.jdbcURLFragments();
        String nazevDb = urlFrags[2];
        if (this.nazevDbNeniAlias(nazevDb)) {
            logger.info("nazev db neni alias, pro soubor zalohy volim jmeno verbis");
            nazevDb = "verbis";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String datum = sdf.format(Utils.now());
        String backupFile = absolutFile ? path : String.format("%s" + File.separator + "%s_%s.fbk", backupDir, urlFrags[2], datum);
        logger.error("soubor zalohy " + backupFile);
        DbCore2.backupDB((String)urlFrags[2], (String)urlFrags[0], (int)Integer.parseInt(urlFrags[1]), (String)dbConfig.username(), (String)dbConfig.password(), (String)backupFile);
        logger.info("zalohovani databaze dobehlo");
    }

    public String oznaceniTypuUlohy() {
        return "Zaloha DB";
    }

    private boolean nazevDbNeniAlias(String nazevDb) {
        return !nazevDb.contains(" ") && !nazevDb.contains("/") && !nazevDb.contains(":") && !nazevDb.contains("\\");
    }

    public String toString() {
        return String.format("ZalohaDBTimerTask", new Object[0]);
    }
}

