/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.vsb;

import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.IntegerHandler;
import cz.kpsys.db.PlatbyDbHelper;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefPopl;
import cz.kpsys.db.model.v2.Osoby;
import cz.kpsys.db.model.v2.Platby;
import cz.kpsys.db.model.v2.PlatbyPlaceni;
import cz.kpsys.db.model.v2.PlatbyPlaceniPolozky;
import cz.kpsys.db.model.v2.VsbPlatby;
import cz.kpsys.db.model.v2.message.Message;
import cz.kpsys.db.model.v2.message.MessageSendingEmailAddress;
import cz.kpsys.db.model.v2.message.MessageSendingEmailUtil;
import cz.kpsys.db.model.v2.message.SendingEmailItem;
import cz.kpsys.kpwin2.rest.executors.PlatbyExecutor;
import cz.kpsys.kpwin2.vsb.FindPersonPayments;
import cz.kpsys.kpwin2.vsb.FindPersonPaymentsResponse;
import cz.kpsys.kpwin2.vsb.PayPayment;
import cz.kpsys.kpwin2.vsb.PayPaymentResponse;
import cz.kpsys.kpwin2.vsb.Payment;
import cz.kpsys.kpwin2.vsb.PersonPaymentsImpl;
import cz.kpsys.kpwin2.vsb.SoapKPSYSException;
import cz.kpsys.service.SUtils;
import cz.kpsys.service.Utils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;
import scala.collection.mutable.ArrayBuffer;

@Endpoint
public class PersonPaymentsImpl {
    static final Logger logger = LoggerFactory.getLogger(PersonPaymentsImpl.class);
    private static final short PUJCOVNA_EPS_10 = 10;
    private static final int ERR0_OK = 0;
    private static final int ERR1_PLATBA_JIZ_ZAPSANA = 1;
    private static final int ERR2 = 2;
    private static final int ERR3_PLATBA_NEEXISTUJE = 3;
    private static final int ERR4 = 4;
    private static final int ERR5 = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PayloadRoot(namespace="http://vsb.kpwin2.kpsys.cz/", localPart="findPersonPayments")
    @ResponsePayload
    public FindPersonPaymentsResponse findPersonPayments(@RequestPayload FindPersonPayments findPersonPayments) throws SoapKPSYSException, SQLException {
        FindPersonPaymentsResponse response = new FindPersonPaymentsResponse();
        DbCore2 core2 = new DbCore2(ProxoolUtil.obtainConnection());
        String login = findPersonPayments.getArg0();
        int tarifTypeId = findPersonPayments.getArg1();
        logger.info("findPersonPayments " + login + " " + tarifTypeId);
        try {
            List payments;
            block8: {
                FindPersonPaymentsResponse findPersonPaymentsResponse;
                Integer typPlatby;
                QueryRunnerOpened qr;
                payments = null;
                try {
                    qr = core2.obtainQueryRunnerOpened();
                    typPlatby = (Integer)qr.query("SELECT FK_POPL FROM DEF_POPL_VSB WHERE FK_POPL_VSB=?", (ResultSetHandler)new IntegerHandler(Integer.valueOf(-1)), new Object[]{tarifTypeId});
                    if (typPlatby == null || typPlatby == -1) {
                        return response;
                    }
                }
                catch (SQLException se) {
                    throw new SoapKPSYSException("nepodarilo se nacist definice plateb");
                }
                try {
                    qr = core2.obtainQueryRunnerOpened();
                    Ctenari ctenar = (Ctenari)qr.query("SELECT * FROM CTENARI WHERE CTENARI.FK_UZIV=(SELECT FK_UZIV FROM OSOBY WHERE LOWER(NET_ID)=?)", (ResultSetHandler)BeanHandlers.ctenariHandler(), new Object[]{login});
                    if (ctenar != null) {
                        PlatbyExecutor platbyExecutor = new PlatbyExecutor(core2, ctenar.getFK_UZIV());
                        Map seznamPlateb = platbyExecutor.seznamNeuhrazenychPlateb(typPlatby);
                        payments = this.zpracujPlatbyProVSB((QueryRunner)qr, seznamPlateb, ctenar);
                        break block8;
                    }
                    findPersonPaymentsResponse = response;
                }
                catch (Throwable throwable) {
                    logger.info("findPersonPayments " + login + " " + tarifTypeId + " payments: " + payments);
                    core2.closeConnectionCommit();
                    core2.setConnection(null);
                    throw throwable;
                }
                logger.info("findPersonPayments " + login + " " + tarifTypeId + " payments: " + payments);
                core2.closeConnectionCommit();
                core2.setConnection(null);
                return findPersonPaymentsResponse;
            }
            logger.info("findPersonPayments " + login + " " + tarifTypeId + " payments: " + payments);
            core2.closeConnectionCommit();
            core2.setConnection(null);
            response.getReturn().addAll(payments);
            return response;
        }
        catch (SQLException se) {
            logger.error("P: behem WS metody findPersonPayments", (Throwable)se);
            core2.closeConnectionRollback();
            throw new SoapKPSYSException("2", "doslo k blize neurcene chybe, vice v logu");
        }
    }

    private List<Payment> zpracujPlatbyProVSB(QueryRunner qr, Map<String, List<Platby>> seznamPlateb, Ctenari ctenar) throws SQLException {
        LinkedList<Payment> platby = new LinkedList<Payment>();
        LinkedList<Platby> flattenPlatby = new LinkedList<Platby>();
        for (List<Platby> seznam : seznamPlateb.values()) {
            flattenPlatby.addAll(seznam);
        }
        Map sdruzenePlatby = this.sdruzenePlatby(flattenPlatby);
        this.vygenerujIDckaPlatbamAPoznamenej(qr, sdruzenePlatby, ctenar);
        for (PaymentDefPopl paymentDefPopl : sdruzenePlatby.values()) {
            platby.add(paymentDefPopl.payment);
        }
        return platby;
    }

    public Map<Short, PaymentDefPopl> sdruzenePlatby(List<Platby> flattenPlatby) {
        HashMap<Short, PaymentDefPopl> sdruzenePlatby = new HashMap<Short, PaymentDefPopl>();
        for (Platby platba : flattenPlatby) {
            Short fkPopl = platba.getFK_POPL();
            if (!sdruzenePlatby.containsKey(fkPopl)) {
                PaymentDefPopl paymentDefPopl = new PaymentDefPopl(this);
                paymentDefPopl.payment.amount = BigDecimal.ZERO;
                DefPopl defPopl = (DefPopl)DbCache2.defPoplMap.get(fkPopl);
                paymentDefPopl.payment.title = defPopl != null ? defPopl.getNAZEV() : "nelze ur\u010dit";
                paymentDefPopl.defPopl = defPopl;
                sdruzenePlatby.put(fkPopl, paymentDefPopl);
            }
            Payment payment = ((PaymentDefPopl)sdruzenePlatby.get((Object)fkPopl)).payment;
            payment.amount = payment.amount.add(platba.getCASTKA().negate());
        }
        return sdruzenePlatby;
    }

    private void vygenerujIDckaPlatbamAPoznamenej(QueryRunner qr, Map<Short, PaymentDefPopl> sdruzenePlatby, Ctenari ctenar) throws SQLException {
        for (Short fkPayment : sdruzenePlatby.keySet()) {
            PaymentDefPopl payment = sdruzenePlatby.get(fkPayment);
            this.vygenerujNeboZjistiPaymentId(qr, payment, ctenar);
        }
    }

    private void vygenerujNeboZjistiPaymentId(QueryRunner qr, PaymentDefPopl paymentDefPopl, Ctenari ctenar) throws SQLException {
        long idVsbPlatba;
        VsbPlatby vsbPlatba = new VsbPlatby();
        vsbPlatba.setCASTKA(paymentDefPopl.payment.amount);
        vsbPlatba.setDAT_ZAL(Utils.now());
        vsbPlatba.setFK_CTEN(ctenar.getFK_UZIV());
        vsbPlatba.setFK_POPL(paymentDefPopl.defPopl.getID_POPL());
        VsbPlatby vsbPlatbaZapsana = (VsbPlatby)qr.query("SELECT FIRST 1 * FROM VSB_PLATBY WHERE FK_POPL=? AND FK_CTEN=? ORDER BY ID_VSB_PLATBY DESC", (ResultSetHandler)new BeanHandler(VsbPlatby.class), new Object[]{vsbPlatba.getFK_POPL(), vsbPlatba.getFK_CTEN()});
        if (vsbPlatbaZapsana != null && vsbPlatbaZapsana.getDAT_ZAPL() == null && vsbPlatba.getCASTKA().compareTo(vsbPlatbaZapsana.getCASTKA()) == 0) {
            paymentDefPopl.payment.paymentId = vsbPlatbaZapsana.getID_VSB_PLATBY();
            return;
        }
        paymentDefPopl.payment.paymentId = idVsbPlatba = ((Long)qr.query("INSERT INTO VSB_PLATBY (FK_POPL, CASTKA, DAT_ZAL, FK_CTEN) VALUES (?,?,?,?) RETURNING ID_VSB_PLATBY", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{vsbPlatba.getFK_POPL(), vsbPlatba.getCASTKA(), Utils.util2sqlDate((Date)vsbPlatba.getDAT_ZAL()), vsbPlatba.getFK_CTEN()})).longValue();
    }

    @PayloadRoot(namespace="http://vsb.kpwin2.kpsys.cz/", localPart="payPayment")
    @ResponsePayload
    public PayPaymentResponse payPayment(@RequestPayload PayPayment payPayment) throws SoapKPSYSException {
        PayPaymentResponse response = new PayPaymentResponse();
        DbCore2 core2 = new DbCore2();
        logger.info("payPayment " + payPayment);
        long paymentId = payPayment.getArg0();
        Date paidTimestamp = payPayment.getArg1() == null ? null : payPayment.getArg1().toGregorianCalendar().getTime();
        BigDecimal amount = payPayment.getArg2();
        long epsPaymentNumber = payPayment.getArg3();
        logger.warn("payPayment " + paymentId + " " + paidTimestamp + " " + amount + " " + epsPaymentNumber);
        try {
            VsbPlatby vsbPlatba;
            core2.setConnection(ProxoolUtil.obtainConnection());
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            if (paidTimestamp == null) {
                paidTimestamp = Utils.now();
            }
            if ((vsbPlatba = (VsbPlatby)qr.query("SELECT * FROM VSB_PLATBY WHERE ID_VSB_PLATBY=?", (ResultSetHandler)new BeanHandler(VsbPlatby.class), new Object[]{paymentId})) == null) {
                logger.warn("VSB platba nenalezena");
                core2.closeConnectionCommit();
                response.setReturn(3);
                return response;
            }
            if (vsbPlatba.getDAT_ZAPL() != null) {
                logger.warn("platba jiz byla zapsana");
                core2.closeConnectionCommit();
                response.setReturn(1);
                return response;
            }
            BigDecimal castkaKZaplaceni = this.spoctiDluh(core2, vsbPlatba.getFK_CTEN(), (int)vsbPlatba.getFK_POPL());
            if (castkaKZaplaceni.compareTo(BigDecimal.ZERO) == 0) {
                logger.warn("dluh byl nulovy");
                core2.closeConnectionCommit();
                response.setReturn(2);
                return response;
            }
            if (castkaKZaplaceni.compareTo(vsbPlatba.getCASTKA()) != 0) {
                logger.warn("dluhy jsou rozdilne " + castkaKZaplaceni + " != " + vsbPlatba.getCASTKA() + " (k zaplaceni != dluh");
                core2.closeConnectionCommit();
                response.setReturn(4);
                return response;
            }
            if (castkaKZaplaceni.compareTo(amount) != 0) {
                logger.warn("castka k zaplaceni!=amount -> " + castkaKZaplaceni + " != " + amount);
                core2.closeConnectionCommit();
                response.setReturn(4);
                return response;
            }
            core2.loginAsAS();
            this.zapisPlatbu(qr, vsbPlatba, paidTimestamp, epsPaymentNumber);
            this.posliEmail((QueryRunner)qr, core2, vsbPlatba, paidTimestamp, epsPaymentNumber);
            core2.closeConnectionCommit();
            core2.setConnection(null);
            logger.warn("payPament " + paymentId + " " + paidTimestamp + " " + amount + " " + epsPaymentNumber + " OK");
            response.setReturn(0);
            return response;
        }
        catch (SQLException se) {
            logger.error("P: behem WS metody payPayment", (Throwable)se);
            core2.closeConnectionRollback();
            response.setReturn(5);
            return response;
        }
    }

    private void posliEmail(QueryRunner qr, DbCore2 core2, VsbPlatby vsbPlatba, Date paidTimestamp, long epsPaymentNumber) throws SQLException {
        String emailAddress = DbCache2.vsbExternConfig.getString("blok_cten_platby_email", "katerina.dankova@vsb.cz");
        if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
            try {
                int fkUzivCten = vsbPlatba.getFK_CTEN();
                Ctenari cten = DbCache.ctenar((int)fkUzivCten);
                Osoby osoba = DbCache.osoba((int)fkUzivCten);
                if (cten != null && cten.isSMAZANYBLOKOVANY()) {
                    logger.warn("posilam info, ze blokovany ctenar zaplatil " + cten + " " + vsbPlatba);
                    String subject = "Verbis: info o zaplaceni dluhu ctenarem " + osoba.getNET_ID() + " / " + osoba.formatJmeno();
                    StringBuilder body = new StringBuilder();
                    body.append("Informace o zaplaceni dluhu blokovanym ctenarem\n\n");
                    body.append("Datum:  " + Utils.sdfSQLDateTime().format(paidTimestamp) + "\n");
                    body.append("NET ID: " + osoba.getNET_ID() + "\n");
                    body.append("Jmeno:  " + osoba.formatJmeno() + "\n");
                    body.append("EPS ID: " + epsPaymentNumber + "\n");
                    body.append("Castka: " + vsbPlatba.getCASTKA() + "\n");
                    ArrayBuffer adresy = new ArrayBuffer();
                    MessageSendingEmailAddress adresa = new MessageSendingEmailAddress();
                    adresa.setID(SUtils.uuid());
                    adresa.setEMAIL_ADDRESS(emailAddress);
                    adresa.setADDRESS_TYPE("email-address");
                    adresy.$plus$eq((Object)adresa);
                    adresy.$plus$eq((Object)MessageSendingEmailUtil.genSenderAddressForDepartment((short)10));
                    SendingEmailItem sendingEmailItem = new SendingEmailItem(10, subject, body.toString(), DbCache2.appServerUserID, DbCache2.appServerUserID, Message.TOPIC_OZNAMENI_KNIHOVNY.topicId(), adresy);
                    MessageSendingEmailUtil.storeEmailToSend((SendingEmailItem)sendingEmailItem, (ScalaRunnerOpened)core2.obtainScalaRunnerOpened());
                }
            }
            catch (Exception e) {
                logger.warn("selhalo odeslani emailu - potvrzeni platby - ctenari " + vsbPlatba + " " + epsPaymentNumber, (Throwable)e);
            }
        }
    }

    private void zapisPlatbu(QueryRunnerOpened qr, VsbPlatby vsbPlatba, Date paidTimestamp, long epsPaymentNumber) throws SQLException {
        long idPlatby = (Long)qr.query("INSERT INTO PLATBY (FK_UZIV_VLASTNIK, FK_POPL, CASTKA, DATUM, FK_PUJC, FK_UZIV) VALUES (?,?,?,?,?,?) RETURNING ID_PLATBY", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{vsbPlatba.getFK_CTEN(), vsbPlatba.getFK_POPL(), vsbPlatba.getCASTKA(), Utils.util2sqlDate((Date)paidTimestamp), (short)10, DbCache2.appServerUserID});
        Timestamp now = Utils.sqlNowTimestamp();
        PlatbyPlaceni platbyPlaceni = new PlatbyPlaceni();
        platbyPlaceni.setFK_UZIV(Integer.valueOf(DbCache2.appServerUserID));
        platbyPlaceni.setPROVIDER("external-eps");
        platbyPlaceni.setCAS_VYTVORENI((Date)now);
        platbyPlaceni.setCAS_ZAPLACENI((Date)now);
        platbyPlaceni.setFK_UZIV_PLATCE(Integer.valueOf(vsbPlatba.getFK_CTEN()));
        platbyPlaceni.setFK_PUJC((short)10);
        PlatbyDbHelper.insertPlatbyPlaceni((PlatbyPlaceni)platbyPlaceni, (ScalaRunnerOpened)qr.toScalaRunnerOpened());
        PlatbyPlaceniPolozky polozky = new PlatbyPlaceniPolozky();
        polozky.setFK_PLATBY_PLACENI(platbyPlaceni.getID_PLATBY_PLACENI());
        polozky.setFK_POPL(vsbPlatba.getFK_POPL());
        polozky.setFK_UZIV_VLASTNIK(vsbPlatba.getFK_CTEN());
        polozky.setCASTKA(vsbPlatba.getCASTKA());
        PlatbyDbHelper.insertPlatbyPlaceniPolozky((PlatbyPlaceniPolozky)polozky, (ScalaRunnerOpened)qr.toScalaRunnerOpened());
        qr.update("UPDATE PLATBY SET FK_PLATBY_PLACENI=? WHERE ID_PLATBY=?", new Object[]{platbyPlaceni.getID_PLATBY_PLACENI(), idPlatby});
        qr.update("UPDATE VSB_PLATBY SET DAT_ZAPL=?, FK_EPS_ID=?, FK_PLATBY=? WHERE ID_VSB_PLATBY=?", new Object[]{Utils.util2sqlDate((Date)paidTimestamp), epsPaymentNumber, idPlatby, vsbPlatba.getID_VSB_PLATBY()});
    }

    public BigDecimal spoctiDluh(DbCore2 core2, int fkCten, int fkPopl) throws SQLException {
        PlatbyExecutor platbyExecutor = new PlatbyExecutor(core2, fkCten);
        Map seznamPlateb = platbyExecutor.seznamNeuhrazenychPlateb(Integer.valueOf(fkPopl));
        BigDecimal dluh = BigDecimal.ZERO;
        for (List seznam : seznamPlateb.values()) {
            for (Platby platba : seznam) {
                if (platba.getFK_POPL() != fkPopl) continue;
                dluh = dluh.add(platba.getCASTKA().negate());
            }
        }
        return dluh;
    }
}

