/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.webface.panels;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.zaxxer.hikari.HikariPoolMXBean;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.SearchCachePool;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.webface.VUtils;
import cz.kpsys.service.ForcedUpdateService;
import cz.kpsys.service.Utils;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASInfoPanel
extends VerticalLayout {
    private static final Logger logger = LoggerFactory.getLogger(ASInfoPanel.class);
    private final Div lb;
    MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    ObjectName poolName;
    HikariPoolMXBean poolProxy;

    public ASInfoPanel() {
        try {
            this.poolName = new ObjectName("com.zaxxer.hikari:type=Pool (main)");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        this.poolProxy = JMX.newMXBeanProxy(this.mBeanServer, this.poolName, HikariPoolMXBean.class);
        Button btnClearCache = new Button("Refresh cache");
        btnClearCache.addClickListener((ComponentEventListener & Serializable)event -> {
            try {
                DbCache2.cacheAll();
                Notification.show((String)"Refresh cache vyvol\u00e1n");
            }
            catch (SQLException e) {
                logger.error("selhani", (Throwable)e);
            }
        });
        this.add(new Component[]{btnClearCache});
        this.lb = new Div();
        Button updateButton = new Button("Aktualizace");
        this.add(new Component[]{updateButton});
        updateButton.addClickListener((ComponentEventListener & Serializable)event -> this.updateLabel());
        Div lbDiv = new Div(new Component[]{this.lb});
        this.add(new Component[]{lbDiv});
        this.updateLabel();
        HorizontalLayout vlActionButtons = new HorizontalLayout();
        this.add(new Component[]{vlActionButtons});
        Button btnUpdateAS = new Button("Aktualizovat AS");
        vlActionButtons.add(new Component[]{btnUpdateAS});
        btnUpdateAS.addClickListener((ComponentEventListener & Serializable)event -> this.updateASPreClick());
        Button btnExitAS = new Button("Ukon\u010dit  AS");
        vlActionButtons.add(new Component[]{btnExitAS});
        btnExitAS.addClickListener((ComponentEventListener & Serializable)event -> this.exitASPreClick());
    }

    private void exitASPreClick() {
        Dialog dialog = new Dialog();
        VerticalLayout content = new VerticalLayout();
        dialog.add(new Component[]{content});
        content.setSpacing(true);
        content.setMargin(true);
        content.add(new Component[]{new Label("Opravdu ukon\u010dit AS?")});
        HorizontalLayout hlTlacitka = new HorizontalLayout();
        content.add(new Component[]{hlTlacitka});
        Button okButton = new Button("Ano");
        Button cancelButton = new Button("Ne");
        hlTlacitka.add(new Component[]{okButton});
        hlTlacitka.add(new Component[]{cancelButton});
        okButton.addClickListener((ComponentEventListener & Serializable)event -> new /* Unavailable Anonymous Inner Class!! */.start());
        cancelButton.addClickListener((ComponentEventListener & Serializable)event -> dialog.close());
        dialog.open();
    }

    private void updateASPreClick() {
        Dialog dialog = new Dialog();
        VerticalLayout content = new VerticalLayout();
        dialog.add(new Component[]{content});
        content.setSpacing(true);
        content.setMargin(true);
        content.add(new Component[]{new Label("Opravdu aktualizovat AS?")});
        HorizontalLayout hlTlacitka = new HorizontalLayout();
        content.add(new Component[]{hlTlacitka});
        Button okButton = new Button("Ano");
        Button cancelButton = new Button("Ne");
        hlTlacitka.add(new Component[]{okButton});
        hlTlacitka.add(new Component[]{cancelButton});
        okButton.addClickListener((ComponentEventListener & Serializable)event -> {
            new Thread(ForcedUpdateService::forceUpdate).start();
            dialog.close();
        });
        cancelButton.addClickListener((ComponentEventListener & Serializable)event -> dialog.close());
        dialog.open();
    }

    private void updateLabel() {
        LinkedMap ps = new LinkedMap();
        if (this.poolProxy != null) {
            ps.put("THREADS_AWAITING", "" + this.poolProxy.getThreadsAwaitingConnection());
            ps.put("CONNECTIONS TOTAL / IDLE / ACTIVE", this.poolProxy.getTotalConnections() + " / " + this.poolProxy.getIdleConnections() + " / " + this.poolProxy.getActiveConnections());
        }
        ps.put("CURRENT_TIME", Utils.sdfSQLDateTime().format(Utils.now()));
        ps.put("DB_URL", KPWINServiceApplication.dbConfig.jdbcURL());
        try {
            ps.put("APP_SERVER_PATH", this.getClass().getClassLoader().getResource(".").getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ps.put("PORT", KPWINServiceApplication.getConfiguration().getPortString());
        ps.put("VERSION", KPWINServiceApplication.versionString);
        try {
            ps.put("FB_VERSION", DbCore2.obtainFirebirdServerVersion());
        }
        catch (Exception e) {
            ps.put("FB_VERSION", "N/A");
        }
        ps.put("OS_NAME", SystemUtils.OS_NAME);
        ps.put("OS_VERSION", SystemUtils.OS_VERSION);
        String luceneIndexDir = KPWINServiceApplication.luceneIndexDir;
        ps.put("LUCENE_INDEX_DIR", luceneIndexDir);
        try {
            File lid = new File(luceneIndexDir);
            String freeGB = String.format("%.3f GB", (double)lid.getFreeSpace() / 1024.0 / 1000.0 / 1000.0);
            ps.put("INDEX_DIR_FREE", freeGB);
        }
        catch (Exception e) {
            ps.put("INDEX_DIR_FREE", "nepodarilo se zjistit");
        }
        ps.put("AS_DIR", new File(".").getAbsolutePath());
        ps.put("AS_DATA_DIR", KPWINServiceApplication.getConfiguration().getDataDir());
        ps.put("REMOTE", this.prepRemoteInfo());
        Date date = Utils.now();
        ps.put("DATE_JAVA", date.toString());
        Date dateDb = this.obtainDateFromDb();
        if (dateDb == null) {
            ps.put("DATE_DB", "N/A");
        } else {
            ps.put("DATE_DB", dateDb.toString());
        }
        ps.put("USER.TIMEZONE", System.getProperty("user.timezone", "N/A"));
        ps.put("JAVA.VERSION", System.getProperty("java.version", "N/A"));
        ps.put("SEARCH_POOL", SearchCachePool.poolStatInfo());
        ps.put("WRAPPER_NSSM", String.valueOf(ForcedUpdateService.pritomenNSSMWrapper()));
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        ps.put("MEM_FREE", freeMemory / 1024L / 1024L + " MB");
        ps.put("MEM_ALLOC", allocatedMemory / 1024L / 1024L + " MB");
        ps.put("MEM_MAX", maxMemory / 1024L / 1024L + " MB");
        ps.put("STARTED_ON", Utils.sdfSQLDateTime().format(KPWINServiceApplication.datumACasSpusteni));
        String obsah = this.generujObsah((Map)ps);
        VUtils.setHtml((Component)this.lb, (String)obsah, (boolean)false);
    }

    public String prepRemoteInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("remote: " + (String)StringUtils.defaultIfBlank((CharSequence)KPWINServiceApplication.configuration.getRemote(), (CharSequence)"nenastaveno") + "\n");
        Map mapaPujcUrl = KPWINServiceApplication.configuration.getURLServeruPodlePujcoven();
        Set urlDlePujcKeys = mapaPujcUrl.keySet();
        for (String fkPujc : urlDlePujcKeys) {
            sb.append("fk_pujc: " + fkPujc + " -> " + (String)mapaPujcUrl.get(fkPujc) + "\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date obtainDateFromDb() {
        if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD) {
            Connection conn = null;
            try {
                conn = ProxoolUtil.obtainConnection();
                PreparedStatement ps = conn.prepareStatement("select cast('NOW' as timestamp) from rdb$database");
                ResultSet rs = ps.executeQuery();
                rs.next();
                Timestamp timestamp = rs.getTimestamp(1);
                return timestamp;
            }
            catch (SQLException se) {
                logger.error("selhani", (Throwable)se);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.error("selhani", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    private String generujObsah(Map<String, String> ps) {
        StringBuilder sb = new StringBuilder();
        sb.append("<br><br><TABLE border=\"1\" cellpadding=\"4\"><tr><th>klic</th><th>hodnota</th></tr>\n");
        for (String key : ps.keySet()) {
            String value = ps.get(key);
            sb.append("<tr><td><b>").append(key).append("</b></td><td>").append(StringEscapeUtils.escapeHtml4((String)value)).append("</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }
}

