/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.marc;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.kpsys.service.ICacheSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubField
implements Cloneable,
ICacheSerializer {
    static final Pattern authorityPattern = Pattern.compile(".*[\u0002|\u0003|\u0005](\\d*)(.*?)");
    static final Pattern pCislo = Pattern.compile("(\\d+).*");
    private static final Logger logger = LoggerFactory.getLogger(SubField.class);
    public boolean remapped = false;
    long authLink;
    long zdrojDokLink;
    String interpunkceZa = null;
    String prefix;
    String content;
    private String suffix = null;
    @XStreamOmitField
    private boolean visibility = true;

    public SubField() {
    }

    public SubField(String prefix) {
        this.prefix = prefix;
    }

    public SubField(String prefix, String content) {
        this.prefix = prefix;
        this.content = content;
    }

    public void serializeToCache(ObjectOutputStream os) throws IOException {
        os.writeUTF(this.prefix + this.content);
    }

    public void deserializeFromCache(ObjectInputStream os) throws IOException {
        String prefixContent = os.readUTF();
        this.prefix = prefixContent.substring(0, 1);
        this.content = prefixContent.substring(1);
    }

    public String getInterpunkceZa() {
        return this.interpunkceZa;
    }

    public void setInterpunkceZa(String interpunkceZa) {
        this.interpunkceZa = interpunkceZa;
    }

    public long getAuthLink() {
        return this.authLink;
    }

    public void setAuthLink(long authID) {
        this.authLink = authID;
    }

    public long getAuthLinkID() {
        if (this.authLink > 0L) {
            return Long.parseLong(Long.toString(this.authLink).substring(2));
        }
        return 0L;
    }

    public String toString() {
        return "^" + this.prefix + this.content;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAuthorityLink() {
        return this.content != null && (this.content.contains("\u0002") || this.content.contains("\u0005") || this.content.contains("\u0003"));
    }

    public boolean isSimpleAuthority() {
        return this.content != null && (this.content.contains("\u0002") || this.content.contains("\u0005"));
    }

    public boolean isComplexAuthority() {
        return this.content != null && this.content.contains("\u0003");
    }

    public String getAuthorityLink() {
        Matcher m = authorityPattern.matcher(this.content);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getAuthoritySuffix() {
        if (this.suffix != null) {
            return this.suffix;
        }
        Matcher m = authorityPattern.matcher(this.content);
        this.suffix = m.find() && m.groupCount() == 2 ? m.group(2) : "";
        return this.suffix;
    }

    public String getAuthorityFond() {
        String authorityLink = this.getAuthorityLink();
        if (authorityLink != null) {
            return authorityLink.substring(0, 2);
        }
        return "";
    }

    public String getAuthorityId() {
        return this.getAuthorityLink().substring(2);
    }

    public boolean isVisible() {
        if (this.prefix == null || this.content == null) {
            return false;
        }
        return this.visibility;
    }

    public void setVisible(boolean visibility) {
        this.visibility = false;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        if (content != null && (content.startsWith("\u0002") || content.startsWith("\u0005") || content.startsWith("\u0003"))) {
            try {
                Matcher m;
                if (content.length() > 1 && (m = pCislo.matcher(content.substring(1))).matches()) {
                    this.authLink = Long.parseLong(m.group(1));
                }
            }
            catch (NumberFormatException nfe) {
                logger.debug("selhani", (Throwable)nfe);
            }
        }
        this.suffix = null;
    }

    public String getOrCreateContent(String contentNew) {
        if (this.content == null) {
            this.content = contentNew;
        }
        return this.content;
    }

    public boolean hasVoidContent() {
        return this.content == null || this.content.length() == 0 || !this.visibility;
    }

    public SubField clone() throws CloneNotSupportedException {
        SubField sf = new SubField();
        sf.authLink = this.authLink;
        sf.content = this.content;
        sf.prefix = this.prefix;
        sf.suffix = this.suffix;
        sf.visibility = this.visibility;
        return sf;
    }

    public int getAuthLinkFond() {
        return Integer.parseInt(Long.toString(this.getAuthLink()).substring(0, 2));
    }

    public SubField klonuj() {
        SubField sf = new SubField();
        sf.authLink = this.authLink;
        sf.content = this.content;
        sf.prefix = this.prefix;
        sf.suffix = this.suffix;
        sf.visibility = this.visibility;
        return sf;
    }

    public String getTrimmedContent() {
        if (this.content == null) {
            return null;
        }
        return this.content.trim();
    }
}

