/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FixedThreadBlockingExecutorService
extends AbstractExecutorService {
    private final ExecutorService executor;
    private final Semaphore blockExecution;

    public FixedThreadBlockingExecutorService(int nTreads) {
        this.executor = Executors.newFixedThreadPool(nTreads);
        this.blockExecution = new Semaphore(nTreads);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        this.blockExecution.acquireUninterruptibly();
        return super.submit(task);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        this.blockExecution.release(this.blockExecution.availablePermits());
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(() -> {
            try {
                command.run();
            }
            finally {
                this.blockExecution.release();
            }
        });
    }
}

